/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.arcregionswitch.model.EcsCapacityMonitoringApproach;
import software.amazon.awssdk.services.arcregionswitch.model.EcsUngraceful;
import software.amazon.awssdk.services.arcregionswitch.model.Service;
import software.amazon.awssdk.services.arcregionswitch.model.ServiceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EcsCapacityIncreaseConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EcsCapacityIncreaseConfiguration> {
    private static final SdkField<Integer> TIMEOUT_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("timeoutMinutes").getter(EcsCapacityIncreaseConfiguration.getter(EcsCapacityIncreaseConfiguration::timeoutMinutes)).setter(EcsCapacityIncreaseConfiguration.setter(Builder::timeoutMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutMinutes").build()}).build();
    private static final SdkField<List<Service>> SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("services").getter(EcsCapacityIncreaseConfiguration.getter(EcsCapacityIncreaseConfiguration::services)).setter(EcsCapacityIncreaseConfiguration.setter(Builder::services)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("services").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Service::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EcsUngraceful> UNGRACEFUL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ungraceful").getter(EcsCapacityIncreaseConfiguration.getter(EcsCapacityIncreaseConfiguration::ungraceful)).setter(EcsCapacityIncreaseConfiguration.setter(Builder::ungraceful)).constructor(EcsUngraceful::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ungraceful").build()}).build();
    private static final SdkField<Integer> TARGET_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("targetPercent").getter(EcsCapacityIncreaseConfiguration.getter(EcsCapacityIncreaseConfiguration::targetPercent)).setter(EcsCapacityIncreaseConfiguration.setter(Builder::targetPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetPercent").build()}).build();
    private static final SdkField<String> CAPACITY_MONITORING_APPROACH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("capacityMonitoringApproach").getter(EcsCapacityIncreaseConfiguration.getter(EcsCapacityIncreaseConfiguration::capacityMonitoringApproachAsString)).setter(EcsCapacityIncreaseConfiguration.setter(Builder::capacityMonitoringApproach)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityMonitoringApproach").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEOUT_MINUTES_FIELD, SERVICES_FIELD, UNGRACEFUL_FIELD, TARGET_PERCENT_FIELD, CAPACITY_MONITORING_APPROACH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EcsCapacityIncreaseConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer timeoutMinutes;
    private final List<Service> services;
    private final EcsUngraceful ungraceful;
    private final Integer targetPercent;
    private final String capacityMonitoringApproach;

    private EcsCapacityIncreaseConfiguration(BuilderImpl builder) {
        this.timeoutMinutes = builder.timeoutMinutes;
        this.services = builder.services;
        this.ungraceful = builder.ungraceful;
        this.targetPercent = builder.targetPercent;
        this.capacityMonitoringApproach = builder.capacityMonitoringApproach;
    }

    public final Integer timeoutMinutes() {
        return this.timeoutMinutes;
    }

    public final boolean hasServices() {
        return this.services != null && !(this.services instanceof SdkAutoConstructList);
    }

    public final List<Service> services() {
        return this.services;
    }

    public final EcsUngraceful ungraceful() {
        return this.ungraceful;
    }

    public final Integer targetPercent() {
        return this.targetPercent;
    }

    public final EcsCapacityMonitoringApproach capacityMonitoringApproach() {
        return EcsCapacityMonitoringApproach.fromValue(this.capacityMonitoringApproach);
    }

    public final String capacityMonitoringApproachAsString() {
        return this.capacityMonitoringApproach;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServices() ? this.services() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ungraceful());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityMonitoringApproachAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcsCapacityIncreaseConfiguration)) {
            return false;
        }
        EcsCapacityIncreaseConfiguration other = (EcsCapacityIncreaseConfiguration)obj;
        return Objects.equals(this.timeoutMinutes(), other.timeoutMinutes()) && this.hasServices() == other.hasServices() && Objects.equals(this.services(), other.services()) && Objects.equals(this.ungraceful(), other.ungraceful()) && Objects.equals(this.targetPercent(), other.targetPercent()) && Objects.equals(this.capacityMonitoringApproachAsString(), other.capacityMonitoringApproachAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EcsCapacityIncreaseConfiguration").add("TimeoutMinutes", (Object)this.timeoutMinutes()).add("Services", this.hasServices() ? this.services() : null).add("Ungraceful", (Object)this.ungraceful()).add("TargetPercent", (Object)this.targetPercent()).add("CapacityMonitoringApproach", (Object)this.capacityMonitoringApproachAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "timeoutMinutes": {
                return Optional.ofNullable(clazz.cast(this.timeoutMinutes()));
            }
            case "services": {
                return Optional.ofNullable(clazz.cast(this.services()));
            }
            case "ungraceful": {
                return Optional.ofNullable(clazz.cast(this.ungraceful()));
            }
            case "targetPercent": {
                return Optional.ofNullable(clazz.cast(this.targetPercent()));
            }
            case "capacityMonitoringApproach": {
                return Optional.ofNullable(clazz.cast(this.capacityMonitoringApproachAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("timeoutMinutes", TIMEOUT_MINUTES_FIELD);
        map.put("services", SERVICES_FIELD);
        map.put("ungraceful", UNGRACEFUL_FIELD);
        map.put("targetPercent", TARGET_PERCENT_FIELD);
        map.put("capacityMonitoringApproach", CAPACITY_MONITORING_APPROACH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EcsCapacityIncreaseConfiguration, T> g) {
        return obj -> g.apply((EcsCapacityIncreaseConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer timeoutMinutes;
        private List<Service> services = DefaultSdkAutoConstructList.getInstance();
        private EcsUngraceful ungraceful;
        private Integer targetPercent;
        private String capacityMonitoringApproach;

        private BuilderImpl() {
        }

        private BuilderImpl(EcsCapacityIncreaseConfiguration model) {
            this.timeoutMinutes(model.timeoutMinutes);
            this.services(model.services);
            this.ungraceful(model.ungraceful);
            this.targetPercent(model.targetPercent);
            this.capacityMonitoringApproach(model.capacityMonitoringApproach);
        }

        public final Integer getTimeoutMinutes() {
            return this.timeoutMinutes;
        }

        public final void setTimeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
        }

        @Override
        public final Builder timeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
            return this;
        }

        public final List<Service.Builder> getServices() {
            List<Service.Builder> result = ServiceListCopier.copyToBuilder(this.services);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServices(Collection<Service.BuilderImpl> services) {
            this.services = ServiceListCopier.copyFromBuilder(services);
        }

        @Override
        public final Builder services(Collection<Service> services) {
            this.services = ServiceListCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Service ... services) {
            this.services(Arrays.asList(services));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Consumer<Service.Builder> ... services) {
            this.services(Stream.of(services).map(c -> (Service)((Service.Builder)Service.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final EcsUngraceful.Builder getUngraceful() {
            return this.ungraceful != null ? this.ungraceful.toBuilder() : null;
        }

        public final void setUngraceful(EcsUngraceful.BuilderImpl ungraceful) {
            this.ungraceful = ungraceful != null ? ungraceful.build() : null;
        }

        @Override
        public final Builder ungraceful(EcsUngraceful ungraceful) {
            this.ungraceful = ungraceful;
            return this;
        }

        public final Integer getTargetPercent() {
            return this.targetPercent;
        }

        public final void setTargetPercent(Integer targetPercent) {
            this.targetPercent = targetPercent;
        }

        @Override
        public final Builder targetPercent(Integer targetPercent) {
            this.targetPercent = targetPercent;
            return this;
        }

        public final String getCapacityMonitoringApproach() {
            return this.capacityMonitoringApproach;
        }

        public final void setCapacityMonitoringApproach(String capacityMonitoringApproach) {
            this.capacityMonitoringApproach = capacityMonitoringApproach;
        }

        @Override
        public final Builder capacityMonitoringApproach(String capacityMonitoringApproach) {
            this.capacityMonitoringApproach = capacityMonitoringApproach;
            return this;
        }

        @Override
        public final Builder capacityMonitoringApproach(EcsCapacityMonitoringApproach capacityMonitoringApproach) {
            this.capacityMonitoringApproach(capacityMonitoringApproach == null ? null : capacityMonitoringApproach.toString());
            return this;
        }

        public EcsCapacityIncreaseConfiguration build() {
            return new EcsCapacityIncreaseConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EcsCapacityIncreaseConfiguration> {
        public Builder timeoutMinutes(Integer var1);

        public Builder services(Collection<Service> var1);

        public Builder services(Service ... var1);

        public Builder services(Consumer<Service.Builder> ... var1);

        public Builder ungraceful(EcsUngraceful var1);

        default public Builder ungraceful(Consumer<EcsUngraceful.Builder> ungraceful) {
            return this.ungraceful((EcsUngraceful)((EcsUngraceful.Builder)EcsUngraceful.builder().applyMutation(ungraceful)).build());
        }

        public Builder targetPercent(Integer var1);

        public Builder capacityMonitoringApproach(String var1);

        public Builder capacityMonitoringApproach(EcsCapacityMonitoringApproach var1);
    }
}

