/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceWarningStatus {
    ACTIVE("active"),
    RESOLVED("resolved"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceWarningStatus> VALUE_MAP;
    private final String value;

    private ResourceWarningStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceWarningStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceWarningStatus> knownValues() {
        EnumSet<ResourceWarningStatus> knownValues = EnumSet.allOf(ResourceWarningStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceWarningStatus.class, ResourceWarningStatus::toString);
    }
}

