/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.arcregionswitch.model.AssociatedAlarm;
import software.amazon.awssdk.services.arcregionswitch.model.AssociatedAlarmMapCopier;
import software.amazon.awssdk.services.arcregionswitch.model.RecoveryApproach;
import software.amazon.awssdk.services.arcregionswitch.model.RegionListCopier;
import software.amazon.awssdk.services.arcregionswitch.model.ReportConfiguration;
import software.amazon.awssdk.services.arcregionswitch.model.Trigger;
import software.amazon.awssdk.services.arcregionswitch.model.TriggerListCopier;
import software.amazon.awssdk.services.arcregionswitch.model.Workflow;
import software.amazon.awssdk.services.arcregionswitch.model.WorkflowListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Plan
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Plan> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Plan.getter(Plan::arn)).setter(Plan.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Plan.getter(Plan::description)).setter(Plan.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<Workflow>> WORKFLOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("workflows").getter(Plan.getter(Plan::workflows)).setter(Plan.setter(Builder::workflows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Workflow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRole").getter(Plan.getter(Plan::executionRole)).setter(Plan.setter(Builder::executionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRole").build()}).build();
    private static final SdkField<Integer> RECOVERY_TIME_OBJECTIVE_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("recoveryTimeObjectiveMinutes").getter(Plan.getter(Plan::recoveryTimeObjectiveMinutes)).setter(Plan.setter(Builder::recoveryTimeObjectiveMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryTimeObjectiveMinutes").build()}).build();
    private static final SdkField<Map<String, AssociatedAlarm>> ASSOCIATED_ALARMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("associatedAlarms").getter(Plan.getter(Plan::associatedAlarms)).setter(Plan.setter(Builder::associatedAlarms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedAlarms").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociatedAlarm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<Trigger>> TRIGGERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("triggers").getter(Plan.getter(Plan::triggers)).setter(Plan.setter(Builder::triggers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Trigger::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ReportConfiguration> REPORT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("reportConfiguration").getter(Plan.getter(Plan::reportConfiguration)).setter(Plan.setter(Builder::reportConfiguration)).constructor(ReportConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportConfiguration").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Plan.getter(Plan::name)).setter(Plan.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<String>> REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("regions").getter(Plan.getter(Plan::regions)).setter(Plan.setter(Builder::regions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RECOVERY_APPROACH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recoveryApproach").getter(Plan.getter(Plan::recoveryApproachAsString)).setter(Plan.setter(Builder::recoveryApproach)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryApproach").build()}).build();
    private static final SdkField<String> PRIMARY_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("primaryRegion").getter(Plan.getter(Plan::primaryRegion)).setter(Plan.setter(Builder::primaryRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primaryRegion").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owner").getter(Plan.getter(Plan::owner)).setter(Plan.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(Plan.getter(Plan::version)).setter(Plan.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(Plan.getter(Plan::updatedAt)).setter(Plan.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DESCRIPTION_FIELD, WORKFLOWS_FIELD, EXECUTION_ROLE_FIELD, RECOVERY_TIME_OBJECTIVE_MINUTES_FIELD, ASSOCIATED_ALARMS_FIELD, TRIGGERS_FIELD, REPORT_CONFIGURATION_FIELD, NAME_FIELD, REGIONS_FIELD, RECOVERY_APPROACH_FIELD, PRIMARY_REGION_FIELD, OWNER_FIELD, VERSION_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Plan.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String description;
    private final List<Workflow> workflows;
    private final String executionRole;
    private final Integer recoveryTimeObjectiveMinutes;
    private final Map<String, AssociatedAlarm> associatedAlarms;
    private final List<Trigger> triggers;
    private final ReportConfiguration reportConfiguration;
    private final String name;
    private final List<String> regions;
    private final String recoveryApproach;
    private final String primaryRegion;
    private final String owner;
    private final String version;
    private final Instant updatedAt;

    private Plan(BuilderImpl builder) {
        this.arn = builder.arn;
        this.description = builder.description;
        this.workflows = builder.workflows;
        this.executionRole = builder.executionRole;
        this.recoveryTimeObjectiveMinutes = builder.recoveryTimeObjectiveMinutes;
        this.associatedAlarms = builder.associatedAlarms;
        this.triggers = builder.triggers;
        this.reportConfiguration = builder.reportConfiguration;
        this.name = builder.name;
        this.regions = builder.regions;
        this.recoveryApproach = builder.recoveryApproach;
        this.primaryRegion = builder.primaryRegion;
        this.owner = builder.owner;
        this.version = builder.version;
        this.updatedAt = builder.updatedAt;
    }

    public final String arn() {
        return this.arn;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasWorkflows() {
        return this.workflows != null && !(this.workflows instanceof SdkAutoConstructList);
    }

    public final List<Workflow> workflows() {
        return this.workflows;
    }

    public final String executionRole() {
        return this.executionRole;
    }

    public final Integer recoveryTimeObjectiveMinutes() {
        return this.recoveryTimeObjectiveMinutes;
    }

    public final boolean hasAssociatedAlarms() {
        return this.associatedAlarms != null && !(this.associatedAlarms instanceof SdkAutoConstructMap);
    }

    public final Map<String, AssociatedAlarm> associatedAlarms() {
        return this.associatedAlarms;
    }

    public final boolean hasTriggers() {
        return this.triggers != null && !(this.triggers instanceof SdkAutoConstructList);
    }

    public final List<Trigger> triggers() {
        return this.triggers;
    }

    public final ReportConfiguration reportConfiguration() {
        return this.reportConfiguration;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasRegions() {
        return this.regions != null && !(this.regions instanceof SdkAutoConstructList);
    }

    public final List<String> regions() {
        return this.regions;
    }

    public final RecoveryApproach recoveryApproach() {
        return RecoveryApproach.fromValue(this.recoveryApproach);
    }

    public final String recoveryApproachAsString() {
        return this.recoveryApproach;
    }

    public final String primaryRegion() {
        return this.primaryRegion;
    }

    public final String owner() {
        return this.owner;
    }

    public final String version() {
        return this.version;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkflows() ? this.workflows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryTimeObjectiveMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedAlarms() ? this.associatedAlarms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTriggers() ? this.triggers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.reportConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegions() ? this.regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryApproachAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Plan)) {
            return false;
        }
        Plan other = (Plan)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.description(), other.description()) && this.hasWorkflows() == other.hasWorkflows() && Objects.equals(this.workflows(), other.workflows()) && Objects.equals(this.executionRole(), other.executionRole()) && Objects.equals(this.recoveryTimeObjectiveMinutes(), other.recoveryTimeObjectiveMinutes()) && this.hasAssociatedAlarms() == other.hasAssociatedAlarms() && Objects.equals(this.associatedAlarms(), other.associatedAlarms()) && this.hasTriggers() == other.hasTriggers() && Objects.equals(this.triggers(), other.triggers()) && Objects.equals(this.reportConfiguration(), other.reportConfiguration()) && Objects.equals(this.name(), other.name()) && this.hasRegions() == other.hasRegions() && Objects.equals(this.regions(), other.regions()) && Objects.equals(this.recoveryApproachAsString(), other.recoveryApproachAsString()) && Objects.equals(this.primaryRegion(), other.primaryRegion()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"Plan").add("Arn", (Object)this.arn()).add("Description", (Object)this.description()).add("Workflows", this.hasWorkflows() ? this.workflows() : null).add("ExecutionRole", (Object)this.executionRole()).add("RecoveryTimeObjectiveMinutes", (Object)this.recoveryTimeObjectiveMinutes()).add("AssociatedAlarms", this.hasAssociatedAlarms() ? this.associatedAlarms() : null).add("Triggers", this.hasTriggers() ? this.triggers() : null).add("ReportConfiguration", (Object)this.reportConfiguration()).add("Name", (Object)this.name()).add("Regions", this.hasRegions() ? this.regions() : null).add("RecoveryApproach", (Object)this.recoveryApproachAsString()).add("PrimaryRegion", (Object)this.primaryRegion()).add("Owner", (Object)this.owner()).add("Version", (Object)this.version()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "workflows": {
                return Optional.ofNullable(clazz.cast(this.workflows()));
            }
            case "executionRole": {
                return Optional.ofNullable(clazz.cast(this.executionRole()));
            }
            case "recoveryTimeObjectiveMinutes": {
                return Optional.ofNullable(clazz.cast(this.recoveryTimeObjectiveMinutes()));
            }
            case "associatedAlarms": {
                return Optional.ofNullable(clazz.cast(this.associatedAlarms()));
            }
            case "triggers": {
                return Optional.ofNullable(clazz.cast(this.triggers()));
            }
            case "reportConfiguration": {
                return Optional.ofNullable(clazz.cast(this.reportConfiguration()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "regions": {
                return Optional.ofNullable(clazz.cast(this.regions()));
            }
            case "recoveryApproach": {
                return Optional.ofNullable(clazz.cast(this.recoveryApproachAsString()));
            }
            case "primaryRegion": {
                return Optional.ofNullable(clazz.cast(this.primaryRegion()));
            }
            case "owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("workflows", WORKFLOWS_FIELD);
        map.put("executionRole", EXECUTION_ROLE_FIELD);
        map.put("recoveryTimeObjectiveMinutes", RECOVERY_TIME_OBJECTIVE_MINUTES_FIELD);
        map.put("associatedAlarms", ASSOCIATED_ALARMS_FIELD);
        map.put("triggers", TRIGGERS_FIELD);
        map.put("reportConfiguration", REPORT_CONFIGURATION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("regions", REGIONS_FIELD);
        map.put("recoveryApproach", RECOVERY_APPROACH_FIELD);
        map.put("primaryRegion", PRIMARY_REGION_FIELD);
        map.put("owner", OWNER_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Plan, T> g) {
        return obj -> g.apply((Plan)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String description;
        private List<Workflow> workflows = DefaultSdkAutoConstructList.getInstance();
        private String executionRole;
        private Integer recoveryTimeObjectiveMinutes;
        private Map<String, AssociatedAlarm> associatedAlarms = DefaultSdkAutoConstructMap.getInstance();
        private List<Trigger> triggers = DefaultSdkAutoConstructList.getInstance();
        private ReportConfiguration reportConfiguration;
        private String name;
        private List<String> regions = DefaultSdkAutoConstructList.getInstance();
        private String recoveryApproach;
        private String primaryRegion;
        private String owner;
        private String version;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Plan model) {
            this.arn(model.arn);
            this.description(model.description);
            this.workflows(model.workflows);
            this.executionRole(model.executionRole);
            this.recoveryTimeObjectiveMinutes(model.recoveryTimeObjectiveMinutes);
            this.associatedAlarms(model.associatedAlarms);
            this.triggers(model.triggers);
            this.reportConfiguration(model.reportConfiguration);
            this.name(model.name);
            this.regions(model.regions);
            this.recoveryApproach(model.recoveryApproach);
            this.primaryRegion(model.primaryRegion);
            this.owner(model.owner);
            this.version(model.version);
            this.updatedAt(model.updatedAt);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Workflow.Builder> getWorkflows() {
            List<Workflow.Builder> result = WorkflowListCopier.copyToBuilder(this.workflows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkflows(Collection<Workflow.BuilderImpl> workflows) {
            this.workflows = WorkflowListCopier.copyFromBuilder(workflows);
        }

        @Override
        public final Builder workflows(Collection<Workflow> workflows) {
            this.workflows = WorkflowListCopier.copy(workflows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflows(Workflow ... workflows) {
            this.workflows(Arrays.asList(workflows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflows(Consumer<Workflow.Builder> ... workflows) {
            this.workflows(Stream.of(workflows).map(c -> (Workflow)((Workflow.Builder)Workflow.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getExecutionRole() {
            return this.executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final Integer getRecoveryTimeObjectiveMinutes() {
            return this.recoveryTimeObjectiveMinutes;
        }

        public final void setRecoveryTimeObjectiveMinutes(Integer recoveryTimeObjectiveMinutes) {
            this.recoveryTimeObjectiveMinutes = recoveryTimeObjectiveMinutes;
        }

        @Override
        public final Builder recoveryTimeObjectiveMinutes(Integer recoveryTimeObjectiveMinutes) {
            this.recoveryTimeObjectiveMinutes = recoveryTimeObjectiveMinutes;
            return this;
        }

        public final Map<String, AssociatedAlarm.Builder> getAssociatedAlarms() {
            Map<String, AssociatedAlarm.Builder> result = AssociatedAlarmMapCopier.copyToBuilder(this.associatedAlarms);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAssociatedAlarms(Map<String, AssociatedAlarm.BuilderImpl> associatedAlarms) {
            this.associatedAlarms = AssociatedAlarmMapCopier.copyFromBuilder(associatedAlarms);
        }

        @Override
        public final Builder associatedAlarms(Map<String, AssociatedAlarm> associatedAlarms) {
            this.associatedAlarms = AssociatedAlarmMapCopier.copy(associatedAlarms);
            return this;
        }

        public final List<Trigger.Builder> getTriggers() {
            List<Trigger.Builder> result = TriggerListCopier.copyToBuilder(this.triggers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTriggers(Collection<Trigger.BuilderImpl> triggers) {
            this.triggers = TriggerListCopier.copyFromBuilder(triggers);
        }

        @Override
        public final Builder triggers(Collection<Trigger> triggers) {
            this.triggers = TriggerListCopier.copy(triggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(Trigger ... triggers) {
            this.triggers(Arrays.asList(triggers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(Consumer<Trigger.Builder> ... triggers) {
            this.triggers(Stream.of(triggers).map(c -> (Trigger)((Trigger.Builder)Trigger.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ReportConfiguration.Builder getReportConfiguration() {
            return this.reportConfiguration != null ? this.reportConfiguration.toBuilder() : null;
        }

        public final void setReportConfiguration(ReportConfiguration.BuilderImpl reportConfiguration) {
            this.reportConfiguration = reportConfiguration != null ? reportConfiguration.build() : null;
        }

        @Override
        public final Builder reportConfiguration(ReportConfiguration reportConfiguration) {
            this.reportConfiguration = reportConfiguration;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getRegions() {
            if (this.regions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        public final String getRecoveryApproach() {
            return this.recoveryApproach;
        }

        public final void setRecoveryApproach(String recoveryApproach) {
            this.recoveryApproach = recoveryApproach;
        }

        @Override
        public final Builder recoveryApproach(String recoveryApproach) {
            this.recoveryApproach = recoveryApproach;
            return this;
        }

        @Override
        public final Builder recoveryApproach(RecoveryApproach recoveryApproach) {
            this.recoveryApproach(recoveryApproach == null ? null : recoveryApproach.toString());
            return this;
        }

        public final String getPrimaryRegion() {
            return this.primaryRegion;
        }

        public final void setPrimaryRegion(String primaryRegion) {
            this.primaryRegion = primaryRegion;
        }

        @Override
        public final Builder primaryRegion(String primaryRegion) {
            this.primaryRegion = primaryRegion;
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Plan build() {
            return new Plan(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Plan> {
        public Builder arn(String var1);

        public Builder description(String var1);

        public Builder workflows(Collection<Workflow> var1);

        public Builder workflows(Workflow ... var1);

        public Builder workflows(Consumer<Workflow.Builder> ... var1);

        public Builder executionRole(String var1);

        public Builder recoveryTimeObjectiveMinutes(Integer var1);

        public Builder associatedAlarms(Map<String, AssociatedAlarm> var1);

        public Builder triggers(Collection<Trigger> var1);

        public Builder triggers(Trigger ... var1);

        public Builder triggers(Consumer<Trigger.Builder> ... var1);

        public Builder reportConfiguration(ReportConfiguration var1);

        default public Builder reportConfiguration(Consumer<ReportConfiguration.Builder> reportConfiguration) {
            return this.reportConfiguration((ReportConfiguration)((ReportConfiguration.Builder)ReportConfiguration.builder().applyMutation(reportConfiguration)).build());
        }

        public Builder name(String var1);

        public Builder regions(Collection<String> var1);

        public Builder regions(String ... var1);

        public Builder recoveryApproach(String var1);

        public Builder recoveryApproach(RecoveryApproach var1);

        public Builder primaryRegion(String var1);

        public Builder owner(String var1);

        public Builder version(String var1);

        public Builder updatedAt(Instant var1);
    }
}

