/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.arcregionswitch.model.AbbreviatedPlan;
import software.amazon.awssdk.services.arcregionswitch.model.ArcRegionSwitchResponse;
import software.amazon.awssdk.services.arcregionswitch.model.PlanListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPlansInRegionResponse
extends ArcRegionSwitchResponse
implements ToCopyableBuilder<Builder, ListPlansInRegionResponse> {
    private static final SdkField<List<AbbreviatedPlan>> PLANS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("plans").getter(ListPlansInRegionResponse.getter(ListPlansInRegionResponse::plans)).setter(ListPlansInRegionResponse.setter(Builder::plans)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("plans").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AbbreviatedPlan::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPlansInRegionResponse.getter(ListPlansInRegionResponse::nextToken)).setter(ListPlansInRegionResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLANS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPlansInRegionResponse.memberNameToFieldInitializer();
    private final List<AbbreviatedPlan> plans;
    private final String nextToken;

    private ListPlansInRegionResponse(BuilderImpl builder) {
        super(builder);
        this.plans = builder.plans;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPlans() {
        return this.plans != null && !(this.plans instanceof SdkAutoConstructList);
    }

    public final List<AbbreviatedPlan> plans() {
        return this.plans;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlans() ? this.plans() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPlansInRegionResponse)) {
            return false;
        }
        ListPlansInRegionResponse other = (ListPlansInRegionResponse)((Object)obj);
        return this.hasPlans() == other.hasPlans() && Objects.equals(this.plans(), other.plans()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPlansInRegionResponse").add("Plans", this.hasPlans() ? this.plans() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "plans": {
                return Optional.ofNullable(clazz.cast(this.plans()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("plans", PLANS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPlansInRegionResponse, T> g) {
        return obj -> g.apply((ListPlansInRegionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ArcRegionSwitchResponse.BuilderImpl
    implements Builder {
        private List<AbbreviatedPlan> plans = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPlansInRegionResponse model) {
            super(model);
            this.plans(model.plans);
            this.nextToken(model.nextToken);
        }

        public final List<AbbreviatedPlan.Builder> getPlans() {
            List<AbbreviatedPlan.Builder> result = PlanListCopier.copyToBuilder(this.plans);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlans(Collection<AbbreviatedPlan.BuilderImpl> plans) {
            this.plans = PlanListCopier.copyFromBuilder(plans);
        }

        @Override
        public final Builder plans(Collection<AbbreviatedPlan> plans) {
            this.plans = PlanListCopier.copy(plans);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder plans(AbbreviatedPlan ... plans) {
            this.plans(Arrays.asList(plans));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder plans(Consumer<AbbreviatedPlan.Builder> ... plans) {
            this.plans(Stream.of(plans).map(c -> (AbbreviatedPlan)((AbbreviatedPlan.Builder)AbbreviatedPlan.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPlansInRegionResponse build() {
            return new ListPlansInRegionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ArcRegionSwitchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPlansInRegionResponse> {
        public Builder plans(Collection<AbbreviatedPlan> var1);

        public Builder plans(AbbreviatedPlan ... var1);

        public Builder plans(Consumer<AbbreviatedPlan.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

