/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePlanExecutionRequest extends ArcRegionSwitchRequest implements
        ToCopyableBuilder<UpdatePlanExecutionRequest.Builder, UpdatePlanExecutionRequest> {
    private static final SdkField<String> PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("planArn").getter(getter(UpdatePlanExecutionRequest::planArn)).setter(setter(Builder::planArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("planArn").build()).build();

    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionId").getter(getter(UpdatePlanExecutionRequest::executionId))
            .setter(setter(Builder::executionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(UpdatePlanExecutionRequest::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("comment")
            .getter(getter(UpdatePlanExecutionRequest::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAN_ARN_FIELD,
            EXECUTION_ID_FIELD, ACTION_FIELD, COMMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String planArn;

    private final String executionId;

    private final String action;

    private final String comment;

    private UpdatePlanExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.planArn = builder.planArn;
        this.executionId = builder.executionId;
        this.action = builder.action;
        this.comment = builder.comment;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the plan with the execution to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the plan with the execution to update.
     */
    public final String planArn() {
        return planArn;
    }

    /**
     * <p>
     * The execution identifier of a plan execution.
     * </p>
     * 
     * @return The execution identifier of a plan execution.
     */
    public final String executionId() {
        return executionId;
    }

    /**
     * <p>
     * The action specified for a plan execution, for example, Switch to Graceful or Pause.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link UpdatePlanExecutionAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #actionAsString}.
     * </p>
     * 
     * @return The action specified for a plan execution, for example, Switch to Graceful or Pause.
     * @see UpdatePlanExecutionAction
     */
    public final UpdatePlanExecutionAction action() {
        return UpdatePlanExecutionAction.fromValue(action);
    }

    /**
     * <p>
     * The action specified for a plan execution, for example, Switch to Graceful or Pause.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link UpdatePlanExecutionAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #actionAsString}.
     * </p>
     * 
     * @return The action specified for a plan execution, for example, Switch to Graceful or Pause.
     * @see UpdatePlanExecutionAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * An optional comment about the plan execution.
     * </p>
     * 
     * @return An optional comment about the plan execution.
     */
    public final String comment() {
        return comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(planArn());
        hashCode = 31 * hashCode + Objects.hashCode(executionId());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePlanExecutionRequest)) {
            return false;
        }
        UpdatePlanExecutionRequest other = (UpdatePlanExecutionRequest) obj;
        return Objects.equals(planArn(), other.planArn()) && Objects.equals(executionId(), other.executionId())
                && Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(comment(), other.comment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePlanExecutionRequest").add("PlanArn", planArn()).add("ExecutionId", executionId())
                .add("Action", actionAsString()).add("Comment", comment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "planArn":
            return Optional.ofNullable(clazz.cast(planArn()));
        case "executionId":
            return Optional.ofNullable(clazz.cast(executionId()));
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("planArn", PLAN_ARN_FIELD);
        map.put("executionId", EXECUTION_ID_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("comment", COMMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePlanExecutionRequest, T> g) {
        return obj -> g.apply((UpdatePlanExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ArcRegionSwitchRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdatePlanExecutionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the plan with the execution to update.
         * </p>
         * 
         * @param planArn
         *        The Amazon Resource Name (ARN) of the plan with the execution to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder planArn(String planArn);

        /**
         * <p>
         * The execution identifier of a plan execution.
         * </p>
         * 
         * @param executionId
         *        The execution identifier of a plan execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionId(String executionId);

        /**
         * <p>
         * The action specified for a plan execution, for example, Switch to Graceful or Pause.
         * </p>
         * 
         * @param action
         *        The action specified for a plan execution, for example, Switch to Graceful or Pause.
         * @see UpdatePlanExecutionAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdatePlanExecutionAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action specified for a plan execution, for example, Switch to Graceful or Pause.
         * </p>
         * 
         * @param action
         *        The action specified for a plan execution, for example, Switch to Graceful or Pause.
         * @see UpdatePlanExecutionAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdatePlanExecutionAction
         */
        Builder action(UpdatePlanExecutionAction action);

        /**
         * <p>
         * An optional comment about the plan execution.
         * </p>
         * 
         * @param comment
         *        An optional comment about the plan execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ArcRegionSwitchRequest.BuilderImpl implements Builder {
        private String planArn;

        private String executionId;

        private String action;

        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePlanExecutionRequest model) {
            super(model);
            planArn(model.planArn);
            executionId(model.executionId);
            action(model.action);
            comment(model.comment);
        }

        public final String getPlanArn() {
            return planArn;
        }

        public final void setPlanArn(String planArn) {
            this.planArn = planArn;
        }

        @Override
        public final Builder planArn(String planArn) {
            this.planArn = planArn;
            return this;
        }

        public final String getExecutionId() {
            return executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(UpdatePlanExecutionAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePlanExecutionRequest build() {
            return new UpdatePlanExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
