/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for handling failures when performing operations on Aurora global databases.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GlobalAuroraUngraceful implements SdkPojo, Serializable,
        ToCopyableBuilder<GlobalAuroraUngraceful.Builder, GlobalAuroraUngraceful> {
    private static final SdkField<String> UNGRACEFUL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ungraceful").getter(getter(GlobalAuroraUngraceful::ungracefulAsString))
            .setter(setter(Builder::ungraceful))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ungraceful").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNGRACEFUL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ungraceful;

    private GlobalAuroraUngraceful(BuilderImpl builder) {
        this.ungraceful = builder.ungraceful;
    }

    /**
     * <p>
     * The settings for ungraceful execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ungraceful} will
     * return {@link GlobalAuroraUngracefulBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #ungracefulAsString}.
     * </p>
     * 
     * @return The settings for ungraceful execution.
     * @see GlobalAuroraUngracefulBehavior
     */
    public final GlobalAuroraUngracefulBehavior ungraceful() {
        return GlobalAuroraUngracefulBehavior.fromValue(ungraceful);
    }

    /**
     * <p>
     * The settings for ungraceful execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ungraceful} will
     * return {@link GlobalAuroraUngracefulBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #ungracefulAsString}.
     * </p>
     * 
     * @return The settings for ungraceful execution.
     * @see GlobalAuroraUngracefulBehavior
     */
    public final String ungracefulAsString() {
        return ungraceful;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ungracefulAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalAuroraUngraceful)) {
            return false;
        }
        GlobalAuroraUngraceful other = (GlobalAuroraUngraceful) obj;
        return Objects.equals(ungracefulAsString(), other.ungracefulAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GlobalAuroraUngraceful").add("Ungraceful", ungracefulAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ungraceful":
            return Optional.ofNullable(clazz.cast(ungracefulAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ungraceful", UNGRACEFUL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GlobalAuroraUngraceful, T> g) {
        return obj -> g.apply((GlobalAuroraUngraceful) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GlobalAuroraUngraceful> {
        /**
         * <p>
         * The settings for ungraceful execution.
         * </p>
         * 
         * @param ungraceful
         *        The settings for ungraceful execution.
         * @see GlobalAuroraUngracefulBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlobalAuroraUngracefulBehavior
         */
        Builder ungraceful(String ungraceful);

        /**
         * <p>
         * The settings for ungraceful execution.
         * </p>
         * 
         * @param ungraceful
         *        The settings for ungraceful execution.
         * @see GlobalAuroraUngracefulBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlobalAuroraUngracefulBehavior
         */
        Builder ungraceful(GlobalAuroraUngracefulBehavior ungraceful);
    }

    static final class BuilderImpl implements Builder {
        private String ungraceful;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalAuroraUngraceful model) {
            ungraceful(model.ungraceful);
        }

        public final String getUngraceful() {
            return ungraceful;
        }

        public final void setUngraceful(String ungraceful) {
            this.ungraceful = ungraceful;
        }

        @Override
        public final Builder ungraceful(String ungraceful) {
            this.ungraceful = ungraceful;
            return this;
        }

        @Override
        public final Builder ungraceful(GlobalAuroraUngracefulBehavior ungraceful) {
            this.ungraceful(ungraceful == null ? null : ungraceful.toString());
            return this;
        }

        @Override
        public GlobalAuroraUngraceful build() {
            return new GlobalAuroraUngraceful(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
