/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Web Services EKS resource scaling configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EksResourceScalingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EksResourceScalingConfiguration.Builder, EksResourceScalingConfiguration> {
    private static final SdkField<Integer> TIMEOUT_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("timeoutMinutes").getter(getter(EksResourceScalingConfiguration::timeoutMinutes))
            .setter(setter(Builder::timeoutMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutMinutes").build()).build();

    private static final SdkField<KubernetesResourceType> KUBERNETES_RESOURCE_TYPE_FIELD = SdkField
            .<KubernetesResourceType> builder(MarshallingType.SDK_POJO).memberName("kubernetesResourceType")
            .getter(getter(EksResourceScalingConfiguration::kubernetesResourceType))
            .setter(setter(Builder::kubernetesResourceType)).constructor(KubernetesResourceType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesResourceType").build())
            .build();

    private static final SdkField<List<Map<String, Map<String, KubernetesScalingResource>>>> SCALING_RESOURCES_FIELD = SdkField
            .<List<Map<String, Map<String, KubernetesScalingResource>>>> builder(MarshallingType.LIST)
            .memberName("scalingResources")
            .getter(getter(EksResourceScalingConfiguration::scalingResources))
            .setter(setter(Builder::scalingResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Map<String, Map<String, KubernetesScalingResource>>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<Map<String, KubernetesScalingResource>> builder(
                                                                            MarshallingType.MAP)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build(),
                                                                                    MapTrait.builder()
                                                                                            .keyLocationName("key")
                                                                                            .valueLocationName("value")
                                                                                            .valueFieldInfo(
                                                                                                    SdkField.<KubernetesScalingResource> builder(
                                                                                                            MarshallingType.SDK_POJO)
                                                                                                            .constructor(
                                                                                                                    KubernetesScalingResource::builder)
                                                                                                            .traits(LocationTrait
                                                                                                                    .builder()
                                                                                                                    .location(
                                                                                                                            MarshallLocation.PAYLOAD)
                                                                                                                    .locationName(
                                                                                                                            "value")
                                                                                                                    .build())
                                                                                                            .build()).build())
                                                                            .build()).build()).build()).build()).build();

    private static final SdkField<List<EksCluster>> EKS_CLUSTERS_FIELD = SdkField
            .<List<EksCluster>> builder(MarshallingType.LIST)
            .memberName("eksClusters")
            .getter(getter(EksResourceScalingConfiguration::eksClusters))
            .setter(setter(Builder::eksClusters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksClusters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EksCluster> builder(MarshallingType.SDK_POJO)
                                            .constructor(EksCluster::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<EksResourceScalingUngraceful> UNGRACEFUL_FIELD = SdkField
            .<EksResourceScalingUngraceful> builder(MarshallingType.SDK_POJO).memberName("ungraceful")
            .getter(getter(EksResourceScalingConfiguration::ungraceful)).setter(setter(Builder::ungraceful))
            .constructor(EksResourceScalingUngraceful::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ungraceful").build()).build();

    private static final SdkField<Integer> TARGET_PERCENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("targetPercent").getter(getter(EksResourceScalingConfiguration::targetPercent))
            .setter(setter(Builder::targetPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetPercent").build()).build();

    private static final SdkField<String> CAPACITY_MONITORING_APPROACH_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("capacityMonitoringApproach")
            .getter(getter(EksResourceScalingConfiguration::capacityMonitoringApproachAsString))
            .setter(setter(Builder::capacityMonitoringApproach))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityMonitoringApproach").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEOUT_MINUTES_FIELD,
            KUBERNETES_RESOURCE_TYPE_FIELD, SCALING_RESOURCES_FIELD, EKS_CLUSTERS_FIELD, UNGRACEFUL_FIELD, TARGET_PERCENT_FIELD,
            CAPACITY_MONITORING_APPROACH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer timeoutMinutes;

    private final KubernetesResourceType kubernetesResourceType;

    private final List<Map<String, Map<String, KubernetesScalingResource>>> scalingResources;

    private final List<EksCluster> eksClusters;

    private final EksResourceScalingUngraceful ungraceful;

    private final Integer targetPercent;

    private final String capacityMonitoringApproach;

    private EksResourceScalingConfiguration(BuilderImpl builder) {
        this.timeoutMinutes = builder.timeoutMinutes;
        this.kubernetesResourceType = builder.kubernetesResourceType;
        this.scalingResources = builder.scalingResources;
        this.eksClusters = builder.eksClusters;
        this.ungraceful = builder.ungraceful;
        this.targetPercent = builder.targetPercent;
        this.capacityMonitoringApproach = builder.capacityMonitoringApproach;
    }

    /**
     * <p>
     * The timeout value specified for the configuration.
     * </p>
     * 
     * @return The timeout value specified for the configuration.
     */
    public final Integer timeoutMinutes() {
        return timeoutMinutes;
    }

    /**
     * <p>
     * The Kubernetes resource type for the configuration.
     * </p>
     * 
     * @return The Kubernetes resource type for the configuration.
     */
    public final KubernetesResourceType kubernetesResourceType() {
        return kubernetesResourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScalingResources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScalingResources() {
        return scalingResources != null && !(scalingResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The scaling resources for the configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScalingResources} method.
     * </p>
     * 
     * @return The scaling resources for the configuration.
     */
    public final List<Map<String, Map<String, KubernetesScalingResource>>> scalingResources() {
        return scalingResources;
    }

    /**
     * For responses, this returns true if the service returned a value for the EksClusters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEksClusters() {
        return eksClusters != null && !(eksClusters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The clusters for the configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEksClusters} method.
     * </p>
     * 
     * @return The clusters for the configuration.
     */
    public final List<EksCluster> eksClusters() {
        return eksClusters;
    }

    /**
     * <p>
     * The settings for ungraceful execution.
     * </p>
     * 
     * @return The settings for ungraceful execution.
     */
    public final EksResourceScalingUngraceful ungraceful() {
        return ungraceful;
    }

    /**
     * <p>
     * The target percentage for the configuration.
     * </p>
     * 
     * @return The target percentage for the configuration.
     */
    public final Integer targetPercent() {
        return targetPercent;
    }

    /**
     * <p>
     * The monitoring approach for the configuration, that is, whether it was sampled in the last 24 hours or autoscaled
     * in the last 24 hours.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capacityMonitoringApproach} will return {@link EksCapacityMonitoringApproach#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #capacityMonitoringApproachAsString}.
     * </p>
     * 
     * @return The monitoring approach for the configuration, that is, whether it was sampled in the last 24 hours or
     *         autoscaled in the last 24 hours.
     * @see EksCapacityMonitoringApproach
     */
    public final EksCapacityMonitoringApproach capacityMonitoringApproach() {
        return EksCapacityMonitoringApproach.fromValue(capacityMonitoringApproach);
    }

    /**
     * <p>
     * The monitoring approach for the configuration, that is, whether it was sampled in the last 24 hours or autoscaled
     * in the last 24 hours.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capacityMonitoringApproach} will return {@link EksCapacityMonitoringApproach#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #capacityMonitoringApproachAsString}.
     * </p>
     * 
     * @return The monitoring approach for the configuration, that is, whether it was sampled in the last 24 hours or
     *         autoscaled in the last 24 hours.
     * @see EksCapacityMonitoringApproach
     */
    public final String capacityMonitoringApproachAsString() {
        return capacityMonitoringApproach;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(kubernetesResourceType());
        hashCode = 31 * hashCode + Objects.hashCode(hasScalingResources() ? scalingResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEksClusters() ? eksClusters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ungraceful());
        hashCode = 31 * hashCode + Objects.hashCode(targetPercent());
        hashCode = 31 * hashCode + Objects.hashCode(capacityMonitoringApproachAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksResourceScalingConfiguration)) {
            return false;
        }
        EksResourceScalingConfiguration other = (EksResourceScalingConfiguration) obj;
        return Objects.equals(timeoutMinutes(), other.timeoutMinutes())
                && Objects.equals(kubernetesResourceType(), other.kubernetesResourceType())
                && hasScalingResources() == other.hasScalingResources()
                && Objects.equals(scalingResources(), other.scalingResources()) && hasEksClusters() == other.hasEksClusters()
                && Objects.equals(eksClusters(), other.eksClusters()) && Objects.equals(ungraceful(), other.ungraceful())
                && Objects.equals(targetPercent(), other.targetPercent())
                && Objects.equals(capacityMonitoringApproachAsString(), other.capacityMonitoringApproachAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EksResourceScalingConfiguration").add("TimeoutMinutes", timeoutMinutes())
                .add("KubernetesResourceType", kubernetesResourceType())
                .add("ScalingResources", hasScalingResources() ? scalingResources() : null)
                .add("EksClusters", hasEksClusters() ? eksClusters() : null).add("Ungraceful", ungraceful())
                .add("TargetPercent", targetPercent()).add("CapacityMonitoringApproach", capacityMonitoringApproachAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timeoutMinutes":
            return Optional.ofNullable(clazz.cast(timeoutMinutes()));
        case "kubernetesResourceType":
            return Optional.ofNullable(clazz.cast(kubernetesResourceType()));
        case "scalingResources":
            return Optional.ofNullable(clazz.cast(scalingResources()));
        case "eksClusters":
            return Optional.ofNullable(clazz.cast(eksClusters()));
        case "ungraceful":
            return Optional.ofNullable(clazz.cast(ungraceful()));
        case "targetPercent":
            return Optional.ofNullable(clazz.cast(targetPercent()));
        case "capacityMonitoringApproach":
            return Optional.ofNullable(clazz.cast(capacityMonitoringApproachAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("timeoutMinutes", TIMEOUT_MINUTES_FIELD);
        map.put("kubernetesResourceType", KUBERNETES_RESOURCE_TYPE_FIELD);
        map.put("scalingResources", SCALING_RESOURCES_FIELD);
        map.put("eksClusters", EKS_CLUSTERS_FIELD);
        map.put("ungraceful", UNGRACEFUL_FIELD);
        map.put("targetPercent", TARGET_PERCENT_FIELD);
        map.put("capacityMonitoringApproach", CAPACITY_MONITORING_APPROACH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EksResourceScalingConfiguration, T> g) {
        return obj -> g.apply((EksResourceScalingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EksResourceScalingConfiguration> {
        /**
         * <p>
         * The timeout value specified for the configuration.
         * </p>
         * 
         * @param timeoutMinutes
         *        The timeout value specified for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutMinutes(Integer timeoutMinutes);

        /**
         * <p>
         * The Kubernetes resource type for the configuration.
         * </p>
         * 
         * @param kubernetesResourceType
         *        The Kubernetes resource type for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kubernetesResourceType(KubernetesResourceType kubernetesResourceType);

        /**
         * <p>
         * The Kubernetes resource type for the configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link KubernetesResourceType.Builder} avoiding
         * the need to create one manually via {@link KubernetesResourceType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KubernetesResourceType.Builder#build()} is called immediately and
         * its result is passed to {@link #kubernetesResourceType(KubernetesResourceType)}.
         * 
         * @param kubernetesResourceType
         *        a consumer that will call methods on {@link KubernetesResourceType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kubernetesResourceType(KubernetesResourceType)
         */
        default Builder kubernetesResourceType(Consumer<KubernetesResourceType.Builder> kubernetesResourceType) {
            return kubernetesResourceType(KubernetesResourceType.builder().applyMutation(kubernetesResourceType).build());
        }

        /**
         * <p>
         * The scaling resources for the configuration.
         * </p>
         * 
         * @param scalingResources
         *        The scaling resources for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingResources(
                Collection<? extends Map<String, ? extends Map<String, KubernetesScalingResource>>> scalingResources);

        /**
         * <p>
         * The scaling resources for the configuration.
         * </p>
         * 
         * @param scalingResources
         *        The scaling resources for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingResources(Map<String, ? extends Map<String, KubernetesScalingResource>>... scalingResources);

        /**
         * <p>
         * The clusters for the configuration.
         * </p>
         * 
         * @param eksClusters
         *        The clusters for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eksClusters(Collection<EksCluster> eksClusters);

        /**
         * <p>
         * The clusters for the configuration.
         * </p>
         * 
         * @param eksClusters
         *        The clusters for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eksClusters(EksCluster... eksClusters);

        /**
         * <p>
         * The clusters for the configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.arcregionswitch.model.EksCluster.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.arcregionswitch.model.EksCluster#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.arcregionswitch.model.EksCluster.Builder#build()} is called
         * immediately and its result is passed to {@link #eksClusters(List<EksCluster>)}.
         * 
         * @param eksClusters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.arcregionswitch.model.EksCluster.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eksClusters(java.util.Collection<EksCluster>)
         */
        Builder eksClusters(Consumer<EksCluster.Builder>... eksClusters);

        /**
         * <p>
         * The settings for ungraceful execution.
         * </p>
         * 
         * @param ungraceful
         *        The settings for ungraceful execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ungraceful(EksResourceScalingUngraceful ungraceful);

        /**
         * <p>
         * The settings for ungraceful execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link EksResourceScalingUngraceful.Builder}
         * avoiding the need to create one manually via {@link EksResourceScalingUngraceful#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EksResourceScalingUngraceful.Builder#build()} is called
         * immediately and its result is passed to {@link #ungraceful(EksResourceScalingUngraceful)}.
         * 
         * @param ungraceful
         *        a consumer that will call methods on {@link EksResourceScalingUngraceful.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ungraceful(EksResourceScalingUngraceful)
         */
        default Builder ungraceful(Consumer<EksResourceScalingUngraceful.Builder> ungraceful) {
            return ungraceful(EksResourceScalingUngraceful.builder().applyMutation(ungraceful).build());
        }

        /**
         * <p>
         * The target percentage for the configuration.
         * </p>
         * 
         * @param targetPercent
         *        The target percentage for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetPercent(Integer targetPercent);

        /**
         * <p>
         * The monitoring approach for the configuration, that is, whether it was sampled in the last 24 hours or
         * autoscaled in the last 24 hours.
         * </p>
         * 
         * @param capacityMonitoringApproach
         *        The monitoring approach for the configuration, that is, whether it was sampled in the last 24 hours or
         *        autoscaled in the last 24 hours.
         * @see EksCapacityMonitoringApproach
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EksCapacityMonitoringApproach
         */
        Builder capacityMonitoringApproach(String capacityMonitoringApproach);

        /**
         * <p>
         * The monitoring approach for the configuration, that is, whether it was sampled in the last 24 hours or
         * autoscaled in the last 24 hours.
         * </p>
         * 
         * @param capacityMonitoringApproach
         *        The monitoring approach for the configuration, that is, whether it was sampled in the last 24 hours or
         *        autoscaled in the last 24 hours.
         * @see EksCapacityMonitoringApproach
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EksCapacityMonitoringApproach
         */
        Builder capacityMonitoringApproach(EksCapacityMonitoringApproach capacityMonitoringApproach);
    }

    static final class BuilderImpl implements Builder {
        private Integer timeoutMinutes;

        private KubernetesResourceType kubernetesResourceType;

        private List<Map<String, Map<String, KubernetesScalingResource>>> scalingResources = DefaultSdkAutoConstructList
                .getInstance();

        private List<EksCluster> eksClusters = DefaultSdkAutoConstructList.getInstance();

        private EksResourceScalingUngraceful ungraceful;

        private Integer targetPercent;

        private String capacityMonitoringApproach;

        private BuilderImpl() {
        }

        private BuilderImpl(EksResourceScalingConfiguration model) {
            timeoutMinutes(model.timeoutMinutes);
            kubernetesResourceType(model.kubernetesResourceType);
            scalingResources(model.scalingResources);
            eksClusters(model.eksClusters);
            ungraceful(model.ungraceful);
            targetPercent(model.targetPercent);
            capacityMonitoringApproach(model.capacityMonitoringApproach);
        }

        public final Integer getTimeoutMinutes() {
            return timeoutMinutes;
        }

        public final void setTimeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
        }

        @Override
        public final Builder timeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
            return this;
        }

        public final KubernetesResourceType.Builder getKubernetesResourceType() {
            return kubernetesResourceType != null ? kubernetesResourceType.toBuilder() : null;
        }

        public final void setKubernetesResourceType(KubernetesResourceType.BuilderImpl kubernetesResourceType) {
            this.kubernetesResourceType = kubernetesResourceType != null ? kubernetesResourceType.build() : null;
        }

        @Override
        public final Builder kubernetesResourceType(KubernetesResourceType kubernetesResourceType) {
            this.kubernetesResourceType = kubernetesResourceType;
            return this;
        }

        public final List<Map<String, Map<String, KubernetesScalingResource.Builder>>> getScalingResources() {
            List<Map<String, Map<String, KubernetesScalingResource.Builder>>> result = KubernetesScalingAppsCopier
                    .copyToBuilder(this.scalingResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScalingResources(
                Collection<? extends Map<String, ? extends Map<String, KubernetesScalingResource.BuilderImpl>>> scalingResources) {
            this.scalingResources = KubernetesScalingAppsCopier.copyFromBuilder(scalingResources);
        }

        @Override
        public final Builder scalingResources(
                Collection<? extends Map<String, ? extends Map<String, KubernetesScalingResource>>> scalingResources) {
            this.scalingResources = KubernetesScalingAppsCopier.copy(scalingResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingResources(Map<String, ? extends Map<String, KubernetesScalingResource>>... scalingResources) {
            scalingResources(Arrays.asList(scalingResources));
            return this;
        }

        public final List<EksCluster.Builder> getEksClusters() {
            List<EksCluster.Builder> result = EksClustersCopier.copyToBuilder(this.eksClusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEksClusters(Collection<EksCluster.BuilderImpl> eksClusters) {
            this.eksClusters = EksClustersCopier.copyFromBuilder(eksClusters);
        }

        @Override
        public final Builder eksClusters(Collection<EksCluster> eksClusters) {
            this.eksClusters = EksClustersCopier.copy(eksClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eksClusters(EksCluster... eksClusters) {
            eksClusters(Arrays.asList(eksClusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eksClusters(Consumer<EksCluster.Builder>... eksClusters) {
            eksClusters(Stream.of(eksClusters).map(c -> EksCluster.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final EksResourceScalingUngraceful.Builder getUngraceful() {
            return ungraceful != null ? ungraceful.toBuilder() : null;
        }

        public final void setUngraceful(EksResourceScalingUngraceful.BuilderImpl ungraceful) {
            this.ungraceful = ungraceful != null ? ungraceful.build() : null;
        }

        @Override
        public final Builder ungraceful(EksResourceScalingUngraceful ungraceful) {
            this.ungraceful = ungraceful;
            return this;
        }

        public final Integer getTargetPercent() {
            return targetPercent;
        }

        public final void setTargetPercent(Integer targetPercent) {
            this.targetPercent = targetPercent;
        }

        @Override
        public final Builder targetPercent(Integer targetPercent) {
            this.targetPercent = targetPercent;
            return this;
        }

        public final String getCapacityMonitoringApproach() {
            return capacityMonitoringApproach;
        }

        public final void setCapacityMonitoringApproach(String capacityMonitoringApproach) {
            this.capacityMonitoringApproach = capacityMonitoringApproach;
        }

        @Override
        public final Builder capacityMonitoringApproach(String capacityMonitoringApproach) {
            this.capacityMonitoringApproach = capacityMonitoringApproach;
            return this;
        }

        @Override
        public final Builder capacityMonitoringApproach(EksCapacityMonitoringApproach capacityMonitoringApproach) {
            this.capacityMonitoringApproach(capacityMonitoringApproach == null ? null : capacityMonitoringApproach.toString());
            return this;
        }

        @Override
        public EksResourceScalingConfiguration build() {
            return new EksResourceScalingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
