/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.arcregionswitch.ArcRegionSwitchClient;
import software.amazon.awssdk.services.arcregionswitch.internal.UserAgentUtils;
import software.amazon.awssdk.services.arcregionswitch.model.AbbreviatedPlan;
import software.amazon.awssdk.services.arcregionswitch.model.ListPlansRequest;
import software.amazon.awssdk.services.arcregionswitch.model.ListPlansResponse;

public class ListPlansIterable
implements SdkIterable<ListPlansResponse> {
    private final ArcRegionSwitchClient client;
    private final ListPlansRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPlansIterable(ArcRegionSwitchClient client, ListPlansRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPlansResponseFetcher();
    }

    public Iterator<ListPlansResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AbbreviatedPlan> plans() {
        Function<ListPlansResponse, Iterator> getIterator = response -> {
            if (response != null && response.plans() != null) {
                return response.plans().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPlansResponseFetcher
    implements SyncPageFetcher<ListPlansResponse> {
        private ListPlansResponseFetcher() {
        }

        public boolean hasNextPage(ListPlansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPlansResponse nextPage(ListPlansResponse previousPage) {
            if (previousPage == null) {
                return ListPlansIterable.this.client.listPlans(ListPlansIterable.this.firstRequest);
            }
            return ListPlansIterable.this.client.listPlans((ListPlansRequest)((Object)ListPlansIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

