/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.arcregionswitch.model.RecoveryApproach;
import software.amazon.awssdk.services.arcregionswitch.model.RegionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AbbreviatedPlan
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AbbreviatedPlan> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(AbbreviatedPlan.getter(AbbreviatedPlan::arn)).setter(AbbreviatedPlan.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owner").getter(AbbreviatedPlan.getter(AbbreviatedPlan::owner)).setter(AbbreviatedPlan.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AbbreviatedPlan.getter(AbbreviatedPlan::name)).setter(AbbreviatedPlan.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<String>> REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("regions").getter(AbbreviatedPlan.getter(AbbreviatedPlan::regions)).setter(AbbreviatedPlan.setter(Builder::regions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RECOVERY_APPROACH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recoveryApproach").getter(AbbreviatedPlan.getter(AbbreviatedPlan::recoveryApproachAsString)).setter(AbbreviatedPlan.setter(Builder::recoveryApproach)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryApproach").build()}).build();
    private static final SdkField<String> PRIMARY_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("primaryRegion").getter(AbbreviatedPlan.getter(AbbreviatedPlan::primaryRegion)).setter(AbbreviatedPlan.setter(Builder::primaryRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primaryRegion").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(AbbreviatedPlan.getter(AbbreviatedPlan::version)).setter(AbbreviatedPlan.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(AbbreviatedPlan.getter(AbbreviatedPlan::updatedAt)).setter(AbbreviatedPlan.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(AbbreviatedPlan.getter(AbbreviatedPlan::description)).setter(AbbreviatedPlan.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRole").getter(AbbreviatedPlan.getter(AbbreviatedPlan::executionRole)).setter(AbbreviatedPlan.setter(Builder::executionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRole").build()}).build();
    private static final SdkField<String> ACTIVE_PLAN_EXECUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("activePlanExecution").getter(AbbreviatedPlan.getter(AbbreviatedPlan::activePlanExecution)).setter(AbbreviatedPlan.setter(Builder::activePlanExecution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activePlanExecution").build()}).build();
    private static final SdkField<Integer> RECOVERY_TIME_OBJECTIVE_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("recoveryTimeObjectiveMinutes").getter(AbbreviatedPlan.getter(AbbreviatedPlan::recoveryTimeObjectiveMinutes)).setter(AbbreviatedPlan.setter(Builder::recoveryTimeObjectiveMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryTimeObjectiveMinutes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, OWNER_FIELD, NAME_FIELD, REGIONS_FIELD, RECOVERY_APPROACH_FIELD, PRIMARY_REGION_FIELD, VERSION_FIELD, UPDATED_AT_FIELD, DESCRIPTION_FIELD, EXECUTION_ROLE_FIELD, ACTIVE_PLAN_EXECUTION_FIELD, RECOVERY_TIME_OBJECTIVE_MINUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AbbreviatedPlan.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String owner;
    private final String name;
    private final List<String> regions;
    private final String recoveryApproach;
    private final String primaryRegion;
    private final String version;
    private final Instant updatedAt;
    private final String description;
    private final String executionRole;
    private final String activePlanExecution;
    private final Integer recoveryTimeObjectiveMinutes;

    private AbbreviatedPlan(BuilderImpl builder) {
        this.arn = builder.arn;
        this.owner = builder.owner;
        this.name = builder.name;
        this.regions = builder.regions;
        this.recoveryApproach = builder.recoveryApproach;
        this.primaryRegion = builder.primaryRegion;
        this.version = builder.version;
        this.updatedAt = builder.updatedAt;
        this.description = builder.description;
        this.executionRole = builder.executionRole;
        this.activePlanExecution = builder.activePlanExecution;
        this.recoveryTimeObjectiveMinutes = builder.recoveryTimeObjectiveMinutes;
    }

    public final String arn() {
        return this.arn;
    }

    public final String owner() {
        return this.owner;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasRegions() {
        return this.regions != null && !(this.regions instanceof SdkAutoConstructList);
    }

    public final List<String> regions() {
        return this.regions;
    }

    public final RecoveryApproach recoveryApproach() {
        return RecoveryApproach.fromValue(this.recoveryApproach);
    }

    public final String recoveryApproachAsString() {
        return this.recoveryApproach;
    }

    public final String primaryRegion() {
        return this.primaryRegion;
    }

    public final String version() {
        return this.version;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String description() {
        return this.description;
    }

    public final String executionRole() {
        return this.executionRole;
    }

    public final String activePlanExecution() {
        return this.activePlanExecution;
    }

    public final Integer recoveryTimeObjectiveMinutes() {
        return this.recoveryTimeObjectiveMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegions() ? this.regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryApproachAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.activePlanExecution());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryTimeObjectiveMinutes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbbreviatedPlan)) {
            return false;
        }
        AbbreviatedPlan other = (AbbreviatedPlan)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.name(), other.name()) && this.hasRegions() == other.hasRegions() && Objects.equals(this.regions(), other.regions()) && Objects.equals(this.recoveryApproachAsString(), other.recoveryApproachAsString()) && Objects.equals(this.primaryRegion(), other.primaryRegion()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.executionRole(), other.executionRole()) && Objects.equals(this.activePlanExecution(), other.activePlanExecution()) && Objects.equals(this.recoveryTimeObjectiveMinutes(), other.recoveryTimeObjectiveMinutes());
    }

    public final String toString() {
        return ToString.builder((String)"AbbreviatedPlan").add("Arn", (Object)this.arn()).add("Owner", (Object)this.owner()).add("Name", (Object)this.name()).add("Regions", this.hasRegions() ? this.regions() : null).add("RecoveryApproach", (Object)this.recoveryApproachAsString()).add("PrimaryRegion", (Object)this.primaryRegion()).add("Version", (Object)this.version()).add("UpdatedAt", (Object)this.updatedAt()).add("Description", (Object)this.description()).add("ExecutionRole", (Object)this.executionRole()).add("ActivePlanExecution", (Object)this.activePlanExecution()).add("RecoveryTimeObjectiveMinutes", (Object)this.recoveryTimeObjectiveMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "regions": {
                return Optional.ofNullable(clazz.cast(this.regions()));
            }
            case "recoveryApproach": {
                return Optional.ofNullable(clazz.cast(this.recoveryApproachAsString()));
            }
            case "primaryRegion": {
                return Optional.ofNullable(clazz.cast(this.primaryRegion()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "executionRole": {
                return Optional.ofNullable(clazz.cast(this.executionRole()));
            }
            case "activePlanExecution": {
                return Optional.ofNullable(clazz.cast(this.activePlanExecution()));
            }
            case "recoveryTimeObjectiveMinutes": {
                return Optional.ofNullable(clazz.cast(this.recoveryTimeObjectiveMinutes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("owner", OWNER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("regions", REGIONS_FIELD);
        map.put("recoveryApproach", RECOVERY_APPROACH_FIELD);
        map.put("primaryRegion", PRIMARY_REGION_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("executionRole", EXECUTION_ROLE_FIELD);
        map.put("activePlanExecution", ACTIVE_PLAN_EXECUTION_FIELD);
        map.put("recoveryTimeObjectiveMinutes", RECOVERY_TIME_OBJECTIVE_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AbbreviatedPlan, T> g) {
        return obj -> g.apply((AbbreviatedPlan)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String owner;
        private String name;
        private List<String> regions = DefaultSdkAutoConstructList.getInstance();
        private String recoveryApproach;
        private String primaryRegion;
        private String version;
        private Instant updatedAt;
        private String description;
        private String executionRole;
        private String activePlanExecution;
        private Integer recoveryTimeObjectiveMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(AbbreviatedPlan model) {
            this.arn(model.arn);
            this.owner(model.owner);
            this.name(model.name);
            this.regions(model.regions);
            this.recoveryApproach(model.recoveryApproach);
            this.primaryRegion(model.primaryRegion);
            this.version(model.version);
            this.updatedAt(model.updatedAt);
            this.description(model.description);
            this.executionRole(model.executionRole);
            this.activePlanExecution(model.activePlanExecution);
            this.recoveryTimeObjectiveMinutes(model.recoveryTimeObjectiveMinutes);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getRegions() {
            if (this.regions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        public final String getRecoveryApproach() {
            return this.recoveryApproach;
        }

        public final void setRecoveryApproach(String recoveryApproach) {
            this.recoveryApproach = recoveryApproach;
        }

        @Override
        public final Builder recoveryApproach(String recoveryApproach) {
            this.recoveryApproach = recoveryApproach;
            return this;
        }

        @Override
        public final Builder recoveryApproach(RecoveryApproach recoveryApproach) {
            this.recoveryApproach(recoveryApproach == null ? null : recoveryApproach.toString());
            return this;
        }

        public final String getPrimaryRegion() {
            return this.primaryRegion;
        }

        public final void setPrimaryRegion(String primaryRegion) {
            this.primaryRegion = primaryRegion;
        }

        @Override
        public final Builder primaryRegion(String primaryRegion) {
            this.primaryRegion = primaryRegion;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getExecutionRole() {
            return this.executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final String getActivePlanExecution() {
            return this.activePlanExecution;
        }

        public final void setActivePlanExecution(String activePlanExecution) {
            this.activePlanExecution = activePlanExecution;
        }

        @Override
        public final Builder activePlanExecution(String activePlanExecution) {
            this.activePlanExecution = activePlanExecution;
            return this;
        }

        public final Integer getRecoveryTimeObjectiveMinutes() {
            return this.recoveryTimeObjectiveMinutes;
        }

        public final void setRecoveryTimeObjectiveMinutes(Integer recoveryTimeObjectiveMinutes) {
            this.recoveryTimeObjectiveMinutes = recoveryTimeObjectiveMinutes;
        }

        @Override
        public final Builder recoveryTimeObjectiveMinutes(Integer recoveryTimeObjectiveMinutes) {
            this.recoveryTimeObjectiveMinutes = recoveryTimeObjectiveMinutes;
            return this;
        }

        public AbbreviatedPlan build() {
            return new AbbreviatedPlan(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AbbreviatedPlan> {
        public Builder arn(String var1);

        public Builder owner(String var1);

        public Builder name(String var1);

        public Builder regions(Collection<String> var1);

        public Builder regions(String ... var1);

        public Builder recoveryApproach(String var1);

        public Builder recoveryApproach(RecoveryApproach var1);

        public Builder primaryRegion(String var1);

        public Builder version(String var1);

        public Builder updatedAt(Instant var1);

        public Builder description(String var1);

        public Builder executionRole(String var1);

        public Builder activePlanExecution(String var1);

        public Builder recoveryTimeObjectiveMinutes(Integer var1);
    }
}

