/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.arcregionswitch.model.ArcRegionSwitchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartPlanExecutionResponse
extends ArcRegionSwitchResponse
implements ToCopyableBuilder<Builder, StartPlanExecutionResponse> {
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionId").getter(StartPlanExecutionResponse.getter(StartPlanExecutionResponse::executionId)).setter(StartPlanExecutionResponse.setter(Builder::executionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()}).build();
    private static final SdkField<String> PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("plan").getter(StartPlanExecutionResponse.getter(StartPlanExecutionResponse::plan)).setter(StartPlanExecutionResponse.setter(Builder::plan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("plan").build()}).build();
    private static final SdkField<String> PLAN_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("planVersion").getter(StartPlanExecutionResponse.getter(StartPlanExecutionResponse::planVersion)).setter(StartPlanExecutionResponse.setter(Builder::planVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("planVersion").build()}).build();
    private static final SdkField<String> ACTIVATE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("activateRegion").getter(StartPlanExecutionResponse.getter(StartPlanExecutionResponse::activateRegion)).setter(StartPlanExecutionResponse.setter(Builder::activateRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activateRegion").build()}).build();
    private static final SdkField<String> DEACTIVATE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deactivateRegion").getter(StartPlanExecutionResponse.getter(StartPlanExecutionResponse::deactivateRegion)).setter(StartPlanExecutionResponse.setter(Builder::deactivateRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deactivateRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ID_FIELD, PLAN_FIELD, PLAN_VERSION_FIELD, ACTIVATE_REGION_FIELD, DEACTIVATE_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartPlanExecutionResponse.memberNameToFieldInitializer();
    private final String executionId;
    private final String plan;
    private final String planVersion;
    private final String activateRegion;
    private final String deactivateRegion;

    private StartPlanExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.executionId = builder.executionId;
        this.plan = builder.plan;
        this.planVersion = builder.planVersion;
        this.activateRegion = builder.activateRegion;
        this.deactivateRegion = builder.deactivateRegion;
    }

    public final String executionId() {
        return this.executionId;
    }

    public final String plan() {
        return this.plan;
    }

    public final String planVersion() {
        return this.planVersion;
    }

    public final String activateRegion() {
        return this.activateRegion;
    }

    public final String deactivateRegion() {
        return this.deactivateRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.executionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.plan());
        hashCode = 31 * hashCode + Objects.hashCode(this.planVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.activateRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.deactivateRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartPlanExecutionResponse)) {
            return false;
        }
        StartPlanExecutionResponse other = (StartPlanExecutionResponse)((Object)obj);
        return Objects.equals(this.executionId(), other.executionId()) && Objects.equals(this.plan(), other.plan()) && Objects.equals(this.planVersion(), other.planVersion()) && Objects.equals(this.activateRegion(), other.activateRegion()) && Objects.equals(this.deactivateRegion(), other.deactivateRegion());
    }

    public final String toString() {
        return ToString.builder((String)"StartPlanExecutionResponse").add("ExecutionId", (Object)this.executionId()).add("Plan", (Object)this.plan()).add("PlanVersion", (Object)this.planVersion()).add("ActivateRegion", (Object)this.activateRegion()).add("DeactivateRegion", (Object)this.deactivateRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "executionId": {
                return Optional.ofNullable(clazz.cast(this.executionId()));
            }
            case "plan": {
                return Optional.ofNullable(clazz.cast(this.plan()));
            }
            case "planVersion": {
                return Optional.ofNullable(clazz.cast(this.planVersion()));
            }
            case "activateRegion": {
                return Optional.ofNullable(clazz.cast(this.activateRegion()));
            }
            case "deactivateRegion": {
                return Optional.ofNullable(clazz.cast(this.deactivateRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("executionId", EXECUTION_ID_FIELD);
        map.put("plan", PLAN_FIELD);
        map.put("planVersion", PLAN_VERSION_FIELD);
        map.put("activateRegion", ACTIVATE_REGION_FIELD);
        map.put("deactivateRegion", DEACTIVATE_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartPlanExecutionResponse, T> g) {
        return obj -> g.apply((StartPlanExecutionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ArcRegionSwitchResponse.BuilderImpl
    implements Builder {
        private String executionId;
        private String plan;
        private String planVersion;
        private String activateRegion;
        private String deactivateRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(StartPlanExecutionResponse model) {
            super(model);
            this.executionId(model.executionId);
            this.plan(model.plan);
            this.planVersion(model.planVersion);
            this.activateRegion(model.activateRegion);
            this.deactivateRegion(model.deactivateRegion);
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final String getPlan() {
            return this.plan;
        }

        public final void setPlan(String plan) {
            this.plan = plan;
        }

        @Override
        public final Builder plan(String plan) {
            this.plan = plan;
            return this;
        }

        public final String getPlanVersion() {
            return this.planVersion;
        }

        public final void setPlanVersion(String planVersion) {
            this.planVersion = planVersion;
        }

        @Override
        public final Builder planVersion(String planVersion) {
            this.planVersion = planVersion;
            return this;
        }

        public final String getActivateRegion() {
            return this.activateRegion;
        }

        public final void setActivateRegion(String activateRegion) {
            this.activateRegion = activateRegion;
        }

        @Override
        public final Builder activateRegion(String activateRegion) {
            this.activateRegion = activateRegion;
            return this;
        }

        public final String getDeactivateRegion() {
            return this.deactivateRegion;
        }

        public final void setDeactivateRegion(String deactivateRegion) {
            this.deactivateRegion = deactivateRegion;
        }

        @Override
        public final Builder deactivateRegion(String deactivateRegion) {
            this.deactivateRegion = deactivateRegion;
            return this;
        }

        @Override
        public StartPlanExecutionResponse build() {
            return new StartPlanExecutionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ArcRegionSwitchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartPlanExecutionResponse> {
        public Builder executionId(String var1);

        public Builder plan(String var1);

        public Builder planVersion(String var1);

        public Builder activateRegion(String var1);

        public Builder deactivateRegion(String var1);
    }
}

