/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.endpoints;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class ArcRegionSwitchEndpointParams
implements ToCopyableBuilder<Builder, ArcRegionSwitchEndpointParams> {
    private final Boolean useFIPS;
    private final String endpoint;
    private final Region region;
    private final Boolean useControlPlaneEndpoint;

    private ArcRegionSwitchEndpointParams(BuilderImpl builder) {
        this.useFIPS = builder.useFIPS;
        this.endpoint = builder.endpoint;
        this.region = builder.region;
        this.useControlPlaneEndpoint = builder.useControlPlaneEndpoint;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public Boolean useFips() {
        return this.useFIPS;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public Region region() {
        return this.region;
    }

    public Boolean useControlPlaneEndpoint() {
        return this.useControlPlaneEndpoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    private static class BuilderImpl
    implements Builder {
        private Boolean useFIPS = false;
        private String endpoint;
        private Region region;
        private Boolean useControlPlaneEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(ArcRegionSwitchEndpointParams builder) {
            this.useFIPS = builder.useFIPS;
            this.endpoint = builder.endpoint;
            this.region = builder.region;
            this.useControlPlaneEndpoint = builder.useControlPlaneEndpoint;
        }

        @Override
        public Builder useFips(Boolean useFIPS) {
            this.useFIPS = useFIPS;
            if (this.useFIPS == null) {
                this.useFIPS = false;
            }
            return this;
        }

        @Override
        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public Builder useControlPlaneEndpoint(Boolean useControlPlaneEndpoint) {
            this.useControlPlaneEndpoint = useControlPlaneEndpoint;
            return this;
        }

        @Override
        public ArcRegionSwitchEndpointParams build() {
            return new ArcRegionSwitchEndpointParams(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ArcRegionSwitchEndpointParams> {
        public Builder useFips(Boolean var1);

        public Builder endpoint(String var1);

        public Builder region(Region var1);

        public Builder useControlPlaneEndpoint(Boolean var1);

        public ArcRegionSwitchEndpointParams build();
    }
}

