/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.arcregionswitch.ArcRegionSwitchAsyncClient;
import software.amazon.awssdk.services.arcregionswitch.internal.UserAgentUtils;
import software.amazon.awssdk.services.arcregionswitch.model.AbbreviatedPlan;
import software.amazon.awssdk.services.arcregionswitch.model.ListPlansRequest;
import software.amazon.awssdk.services.arcregionswitch.model.ListPlansResponse;

public class ListPlansPublisher
implements SdkPublisher<ListPlansResponse> {
    private final ArcRegionSwitchAsyncClient client;
    private final ListPlansRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPlansPublisher(ArcRegionSwitchAsyncClient client, ListPlansRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPlansPublisher(ArcRegionSwitchAsyncClient client, ListPlansRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPlansResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPlansResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AbbreviatedPlan> plans() {
        Function<ListPlansResponse, Iterator> getIterator = response -> {
            if (response != null && response.plans() != null) {
                return response.plans().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPlansResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPlansResponseFetcher
    implements AsyncPageFetcher<ListPlansResponse> {
        private ListPlansResponseFetcher() {
        }

        public boolean hasNextPage(ListPlansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPlansResponse> nextPage(ListPlansResponse previousPage) {
            if (previousPage == null) {
                return ListPlansPublisher.this.client.listPlans(ListPlansPublisher.this.firstRequest);
            }
            return ListPlansPublisher.this.client.listPlans((ListPlansRequest)((Object)ListPlansPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

