/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePlanExecutionStepRequest extends ArcRegionSwitchRequest implements
        ToCopyableBuilder<UpdatePlanExecutionStepRequest.Builder, UpdatePlanExecutionStepRequest> {
    private static final SdkField<String> PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("planArn").getter(getter(UpdatePlanExecutionStepRequest::planArn)).setter(setter(Builder::planArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("planArn").build()).build();

    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionId").getter(getter(UpdatePlanExecutionStepRequest::executionId))
            .setter(setter(Builder::executionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("comment")
            .getter(getter(UpdatePlanExecutionStepRequest::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final SdkField<String> STEP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stepName").getter(getter(UpdatePlanExecutionStepRequest::stepName)).setter(setter(Builder::stepName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepName").build()).build();

    private static final SdkField<String> ACTION_TO_TAKE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionToTake").getter(getter(UpdatePlanExecutionStepRequest::actionToTakeAsString))
            .setter(setter(Builder::actionToTake))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionToTake").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAN_ARN_FIELD,
            EXECUTION_ID_FIELD, COMMENT_FIELD, STEP_NAME_FIELD, ACTION_TO_TAKE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String planArn;

    private final String executionId;

    private final String comment;

    private final String stepName;

    private final String actionToTake;

    private UpdatePlanExecutionStepRequest(BuilderImpl builder) {
        super(builder);
        this.planArn = builder.planArn;
        this.executionId = builder.executionId;
        this.comment = builder.comment;
        this.stepName = builder.stepName;
        this.actionToTake = builder.actionToTake;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the plan containing the execution step to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the plan containing the execution step to update.
     */
    public final String planArn() {
        return planArn;
    }

    /**
     * <p>
     * The unique identifier of the plan execution containing the step to update.
     * </p>
     * 
     * @return The unique identifier of the plan execution containing the step to update.
     */
    public final String executionId() {
        return executionId;
    }

    /**
     * <p>
     * An optional comment about the plan execution.
     * </p>
     * 
     * @return An optional comment about the plan execution.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * The name of the execution step to update.
     * </p>
     * 
     * @return The name of the execution step to update.
     */
    public final String stepName() {
        return stepName;
    }

    /**
     * <p>
     * The updated action to take for the step. This can be used to skip or retry a step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionToTake} will
     * return {@link UpdatePlanExecutionStepAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #actionToTakeAsString}.
     * </p>
     * 
     * @return The updated action to take for the step. This can be used to skip or retry a step.
     * @see UpdatePlanExecutionStepAction
     */
    public final UpdatePlanExecutionStepAction actionToTake() {
        return UpdatePlanExecutionStepAction.fromValue(actionToTake);
    }

    /**
     * <p>
     * The updated action to take for the step. This can be used to skip or retry a step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionToTake} will
     * return {@link UpdatePlanExecutionStepAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #actionToTakeAsString}.
     * </p>
     * 
     * @return The updated action to take for the step. This can be used to skip or retry a step.
     * @see UpdatePlanExecutionStepAction
     */
    public final String actionToTakeAsString() {
        return actionToTake;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(planArn());
        hashCode = 31 * hashCode + Objects.hashCode(executionId());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(stepName());
        hashCode = 31 * hashCode + Objects.hashCode(actionToTakeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePlanExecutionStepRequest)) {
            return false;
        }
        UpdatePlanExecutionStepRequest other = (UpdatePlanExecutionStepRequest) obj;
        return Objects.equals(planArn(), other.planArn()) && Objects.equals(executionId(), other.executionId())
                && Objects.equals(comment(), other.comment()) && Objects.equals(stepName(), other.stepName())
                && Objects.equals(actionToTakeAsString(), other.actionToTakeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePlanExecutionStepRequest").add("PlanArn", planArn()).add("ExecutionId", executionId())
                .add("Comment", comment()).add("StepName", stepName()).add("ActionToTake", actionToTakeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "planArn":
            return Optional.ofNullable(clazz.cast(planArn()));
        case "executionId":
            return Optional.ofNullable(clazz.cast(executionId()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "stepName":
            return Optional.ofNullable(clazz.cast(stepName()));
        case "actionToTake":
            return Optional.ofNullable(clazz.cast(actionToTakeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("planArn", PLAN_ARN_FIELD);
        map.put("executionId", EXECUTION_ID_FIELD);
        map.put("comment", COMMENT_FIELD);
        map.put("stepName", STEP_NAME_FIELD);
        map.put("actionToTake", ACTION_TO_TAKE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePlanExecutionStepRequest, T> g) {
        return obj -> g.apply((UpdatePlanExecutionStepRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ArcRegionSwitchRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdatePlanExecutionStepRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the plan containing the execution step to update.
         * </p>
         * 
         * @param planArn
         *        The Amazon Resource Name (ARN) of the plan containing the execution step to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder planArn(String planArn);

        /**
         * <p>
         * The unique identifier of the plan execution containing the step to update.
         * </p>
         * 
         * @param executionId
         *        The unique identifier of the plan execution containing the step to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionId(String executionId);

        /**
         * <p>
         * An optional comment about the plan execution.
         * </p>
         * 
         * @param comment
         *        An optional comment about the plan execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * The name of the execution step to update.
         * </p>
         * 
         * @param stepName
         *        The name of the execution step to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepName(String stepName);

        /**
         * <p>
         * The updated action to take for the step. This can be used to skip or retry a step.
         * </p>
         * 
         * @param actionToTake
         *        The updated action to take for the step. This can be used to skip or retry a step.
         * @see UpdatePlanExecutionStepAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdatePlanExecutionStepAction
         */
        Builder actionToTake(String actionToTake);

        /**
         * <p>
         * The updated action to take for the step. This can be used to skip or retry a step.
         * </p>
         * 
         * @param actionToTake
         *        The updated action to take for the step. This can be used to skip or retry a step.
         * @see UpdatePlanExecutionStepAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdatePlanExecutionStepAction
         */
        Builder actionToTake(UpdatePlanExecutionStepAction actionToTake);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ArcRegionSwitchRequest.BuilderImpl implements Builder {
        private String planArn;

        private String executionId;

        private String comment;

        private String stepName;

        private String actionToTake;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePlanExecutionStepRequest model) {
            super(model);
            planArn(model.planArn);
            executionId(model.executionId);
            comment(model.comment);
            stepName(model.stepName);
            actionToTake(model.actionToTake);
        }

        public final String getPlanArn() {
            return planArn;
        }

        public final void setPlanArn(String planArn) {
            this.planArn = planArn;
        }

        @Override
        public final Builder planArn(String planArn) {
            this.planArn = planArn;
            return this;
        }

        public final String getExecutionId() {
            return executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getStepName() {
            return stepName;
        }

        public final void setStepName(String stepName) {
            this.stepName = stepName;
        }

        @Override
        public final Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public final String getActionToTake() {
            return actionToTake;
        }

        public final void setActionToTake(String actionToTake) {
            this.actionToTake = actionToTake;
        }

        @Override
        public final Builder actionToTake(String actionToTake) {
            this.actionToTake = actionToTake;
            return this;
        }

        @Override
        public final Builder actionToTake(UpdatePlanExecutionStepAction actionToTake) {
            this.actionToTake(actionToTake == null ? null : actionToTake.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePlanExecutionStepRequest build() {
            return new UpdatePlanExecutionStepRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
