/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.arcregionswitch.model.ApprovePlanExecutionStepRequest;
import software.amazon.awssdk.services.arcregionswitch.model.ApprovePlanExecutionStepResponse;
import software.amazon.awssdk.services.arcregionswitch.model.CancelPlanExecutionRequest;
import software.amazon.awssdk.services.arcregionswitch.model.CancelPlanExecutionResponse;
import software.amazon.awssdk.services.arcregionswitch.model.CreatePlanRequest;
import software.amazon.awssdk.services.arcregionswitch.model.CreatePlanResponse;
import software.amazon.awssdk.services.arcregionswitch.model.DeletePlanRequest;
import software.amazon.awssdk.services.arcregionswitch.model.DeletePlanResponse;
import software.amazon.awssdk.services.arcregionswitch.model.GetPlanEvaluationStatusRequest;
import software.amazon.awssdk.services.arcregionswitch.model.GetPlanEvaluationStatusResponse;
import software.amazon.awssdk.services.arcregionswitch.model.GetPlanExecutionRequest;
import software.amazon.awssdk.services.arcregionswitch.model.GetPlanExecutionResponse;
import software.amazon.awssdk.services.arcregionswitch.model.GetPlanInRegionRequest;
import software.amazon.awssdk.services.arcregionswitch.model.GetPlanInRegionResponse;
import software.amazon.awssdk.services.arcregionswitch.model.GetPlanRequest;
import software.amazon.awssdk.services.arcregionswitch.model.GetPlanResponse;
import software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionEventsRequest;
import software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionEventsResponse;
import software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionsRequest;
import software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionsResponse;
import software.amazon.awssdk.services.arcregionswitch.model.ListPlansInRegionRequest;
import software.amazon.awssdk.services.arcregionswitch.model.ListPlansInRegionResponse;
import software.amazon.awssdk.services.arcregionswitch.model.ListPlansRequest;
import software.amazon.awssdk.services.arcregionswitch.model.ListPlansResponse;
import software.amazon.awssdk.services.arcregionswitch.model.ListRoute53HealthChecksRequest;
import software.amazon.awssdk.services.arcregionswitch.model.ListRoute53HealthChecksResponse;
import software.amazon.awssdk.services.arcregionswitch.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.arcregionswitch.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.arcregionswitch.model.StartPlanExecutionRequest;
import software.amazon.awssdk.services.arcregionswitch.model.StartPlanExecutionResponse;
import software.amazon.awssdk.services.arcregionswitch.model.TagResourceRequest;
import software.amazon.awssdk.services.arcregionswitch.model.TagResourceResponse;
import software.amazon.awssdk.services.arcregionswitch.model.UntagResourceRequest;
import software.amazon.awssdk.services.arcregionswitch.model.UntagResourceResponse;
import software.amazon.awssdk.services.arcregionswitch.model.UpdatePlanExecutionRequest;
import software.amazon.awssdk.services.arcregionswitch.model.UpdatePlanExecutionResponse;
import software.amazon.awssdk.services.arcregionswitch.model.UpdatePlanExecutionStepRequest;
import software.amazon.awssdk.services.arcregionswitch.model.UpdatePlanExecutionStepResponse;
import software.amazon.awssdk.services.arcregionswitch.model.UpdatePlanRequest;
import software.amazon.awssdk.services.arcregionswitch.model.UpdatePlanResponse;
import software.amazon.awssdk.services.arcregionswitch.paginators.GetPlanEvaluationStatusPublisher;
import software.amazon.awssdk.services.arcregionswitch.paginators.GetPlanExecutionPublisher;
import software.amazon.awssdk.services.arcregionswitch.paginators.ListPlanExecutionEventsPublisher;
import software.amazon.awssdk.services.arcregionswitch.paginators.ListPlanExecutionsPublisher;
import software.amazon.awssdk.services.arcregionswitch.paginators.ListPlansInRegionPublisher;
import software.amazon.awssdk.services.arcregionswitch.paginators.ListPlansPublisher;
import software.amazon.awssdk.services.arcregionswitch.paginators.ListRoute53HealthChecksPublisher;
import software.amazon.awssdk.services.arcregionswitch.waiters.ArcRegionSwitchAsyncWaiter;

/**
 * Service client for accessing ARC - Region switch asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Amazon Application Recovery Controller (ARC) Region switch helps you to quickly and reliably shift traffic away from
 * an impaired Amazon Web Services Region to a healthy Region. With Region switch, you can create plans that define the
 * steps to shift traffic for your application from one Amazon Web Services Region to another. You can test your plans
 * in practice mode before using them in a real recovery scenario.
 * </p>
 * <p>
 * Region switch provides a structured approach to multi-Region failover, helping you to meet your recovery time
 * objectives (RTOs) and maintain business continuity during regional disruptions.
 * </p>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/region-switch.html">Region
 * switch in ARC</a> in the <i>Amazon Application Recovery Controller User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ArcRegionSwitchAsyncClient extends AwsClient {
    String SERVICE_NAME = "arc-region-switch";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "arc-region-switch";

    /**
     * <p>
     * Approves a step in a plan execution that requires manual approval. When you create a plan, you can include
     * approval steps that require manual intervention before the execution can proceed. This operation allows you to
     * provide that approval.
     * </p>
     * <p>
     * You must specify the plan ARN, execution ID, step name, and approval status. You can also provide an optional
     * comment explaining the approval decision.
     * </p>
     *
     * @param approvePlanExecutionStepRequest
     * @return A Java Future containing the result of the ApprovePlanExecutionStep operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.ApprovePlanExecutionStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/ApprovePlanExecutionStep"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ApprovePlanExecutionStepResponse> approvePlanExecutionStep(
            ApprovePlanExecutionStepRequest approvePlanExecutionStepRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Approves a step in a plan execution that requires manual approval. When you create a plan, you can include
     * approval steps that require manual intervention before the execution can proceed. This operation allows you to
     * provide that approval.
     * </p>
     * <p>
     * You must specify the plan ARN, execution ID, step name, and approval status. You can also provide an optional
     * comment explaining the approval decision.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ApprovePlanExecutionStepRequest.Builder} avoiding
     * the need to create one manually via {@link ApprovePlanExecutionStepRequest#builder()}
     * </p>
     *
     * @param approvePlanExecutionStepRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arcregionswitch.model.ApprovePlanExecutionStepRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ApprovePlanExecutionStep operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.ApprovePlanExecutionStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/ApprovePlanExecutionStep"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ApprovePlanExecutionStepResponse> approvePlanExecutionStep(
            Consumer<ApprovePlanExecutionStepRequest.Builder> approvePlanExecutionStepRequest) {
        return approvePlanExecutionStep(ApprovePlanExecutionStepRequest.builder().applyMutation(approvePlanExecutionStepRequest)
                .build());
    }

    /**
     * <p>
     * Cancels an in-progress plan execution. This operation stops the execution of the plan and prevents any further
     * steps from being processed.
     * </p>
     * <p>
     * You must specify the plan ARN and execution ID. You can also provide an optional comment explaining why the
     * execution was canceled.
     * </p>
     *
     * @param cancelPlanExecutionRequest
     * @return A Java Future containing the result of the CancelPlanExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.CancelPlanExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/CancelPlanExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelPlanExecutionResponse> cancelPlanExecution(
            CancelPlanExecutionRequest cancelPlanExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an in-progress plan execution. This operation stops the execution of the plan and prevents any further
     * steps from being processed.
     * </p>
     * <p>
     * You must specify the plan ARN and execution ID. You can also provide an optional comment explaining why the
     * execution was canceled.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelPlanExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link CancelPlanExecutionRequest#builder()}
     * </p>
     *
     * @param cancelPlanExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arcregionswitch.model.CancelPlanExecutionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CancelPlanExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.CancelPlanExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/CancelPlanExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelPlanExecutionResponse> cancelPlanExecution(
            Consumer<CancelPlanExecutionRequest.Builder> cancelPlanExecutionRequest) {
        return cancelPlanExecution(CancelPlanExecutionRequest.builder().applyMutation(cancelPlanExecutionRequest).build());
    }

    /**
     * <p>
     * Creates a new Region switch plan. A plan defines the steps required to shift traffic from one Amazon Web Services
     * Region to another.
     * </p>
     * <p>
     * You must specify a name for the plan, the primary Region, and at least one additional Region. You can also
     * provide a description, execution role, recovery time objective, associated alarms, triggers, and workflows that
     * define the steps to execute during a Region switch.
     * </p>
     *
     * @param createPlanRequest
     * @return A Java Future containing the result of the CreatePlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.CreatePlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/CreatePlan" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePlanResponse> createPlan(CreatePlanRequest createPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Region switch plan. A plan defines the steps required to shift traffic from one Amazon Web Services
     * Region to another.
     * </p>
     * <p>
     * You must specify a name for the plan, the primary Region, and at least one additional Region. You can also
     * provide a description, execution role, recovery time objective, associated alarms, triggers, and workflows that
     * define the steps to execute during a Region switch.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePlanRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePlanRequest#builder()}
     * </p>
     *
     * @param createPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arcregionswitch.model.CreatePlanRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreatePlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.CreatePlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/CreatePlan" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePlanResponse> createPlan(Consumer<CreatePlanRequest.Builder> createPlanRequest) {
        return createPlan(CreatePlanRequest.builder().applyMutation(createPlanRequest).build());
    }

    /**
     * <p>
     * Deletes a Region switch plan. You must specify the ARN of the plan to delete.
     * </p>
     * <p>
     * You cannot delete a plan that has an active execution in progress.
     * </p>
     *
     * @param deletePlanRequest
     * @return A Java Future containing the result of the DeletePlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>IllegalStateException The operation failed because the current state of the resource doesn't allow
     *         the operation to proceed.</p>
     *         <p>
     *         HTTP Status Code: 400</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.DeletePlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/DeletePlan" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePlanResponse> deletePlan(DeletePlanRequest deletePlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Region switch plan. You must specify the ARN of the plan to delete.
     * </p>
     * <p>
     * You cannot delete a plan that has an active execution in progress.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePlanRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePlanRequest#builder()}
     * </p>
     *
     * @param deletePlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arcregionswitch.model.DeletePlanRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeletePlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>IllegalStateException The operation failed because the current state of the resource doesn't allow
     *         the operation to proceed.</p>
     *         <p>
     *         HTTP Status Code: 400</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.DeletePlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/DeletePlan" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePlanResponse> deletePlan(Consumer<DeletePlanRequest.Builder> deletePlanRequest) {
        return deletePlan(DeletePlanRequest.builder().applyMutation(deletePlanRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about a Region switch plan. You must specify the ARN of the plan.
     * </p>
     *
     * @param getPlanRequest
     * @return A Java Future containing the result of the GetPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.GetPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/GetPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPlanResponse> getPlan(GetPlanRequest getPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information about a Region switch plan. You must specify the ARN of the plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPlanRequest.Builder} avoiding the need to create
     * one manually via {@link GetPlanRequest#builder()}
     * </p>
     *
     * @param getPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arcregionswitch.model.GetPlanRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.GetPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/GetPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPlanResponse> getPlan(Consumer<GetPlanRequest.Builder> getPlanRequest) {
        return getPlan(GetPlanRequest.builder().applyMutation(getPlanRequest).build());
    }

    /**
     * <p>
     * Retrieves the evaluation status of a Region switch plan. The evaluation status provides information about the
     * last time the plan was evaluated and any warnings or issues detected.
     * </p>
     *
     * @param getPlanEvaluationStatusRequest
     * @return A Java Future containing the result of the GetPlanEvaluationStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.GetPlanEvaluationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/GetPlanEvaluationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPlanEvaluationStatusResponse> getPlanEvaluationStatus(
            GetPlanEvaluationStatusRequest getPlanEvaluationStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the evaluation status of a Region switch plan. The evaluation status provides information about the
     * last time the plan was evaluated and any warnings or issues detected.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPlanEvaluationStatusRequest.Builder} avoiding
     * the need to create one manually via {@link GetPlanEvaluationStatusRequest#builder()}
     * </p>
     *
     * @param getPlanEvaluationStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arcregionswitch.model.GetPlanEvaluationStatusRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetPlanEvaluationStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.GetPlanEvaluationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/GetPlanEvaluationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPlanEvaluationStatusResponse> getPlanEvaluationStatus(
            Consumer<GetPlanEvaluationStatusRequest.Builder> getPlanEvaluationStatusRequest) {
        return getPlanEvaluationStatus(GetPlanEvaluationStatusRequest.builder().applyMutation(getPlanEvaluationStatusRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getPlanEvaluationStatus(software.amazon.awssdk.services.arcregionswitch.model.GetPlanEvaluationStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arcregionswitch.paginators.GetPlanEvaluationStatusPublisher publisher = client.getPlanEvaluationStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arcregionswitch.paginators.GetPlanEvaluationStatusPublisher publisher = client.getPlanEvaluationStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.arcregionswitch.model.GetPlanEvaluationStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.arcregionswitch.model.GetPlanEvaluationStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getPlanEvaluationStatus(software.amazon.awssdk.services.arcregionswitch.model.GetPlanEvaluationStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param getPlanEvaluationStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.GetPlanEvaluationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/GetPlanEvaluationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPlanEvaluationStatusPublisher getPlanEvaluationStatusPaginator(
            GetPlanEvaluationStatusRequest getPlanEvaluationStatusRequest) {
        return new GetPlanEvaluationStatusPublisher(this, getPlanEvaluationStatusRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getPlanEvaluationStatus(software.amazon.awssdk.services.arcregionswitch.model.GetPlanEvaluationStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arcregionswitch.paginators.GetPlanEvaluationStatusPublisher publisher = client.getPlanEvaluationStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arcregionswitch.paginators.GetPlanEvaluationStatusPublisher publisher = client.getPlanEvaluationStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.arcregionswitch.model.GetPlanEvaluationStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.arcregionswitch.model.GetPlanEvaluationStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getPlanEvaluationStatus(software.amazon.awssdk.services.arcregionswitch.model.GetPlanEvaluationStatusRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPlanEvaluationStatusRequest.Builder} avoiding
     * the need to create one manually via {@link GetPlanEvaluationStatusRequest#builder()}
     * </p>
     *
     * @param getPlanEvaluationStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arcregionswitch.model.GetPlanEvaluationStatusRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.GetPlanEvaluationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/GetPlanEvaluationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPlanEvaluationStatusPublisher getPlanEvaluationStatusPaginator(
            Consumer<GetPlanEvaluationStatusRequest.Builder> getPlanEvaluationStatusRequest) {
        return getPlanEvaluationStatusPaginator(GetPlanEvaluationStatusRequest.builder()
                .applyMutation(getPlanEvaluationStatusRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about a specific plan execution. You must specify the plan ARN and execution ID.
     * </p>
     *
     * @param getPlanExecutionRequest
     * @return A Java Future containing the result of the GetPlanExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.GetPlanExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/GetPlanExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPlanExecutionResponse> getPlanExecution(GetPlanExecutionRequest getPlanExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information about a specific plan execution. You must specify the plan ARN and execution ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPlanExecutionRequest.Builder} avoiding the need
     * to create one manually via {@link GetPlanExecutionRequest#builder()}
     * </p>
     *
     * @param getPlanExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arcregionswitch.model.GetPlanExecutionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetPlanExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.GetPlanExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/GetPlanExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPlanExecutionResponse> getPlanExecution(
            Consumer<GetPlanExecutionRequest.Builder> getPlanExecutionRequest) {
        return getPlanExecution(GetPlanExecutionRequest.builder().applyMutation(getPlanExecutionRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getPlanExecution(software.amazon.awssdk.services.arcregionswitch.model.GetPlanExecutionRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arcregionswitch.paginators.GetPlanExecutionPublisher publisher = client.getPlanExecutionPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arcregionswitch.paginators.GetPlanExecutionPublisher publisher = client.getPlanExecutionPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.arcregionswitch.model.GetPlanExecutionResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.arcregionswitch.model.GetPlanExecutionResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getPlanExecution(software.amazon.awssdk.services.arcregionswitch.model.GetPlanExecutionRequest)}
     * operation.</b>
     * </p>
     *
     * @param getPlanExecutionRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.GetPlanExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/GetPlanExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPlanExecutionPublisher getPlanExecutionPaginator(GetPlanExecutionRequest getPlanExecutionRequest) {
        return new GetPlanExecutionPublisher(this, getPlanExecutionRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getPlanExecution(software.amazon.awssdk.services.arcregionswitch.model.GetPlanExecutionRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arcregionswitch.paginators.GetPlanExecutionPublisher publisher = client.getPlanExecutionPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arcregionswitch.paginators.GetPlanExecutionPublisher publisher = client.getPlanExecutionPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.arcregionswitch.model.GetPlanExecutionResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.arcregionswitch.model.GetPlanExecutionResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getPlanExecution(software.amazon.awssdk.services.arcregionswitch.model.GetPlanExecutionRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPlanExecutionRequest.Builder} avoiding the need
     * to create one manually via {@link GetPlanExecutionRequest#builder()}
     * </p>
     *
     * @param getPlanExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arcregionswitch.model.GetPlanExecutionRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.GetPlanExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/GetPlanExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPlanExecutionPublisher getPlanExecutionPaginator(Consumer<GetPlanExecutionRequest.Builder> getPlanExecutionRequest) {
        return getPlanExecutionPaginator(GetPlanExecutionRequest.builder().applyMutation(getPlanExecutionRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a Region switch plan in a specific Amazon Web Services Region. This operation is
     * useful for getting Region-specific information about a plan.
     * </p>
     *
     * @param getPlanInRegionRequest
     * @return A Java Future containing the result of the GetPlanInRegion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.GetPlanInRegion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/GetPlanInRegion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPlanInRegionResponse> getPlanInRegion(GetPlanInRegionRequest getPlanInRegionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a Region switch plan in a specific Amazon Web Services Region. This operation is
     * useful for getting Region-specific information about a plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPlanInRegionRequest.Builder} avoiding the need
     * to create one manually via {@link GetPlanInRegionRequest#builder()}
     * </p>
     *
     * @param getPlanInRegionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arcregionswitch.model.GetPlanInRegionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetPlanInRegion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.GetPlanInRegion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/GetPlanInRegion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPlanInRegionResponse> getPlanInRegion(
            Consumer<GetPlanInRegionRequest.Builder> getPlanInRegionRequest) {
        return getPlanInRegion(GetPlanInRegionRequest.builder().applyMutation(getPlanInRegionRequest).build());
    }

    /**
     * <p>
     * Lists the events that occurred during a plan execution. These events provide a detailed timeline of the execution
     * process.
     * </p>
     *
     * @param listPlanExecutionEventsRequest
     * @return A Java Future containing the result of the ListPlanExecutionEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.ListPlanExecutionEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/ListPlanExecutionEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPlanExecutionEventsResponse> listPlanExecutionEvents(
            ListPlanExecutionEventsRequest listPlanExecutionEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the events that occurred during a plan execution. These events provide a detailed timeline of the execution
     * process.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlanExecutionEventsRequest.Builder} avoiding
     * the need to create one manually via {@link ListPlanExecutionEventsRequest#builder()}
     * </p>
     *
     * @param listPlanExecutionEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionEventsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListPlanExecutionEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.ListPlanExecutionEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/ListPlanExecutionEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPlanExecutionEventsResponse> listPlanExecutionEvents(
            Consumer<ListPlanExecutionEventsRequest.Builder> listPlanExecutionEventsRequest) {
        return listPlanExecutionEvents(ListPlanExecutionEventsRequest.builder().applyMutation(listPlanExecutionEventsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPlanExecutionEvents(software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arcregionswitch.paginators.ListPlanExecutionEventsPublisher publisher = client.listPlanExecutionEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arcregionswitch.paginators.ListPlanExecutionEventsPublisher publisher = client.listPlanExecutionEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlanExecutionEvents(software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPlanExecutionEventsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.ListPlanExecutionEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/ListPlanExecutionEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlanExecutionEventsPublisher listPlanExecutionEventsPaginator(
            ListPlanExecutionEventsRequest listPlanExecutionEventsRequest) {
        return new ListPlanExecutionEventsPublisher(this, listPlanExecutionEventsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPlanExecutionEvents(software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arcregionswitch.paginators.ListPlanExecutionEventsPublisher publisher = client.listPlanExecutionEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arcregionswitch.paginators.ListPlanExecutionEventsPublisher publisher = client.listPlanExecutionEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlanExecutionEvents(software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionEventsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlanExecutionEventsRequest.Builder} avoiding
     * the need to create one manually via {@link ListPlanExecutionEventsRequest#builder()}
     * </p>
     *
     * @param listPlanExecutionEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionEventsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.ListPlanExecutionEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/ListPlanExecutionEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlanExecutionEventsPublisher listPlanExecutionEventsPaginator(
            Consumer<ListPlanExecutionEventsRequest.Builder> listPlanExecutionEventsRequest) {
        return listPlanExecutionEventsPaginator(ListPlanExecutionEventsRequest.builder()
                .applyMutation(listPlanExecutionEventsRequest).build());
    }

    /**
     * <p>
     * Lists the executions of a Region switch plan. This operation returns information about both current and
     * historical executions.
     * </p>
     *
     * @param listPlanExecutionsRequest
     * @return A Java Future containing the result of the ListPlanExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.ListPlanExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/ListPlanExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPlanExecutionsResponse> listPlanExecutions(ListPlanExecutionsRequest listPlanExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the executions of a Region switch plan. This operation returns information about both current and
     * historical executions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlanExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPlanExecutionsRequest#builder()}
     * </p>
     *
     * @param listPlanExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListPlanExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.ListPlanExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/ListPlanExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPlanExecutionsResponse> listPlanExecutions(
            Consumer<ListPlanExecutionsRequest.Builder> listPlanExecutionsRequest) {
        return listPlanExecutions(ListPlanExecutionsRequest.builder().applyMutation(listPlanExecutionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPlanExecutions(software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arcregionswitch.paginators.ListPlanExecutionsPublisher publisher = client.listPlanExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arcregionswitch.paginators.ListPlanExecutionsPublisher publisher = client.listPlanExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlanExecutions(software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPlanExecutionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.ListPlanExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/ListPlanExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlanExecutionsPublisher listPlanExecutionsPaginator(ListPlanExecutionsRequest listPlanExecutionsRequest) {
        return new ListPlanExecutionsPublisher(this, listPlanExecutionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPlanExecutions(software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arcregionswitch.paginators.ListPlanExecutionsPublisher publisher = client.listPlanExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arcregionswitch.paginators.ListPlanExecutionsPublisher publisher = client.listPlanExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlanExecutions(software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlanExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPlanExecutionsRequest#builder()}
     * </p>
     *
     * @param listPlanExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.ListPlanExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/ListPlanExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlanExecutionsPublisher listPlanExecutionsPaginator(
            Consumer<ListPlanExecutionsRequest.Builder> listPlanExecutionsRequest) {
        return listPlanExecutionsPaginator(ListPlanExecutionsRequest.builder().applyMutation(listPlanExecutionsRequest).build());
    }

    /**
     * <p>
     * Lists all Region switch plans in your Amazon Web Services account.
     * </p>
     *
     * @param listPlansRequest
     * @return A Java Future containing the result of the ListPlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.ListPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/ListPlans" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPlansResponse> listPlans(ListPlansRequest listPlansRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Region switch plans in your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlansRequest.Builder} avoiding the need to
     * create one manually via {@link ListPlansRequest#builder()}
     * </p>
     *
     * @param listPlansRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arcregionswitch.model.ListPlansRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.ListPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/ListPlans" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPlansResponse> listPlans(Consumer<ListPlansRequest.Builder> listPlansRequest) {
        return listPlans(ListPlansRequest.builder().applyMutation(listPlansRequest).build());
    }

    /**
     * <p>
     * Lists all Region switch plans in your Amazon Web Services account that are available in the current Amazon Web
     * Services Region.
     * </p>
     *
     * @param listPlansInRegionRequest
     * @return A Java Future containing the result of the ListPlansInRegion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.ListPlansInRegion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/ListPlansInRegion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPlansInRegionResponse> listPlansInRegion(ListPlansInRegionRequest listPlansInRegionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Region switch plans in your Amazon Web Services account that are available in the current Amazon Web
     * Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlansInRegionRequest.Builder} avoiding the need
     * to create one manually via {@link ListPlansInRegionRequest#builder()}
     * </p>
     *
     * @param listPlansInRegionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arcregionswitch.model.ListPlansInRegionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPlansInRegion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.ListPlansInRegion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/ListPlansInRegion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPlansInRegionResponse> listPlansInRegion(
            Consumer<ListPlansInRegionRequest.Builder> listPlansInRegionRequest) {
        return listPlansInRegion(ListPlansInRegionRequest.builder().applyMutation(listPlansInRegionRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPlansInRegion(software.amazon.awssdk.services.arcregionswitch.model.ListPlansInRegionRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arcregionswitch.paginators.ListPlansInRegionPublisher publisher = client.listPlansInRegionPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arcregionswitch.paginators.ListPlansInRegionPublisher publisher = client.listPlansInRegionPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.arcregionswitch.model.ListPlansInRegionResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.arcregionswitch.model.ListPlansInRegionResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlansInRegion(software.amazon.awssdk.services.arcregionswitch.model.ListPlansInRegionRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPlansInRegionRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.ListPlansInRegion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/ListPlansInRegion"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlansInRegionPublisher listPlansInRegionPaginator(ListPlansInRegionRequest listPlansInRegionRequest) {
        return new ListPlansInRegionPublisher(this, listPlansInRegionRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPlansInRegion(software.amazon.awssdk.services.arcregionswitch.model.ListPlansInRegionRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arcregionswitch.paginators.ListPlansInRegionPublisher publisher = client.listPlansInRegionPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arcregionswitch.paginators.ListPlansInRegionPublisher publisher = client.listPlansInRegionPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.arcregionswitch.model.ListPlansInRegionResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.arcregionswitch.model.ListPlansInRegionResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlansInRegion(software.amazon.awssdk.services.arcregionswitch.model.ListPlansInRegionRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlansInRegionRequest.Builder} avoiding the need
     * to create one manually via {@link ListPlansInRegionRequest#builder()}
     * </p>
     *
     * @param listPlansInRegionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arcregionswitch.model.ListPlansInRegionRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.ListPlansInRegion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/ListPlansInRegion"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlansInRegionPublisher listPlansInRegionPaginator(
            Consumer<ListPlansInRegionRequest.Builder> listPlansInRegionRequest) {
        return listPlansInRegionPaginator(ListPlansInRegionRequest.builder().applyMutation(listPlansInRegionRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listPlans(software.amazon.awssdk.services.arcregionswitch.model.ListPlansRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arcregionswitch.paginators.ListPlansPublisher publisher = client.listPlansPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arcregionswitch.paginators.ListPlansPublisher publisher = client.listPlansPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.arcregionswitch.model.ListPlansResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.arcregionswitch.model.ListPlansResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlans(software.amazon.awssdk.services.arcregionswitch.model.ListPlansRequest)} operation.</b>
     * </p>
     *
     * @param listPlansRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.ListPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/ListPlans" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPlansPublisher listPlansPaginator(ListPlansRequest listPlansRequest) {
        return new ListPlansPublisher(this, listPlansRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listPlans(software.amazon.awssdk.services.arcregionswitch.model.ListPlansRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arcregionswitch.paginators.ListPlansPublisher publisher = client.listPlansPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arcregionswitch.paginators.ListPlansPublisher publisher = client.listPlansPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.arcregionswitch.model.ListPlansResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.arcregionswitch.model.ListPlansResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlans(software.amazon.awssdk.services.arcregionswitch.model.ListPlansRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlansRequest.Builder} avoiding the need to
     * create one manually via {@link ListPlansRequest#builder()}
     * </p>
     *
     * @param listPlansRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arcregionswitch.model.ListPlansRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.ListPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/ListPlans" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPlansPublisher listPlansPaginator(Consumer<ListPlansRequest.Builder> listPlansRequest) {
        return listPlansPaginator(ListPlansRequest.builder().applyMutation(listPlansRequest).build());
    }

    /**
     * <p>
     * List the Amazon Route 53 health checks.
     * </p>
     *
     * @param listRoute53HealthChecksRequest
     * @return A Java Future containing the result of the ListRoute53HealthChecks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</p>
     *         <p>
     *         HTTP Status Code: 500</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.ListRoute53HealthChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/ListRoute53HealthChecks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRoute53HealthChecksResponse> listRoute53HealthChecks(
            ListRoute53HealthChecksRequest listRoute53HealthChecksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the Amazon Route 53 health checks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRoute53HealthChecksRequest.Builder} avoiding
     * the need to create one manually via {@link ListRoute53HealthChecksRequest#builder()}
     * </p>
     *
     * @param listRoute53HealthChecksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arcregionswitch.model.ListRoute53HealthChecksRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListRoute53HealthChecks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</p>
     *         <p>
     *         HTTP Status Code: 500</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.ListRoute53HealthChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/ListRoute53HealthChecks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRoute53HealthChecksResponse> listRoute53HealthChecks(
            Consumer<ListRoute53HealthChecksRequest.Builder> listRoute53HealthChecksRequest) {
        return listRoute53HealthChecks(ListRoute53HealthChecksRequest.builder().applyMutation(listRoute53HealthChecksRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRoute53HealthChecks(software.amazon.awssdk.services.arcregionswitch.model.ListRoute53HealthChecksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arcregionswitch.paginators.ListRoute53HealthChecksPublisher publisher = client.listRoute53HealthChecksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arcregionswitch.paginators.ListRoute53HealthChecksPublisher publisher = client.listRoute53HealthChecksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.arcregionswitch.model.ListRoute53HealthChecksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.arcregionswitch.model.ListRoute53HealthChecksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRoute53HealthChecks(software.amazon.awssdk.services.arcregionswitch.model.ListRoute53HealthChecksRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRoute53HealthChecksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</p>
     *         <p>
     *         HTTP Status Code: 500</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.ListRoute53HealthChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/ListRoute53HealthChecks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRoute53HealthChecksPublisher listRoute53HealthChecksPaginator(
            ListRoute53HealthChecksRequest listRoute53HealthChecksRequest) {
        return new ListRoute53HealthChecksPublisher(this, listRoute53HealthChecksRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRoute53HealthChecks(software.amazon.awssdk.services.arcregionswitch.model.ListRoute53HealthChecksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arcregionswitch.paginators.ListRoute53HealthChecksPublisher publisher = client.listRoute53HealthChecksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arcregionswitch.paginators.ListRoute53HealthChecksPublisher publisher = client.listRoute53HealthChecksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.arcregionswitch.model.ListRoute53HealthChecksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.arcregionswitch.model.ListRoute53HealthChecksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRoute53HealthChecks(software.amazon.awssdk.services.arcregionswitch.model.ListRoute53HealthChecksRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRoute53HealthChecksRequest.Builder} avoiding
     * the need to create one manually via {@link ListRoute53HealthChecksRequest#builder()}
     * </p>
     *
     * @param listRoute53HealthChecksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arcregionswitch.model.ListRoute53HealthChecksRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</p>
     *         <p>
     *         HTTP Status Code: 500</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.ListRoute53HealthChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/ListRoute53HealthChecks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRoute53HealthChecksPublisher listRoute53HealthChecksPaginator(
            Consumer<ListRoute53HealthChecksRequest.Builder> listRoute53HealthChecksRequest) {
        return listRoute53HealthChecksPaginator(ListRoute53HealthChecksRequest.builder()
                .applyMutation(listRoute53HealthChecksRequest).build());
    }

    /**
     * <p>
     * Lists the tags attached to a Region switch resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</p>
     *         <p>
     *         HTTP Status Code: 500</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags attached to a Region switch resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arcregionswitch.model.ListTagsForResourceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</p>
     *         <p>
     *         HTTP Status Code: 500</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Starts the execution of a Region switch plan. You can execute a plan in either PRACTICE or RECOVERY mode.
     * </p>
     * <p>
     * In PRACTICE mode, the execution simulates the steps without making actual changes to your application's traffic
     * routing. In RECOVERY mode, the execution performs actual changes to shift traffic between Regions.
     * </p>
     *
     * @param startPlanExecutionRequest
     * @return A Java Future containing the result of the StartPlanExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>IllegalStateException The operation failed because the current state of the resource doesn't allow
     *         the operation to proceed.</p>
     *         <p>
     *         HTTP Status Code: 400</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>IllegalArgumentException The request processing has an invalid argument.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.StartPlanExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/StartPlanExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartPlanExecutionResponse> startPlanExecution(StartPlanExecutionRequest startPlanExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the execution of a Region switch plan. You can execute a plan in either PRACTICE or RECOVERY mode.
     * </p>
     * <p>
     * In PRACTICE mode, the execution simulates the steps without making actual changes to your application's traffic
     * routing. In RECOVERY mode, the execution performs actual changes to shift traffic between Regions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartPlanExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link StartPlanExecutionRequest#builder()}
     * </p>
     *
     * @param startPlanExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arcregionswitch.model.StartPlanExecutionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the StartPlanExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>IllegalStateException The operation failed because the current state of the resource doesn't allow
     *         the operation to proceed.</p>
     *         <p>
     *         HTTP Status Code: 400</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>IllegalArgumentException The request processing has an invalid argument.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.StartPlanExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/StartPlanExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartPlanExecutionResponse> startPlanExecution(
            Consumer<StartPlanExecutionRequest.Builder> startPlanExecutionRequest) {
        return startPlanExecution(StartPlanExecutionRequest.builder().applyMutation(startPlanExecutionRequest).build());
    }

    /**
     * <p>
     * Adds or updates tags for a Region switch resource. You can assign metadata to your resources in the form of tags,
     * which are key-value pairs.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</p>
     *         <p>
     *         HTTP Status Code: 500</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates tags for a Region switch resource. You can assign metadata to your resources in the form of tags,
     * which are key-value pairs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arcregionswitch.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</p>
     *         <p>
     *         HTTP Status Code: 500</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a Region switch resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</p>
     *         <p>
     *         HTTP Status Code: 500</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a Region switch resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arcregionswitch.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</p>
     *         <p>
     *         HTTP Status Code: 500</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing Region switch plan. You can modify the plan's description, workflows, execution role,
     * recovery time objective, associated alarms, and triggers.
     * </p>
     *
     * @param updatePlanRequest
     * @return A Java Future containing the result of the UpdatePlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.UpdatePlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/UpdatePlan" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdatePlanResponse> updatePlan(UpdatePlanRequest updatePlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Region switch plan. You can modify the plan's description, workflows, execution role,
     * recovery time objective, associated alarms, and triggers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePlanRequest.Builder} avoiding the need to
     * create one manually via {@link UpdatePlanRequest#builder()}
     * </p>
     *
     * @param updatePlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arcregionswitch.model.UpdatePlanRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdatePlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.UpdatePlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/UpdatePlan" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdatePlanResponse> updatePlan(Consumer<UpdatePlanRequest.Builder> updatePlanRequest) {
        return updatePlan(UpdatePlanRequest.builder().applyMutation(updatePlanRequest).build());
    }

    /**
     * <p>
     * Updates an in-progress plan execution. This operation allows you to modify certain aspects of the execution, such
     * as adding a comment or changing the action.
     * </p>
     *
     * @param updatePlanExecutionRequest
     * @return A Java Future containing the result of the UpdatePlanExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>IllegalStateException The operation failed because the current state of the resource doesn't allow
     *         the operation to proceed.</p>
     *         <p>
     *         HTTP Status Code: 400</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.UpdatePlanExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/UpdatePlanExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePlanExecutionResponse> updatePlanExecution(
            UpdatePlanExecutionRequest updatePlanExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an in-progress plan execution. This operation allows you to modify certain aspects of the execution, such
     * as adding a comment or changing the action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePlanExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdatePlanExecutionRequest#builder()}
     * </p>
     *
     * @param updatePlanExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arcregionswitch.model.UpdatePlanExecutionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdatePlanExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>IllegalStateException The operation failed because the current state of the resource doesn't allow
     *         the operation to proceed.</p>
     *         <p>
     *         HTTP Status Code: 400</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.UpdatePlanExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/UpdatePlanExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePlanExecutionResponse> updatePlanExecution(
            Consumer<UpdatePlanExecutionRequest.Builder> updatePlanExecutionRequest) {
        return updatePlanExecution(UpdatePlanExecutionRequest.builder().applyMutation(updatePlanExecutionRequest).build());
    }

    /**
     * <p>
     * Updates a specific step in an in-progress plan execution. This operation allows you to modify the step's comment
     * or action.
     * </p>
     *
     * @param updatePlanExecutionStepRequest
     * @return A Java Future containing the result of the UpdatePlanExecutionStep operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.UpdatePlanExecutionStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/UpdatePlanExecutionStep"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePlanExecutionStepResponse> updatePlanExecutionStep(
            UpdatePlanExecutionStepRequest updatePlanExecutionStepRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a specific step in an in-progress plan execution. This operation allows you to modify the step's comment
     * or action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePlanExecutionStepRequest.Builder} avoiding
     * the need to create one manually via {@link UpdatePlanExecutionStepRequest#builder()}
     * </p>
     *
     * @param updatePlanExecutionStepRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arcregionswitch.model.UpdatePlanExecutionStepRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdatePlanExecutionStep operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</p>
     *         <p>
     *         HTTP Status Code: 404</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</p>
     *         <p>
     *         HTTP Status Code: 403</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcRegionSwitchException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ArcRegionSwitchAsyncClient.UpdatePlanExecutionStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-region-switch-2022-07-26/UpdatePlanExecutionStep"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePlanExecutionStepResponse> updatePlanExecutionStep(
            Consumer<UpdatePlanExecutionStepRequest.Builder> updatePlanExecutionStepRequest) {
        return updatePlanExecutionStep(UpdatePlanExecutionStepRequest.builder().applyMutation(updatePlanExecutionStepRequest)
                .build());
    }

    /**
     * Create an instance of {@link ArcRegionSwitchAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link ArcRegionSwitchAsyncWaiter}
     */
    default ArcRegionSwitchAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    @Override
    default ArcRegionSwitchServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link ArcRegionSwitchAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ArcRegionSwitchAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ArcRegionSwitchAsyncClient}.
     */
    static ArcRegionSwitchAsyncClientBuilder builder() {
        return new DefaultArcRegionSwitchAsyncClientBuilder();
    }
}
