/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a warning about a resource in a Region switch plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceWarning implements SdkPojo, Serializable, ToCopyableBuilder<ResourceWarning.Builder, ResourceWarning> {
    private static final SdkField<MinimalWorkflow> WORKFLOW_FIELD = SdkField.<MinimalWorkflow> builder(MarshallingType.SDK_POJO)
            .memberName("workflow").getter(getter(ResourceWarning::workflow)).setter(setter(Builder::workflow))
            .constructor(MinimalWorkflow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflow").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(ResourceWarning::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> STEP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stepName").getter(getter(ResourceWarning::stepName)).setter(setter(Builder::stepName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepName").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(ResourceWarning::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> WARNING_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("warningStatus").getter(getter(ResourceWarning::warningStatusAsString))
            .setter(setter(Builder::warningStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warningStatus").build()).build();

    private static final SdkField<Instant> WARNING_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("warningUpdatedTime").getter(getter(ResourceWarning::warningUpdatedTime))
            .setter(setter(Builder::warningUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warningUpdatedTime").build())
            .build();

    private static final SdkField<String> WARNING_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("warningMessage").getter(getter(ResourceWarning::warningMessage)).setter(setter(Builder::warningMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warningMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_FIELD, VERSION_FIELD,
            STEP_NAME_FIELD, RESOURCE_ARN_FIELD, WARNING_STATUS_FIELD, WARNING_UPDATED_TIME_FIELD, WARNING_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MinimalWorkflow workflow;

    private final String version;

    private final String stepName;

    private final String resourceArn;

    private final String warningStatus;

    private final Instant warningUpdatedTime;

    private final String warningMessage;

    private ResourceWarning(BuilderImpl builder) {
        this.workflow = builder.workflow;
        this.version = builder.version;
        this.stepName = builder.stepName;
        this.resourceArn = builder.resourceArn;
        this.warningStatus = builder.warningStatus;
        this.warningUpdatedTime = builder.warningUpdatedTime;
        this.warningMessage = builder.warningMessage;
    }

    /**
     * <p>
     * The workflow for the resource warning.
     * </p>
     * 
     * @return The workflow for the resource warning.
     */
    public final MinimalWorkflow workflow() {
        return workflow;
    }

    /**
     * <p>
     * The version for the resource warning.
     * </p>
     * 
     * @return The version for the resource warning.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The name of the step for the resource warning.
     * </p>
     * 
     * @return The name of the step for the resource warning.
     */
    public final String stepName() {
        return stepName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The status of the resource warning.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #warningStatus}
     * will return {@link ResourceWarningStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #warningStatusAsString}.
     * </p>
     * 
     * @return The status of the resource warning.
     * @see ResourceWarningStatus
     */
    public final ResourceWarningStatus warningStatus() {
        return ResourceWarningStatus.fromValue(warningStatus);
    }

    /**
     * <p>
     * The status of the resource warning.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #warningStatus}
     * will return {@link ResourceWarningStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #warningStatusAsString}.
     * </p>
     * 
     * @return The status of the resource warning.
     * @see ResourceWarningStatus
     */
    public final String warningStatusAsString() {
        return warningStatus;
    }

    /**
     * <p>
     * The timestamp when the warning was last updated.
     * </p>
     * 
     * @return The timestamp when the warning was last updated.
     */
    public final Instant warningUpdatedTime() {
        return warningUpdatedTime;
    }

    /**
     * <p>
     * The warning message about what needs to be corrected.
     * </p>
     * 
     * @return The warning message about what needs to be corrected.
     */
    public final String warningMessage() {
        return warningMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workflow());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(stepName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(warningStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(warningUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(warningMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceWarning)) {
            return false;
        }
        ResourceWarning other = (ResourceWarning) obj;
        return Objects.equals(workflow(), other.workflow()) && Objects.equals(version(), other.version())
                && Objects.equals(stepName(), other.stepName()) && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(warningStatusAsString(), other.warningStatusAsString())
                && Objects.equals(warningUpdatedTime(), other.warningUpdatedTime())
                && Objects.equals(warningMessage(), other.warningMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceWarning").add("Workflow", workflow()).add("Version", version())
                .add("StepName", stepName()).add("ResourceArn", resourceArn()).add("WarningStatus", warningStatusAsString())
                .add("WarningUpdatedTime", warningUpdatedTime()).add("WarningMessage", warningMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workflow":
            return Optional.ofNullable(clazz.cast(workflow()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "stepName":
            return Optional.ofNullable(clazz.cast(stepName()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "warningStatus":
            return Optional.ofNullable(clazz.cast(warningStatusAsString()));
        case "warningUpdatedTime":
            return Optional.ofNullable(clazz.cast(warningUpdatedTime()));
        case "warningMessage":
            return Optional.ofNullable(clazz.cast(warningMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("workflow", WORKFLOW_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("stepName", STEP_NAME_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("warningStatus", WARNING_STATUS_FIELD);
        map.put("warningUpdatedTime", WARNING_UPDATED_TIME_FIELD);
        map.put("warningMessage", WARNING_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceWarning, T> g) {
        return obj -> g.apply((ResourceWarning) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceWarning> {
        /**
         * <p>
         * The workflow for the resource warning.
         * </p>
         * 
         * @param workflow
         *        The workflow for the resource warning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflow(MinimalWorkflow workflow);

        /**
         * <p>
         * The workflow for the resource warning.
         * </p>
         * This is a convenience method that creates an instance of the {@link MinimalWorkflow.Builder} avoiding the
         * need to create one manually via {@link MinimalWorkflow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MinimalWorkflow.Builder#build()} is called immediately and its
         * result is passed to {@link #workflow(MinimalWorkflow)}.
         * 
         * @param workflow
         *        a consumer that will call methods on {@link MinimalWorkflow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflow(MinimalWorkflow)
         */
        default Builder workflow(Consumer<MinimalWorkflow.Builder> workflow) {
            return workflow(MinimalWorkflow.builder().applyMutation(workflow).build());
        }

        /**
         * <p>
         * The version for the resource warning.
         * </p>
         * 
         * @param version
         *        The version for the resource warning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The name of the step for the resource warning.
         * </p>
         * 
         * @param stepName
         *        The name of the step for the resource warning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepName(String stepName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The status of the resource warning.
         * </p>
         * 
         * @param warningStatus
         *        The status of the resource warning.
         * @see ResourceWarningStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceWarningStatus
         */
        Builder warningStatus(String warningStatus);

        /**
         * <p>
         * The status of the resource warning.
         * </p>
         * 
         * @param warningStatus
         *        The status of the resource warning.
         * @see ResourceWarningStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceWarningStatus
         */
        Builder warningStatus(ResourceWarningStatus warningStatus);

        /**
         * <p>
         * The timestamp when the warning was last updated.
         * </p>
         * 
         * @param warningUpdatedTime
         *        The timestamp when the warning was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warningUpdatedTime(Instant warningUpdatedTime);

        /**
         * <p>
         * The warning message about what needs to be corrected.
         * </p>
         * 
         * @param warningMessage
         *        The warning message about what needs to be corrected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warningMessage(String warningMessage);
    }

    static final class BuilderImpl implements Builder {
        private MinimalWorkflow workflow;

        private String version;

        private String stepName;

        private String resourceArn;

        private String warningStatus;

        private Instant warningUpdatedTime;

        private String warningMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceWarning model) {
            workflow(model.workflow);
            version(model.version);
            stepName(model.stepName);
            resourceArn(model.resourceArn);
            warningStatus(model.warningStatus);
            warningUpdatedTime(model.warningUpdatedTime);
            warningMessage(model.warningMessage);
        }

        public final MinimalWorkflow.Builder getWorkflow() {
            return workflow != null ? workflow.toBuilder() : null;
        }

        public final void setWorkflow(MinimalWorkflow.BuilderImpl workflow) {
            this.workflow = workflow != null ? workflow.build() : null;
        }

        @Override
        public final Builder workflow(MinimalWorkflow workflow) {
            this.workflow = workflow;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getStepName() {
            return stepName;
        }

        public final void setStepName(String stepName) {
            this.stepName = stepName;
        }

        @Override
        public final Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getWarningStatus() {
            return warningStatus;
        }

        public final void setWarningStatus(String warningStatus) {
            this.warningStatus = warningStatus;
        }

        @Override
        public final Builder warningStatus(String warningStatus) {
            this.warningStatus = warningStatus;
            return this;
        }

        @Override
        public final Builder warningStatus(ResourceWarningStatus warningStatus) {
            this.warningStatus(warningStatus == null ? null : warningStatus.toString());
            return this;
        }

        public final Instant getWarningUpdatedTime() {
            return warningUpdatedTime;
        }

        public final void setWarningUpdatedTime(Instant warningUpdatedTime) {
            this.warningUpdatedTime = warningUpdatedTime;
        }

        @Override
        public final Builder warningUpdatedTime(Instant warningUpdatedTime) {
            this.warningUpdatedTime = warningUpdatedTime;
            return this;
        }

        public final String getWarningMessage() {
            return warningMessage;
        }

        public final void setWarningMessage(String warningMessage) {
            this.warningMessage = warningMessage;
        }

        @Override
        public final Builder warningMessage(String warningMessage) {
            this.warningMessage = warningMessage;
            return this;
        }

        @Override
        public ResourceWarning build() {
            return new ResourceWarning(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
