/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a Region switch plan. A plan defines the steps required to shift traffic from one Amazon Web Services
 * Region to another.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Plan implements SdkPojo, Serializable, ToCopyableBuilder<Plan.Builder, Plan> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Plan::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Plan::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<Workflow>> WORKFLOWS_FIELD = SdkField
            .<List<Workflow>> builder(MarshallingType.LIST)
            .memberName("workflows")
            .getter(getter(Plan::workflows))
            .setter(setter(Builder::workflows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Workflow> builder(MarshallingType.SDK_POJO)
                                            .constructor(Workflow::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRole").getter(getter(Plan::executionRole)).setter(setter(Builder::executionRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRole").build()).build();

    private static final SdkField<Integer> RECOVERY_TIME_OBJECTIVE_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("recoveryTimeObjectiveMinutes")
            .getter(getter(Plan::recoveryTimeObjectiveMinutes))
            .setter(setter(Builder::recoveryTimeObjectiveMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryTimeObjectiveMinutes")
                    .build()).build();

    private static final SdkField<Map<String, AssociatedAlarm>> ASSOCIATED_ALARMS_FIELD = SdkField
            .<Map<String, AssociatedAlarm>> builder(MarshallingType.MAP)
            .memberName("associatedAlarms")
            .getter(getter(Plan::associatedAlarms))
            .setter(setter(Builder::associatedAlarms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedAlarms").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AssociatedAlarm> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssociatedAlarm::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<Trigger>> TRIGGERS_FIELD = SdkField
            .<List<Trigger>> builder(MarshallingType.LIST)
            .memberName("triggers")
            .getter(getter(Plan::triggers))
            .setter(setter(Builder::triggers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Trigger> builder(MarshallingType.SDK_POJO)
                                            .constructor(Trigger::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Plan::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<String>> REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("regions")
            .getter(getter(Plan::regions))
            .setter(setter(Builder::regions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RECOVERY_APPROACH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recoveryApproach").getter(getter(Plan::recoveryApproachAsString))
            .setter(setter(Builder::recoveryApproach))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryApproach").build()).build();

    private static final SdkField<String> PRIMARY_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("primaryRegion").getter(getter(Plan::primaryRegion)).setter(setter(Builder::primaryRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primaryRegion").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("owner")
            .getter(getter(Plan::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(Plan::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(Plan::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DESCRIPTION_FIELD,
            WORKFLOWS_FIELD, EXECUTION_ROLE_FIELD, RECOVERY_TIME_OBJECTIVE_MINUTES_FIELD, ASSOCIATED_ALARMS_FIELD,
            TRIGGERS_FIELD, NAME_FIELD, REGIONS_FIELD, RECOVERY_APPROACH_FIELD, PRIMARY_REGION_FIELD, OWNER_FIELD, VERSION_FIELD,
            UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String description;

    private final List<Workflow> workflows;

    private final String executionRole;

    private final Integer recoveryTimeObjectiveMinutes;

    private final Map<String, AssociatedAlarm> associatedAlarms;

    private final List<Trigger> triggers;

    private final String name;

    private final List<String> regions;

    private final String recoveryApproach;

    private final String primaryRegion;

    private final String owner;

    private final String version;

    private final Instant updatedAt;

    private Plan(BuilderImpl builder) {
        this.arn = builder.arn;
        this.description = builder.description;
        this.workflows = builder.workflows;
        this.executionRole = builder.executionRole;
        this.recoveryTimeObjectiveMinutes = builder.recoveryTimeObjectiveMinutes;
        this.associatedAlarms = builder.associatedAlarms;
        this.triggers = builder.triggers;
        this.name = builder.name;
        this.regions = builder.regions;
        this.recoveryApproach = builder.recoveryApproach;
        this.primaryRegion = builder.primaryRegion;
        this.owner = builder.owner;
        this.version = builder.version;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the plan.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the plan.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The description for a plan.
     * </p>
     * 
     * @return The description for a plan.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Workflows property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWorkflows() {
        return workflows != null && !(workflows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The workflows for a plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkflows} method.
     * </p>
     * 
     * @return The workflows for a plan.
     */
    public final List<Workflow> workflows() {
        return workflows;
    }

    /**
     * <p>
     * The execution role for a plan.
     * </p>
     * 
     * @return The execution role for a plan.
     */
    public final String executionRole() {
        return executionRole;
    }

    /**
     * <p>
     * The recovery time objective for a plan.
     * </p>
     * 
     * @return The recovery time objective for a plan.
     */
    public final Integer recoveryTimeObjectiveMinutes() {
        return recoveryTimeObjectiveMinutes;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedAlarms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociatedAlarms() {
        return associatedAlarms != null && !(associatedAlarms instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The associated application health alarms for a plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedAlarms} method.
     * </p>
     * 
     * @return The associated application health alarms for a plan.
     */
    public final Map<String, AssociatedAlarm> associatedAlarms() {
        return associatedAlarms;
    }

    /**
     * For responses, this returns true if the service returned a value for the Triggers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTriggers() {
        return triggers != null && !(triggers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The triggers for a plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTriggers} method.
     * </p>
     * 
     * @return The triggers for a plan.
     */
    public final List<Trigger> triggers() {
        return triggers;
    }

    /**
     * <p>
     * The name for a plan.
     * </p>
     * 
     * @return The name for a plan.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Regions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRegions() {
        return regions != null && !(regions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services Regions for a plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegions} method.
     * </p>
     * 
     * @return The Amazon Web Services Regions for a plan.
     */
    public final List<String> regions() {
        return regions;
    }

    /**
     * <p>
     * The recovery approach for a Region switch plan, which can be active/active (activeActive) or active/passive
     * (activePassive).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recoveryApproach}
     * will return {@link RecoveryApproach#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #recoveryApproachAsString}.
     * </p>
     * 
     * @return The recovery approach for a Region switch plan, which can be active/active (activeActive) or
     *         active/passive (activePassive).
     * @see RecoveryApproach
     */
    public final RecoveryApproach recoveryApproach() {
        return RecoveryApproach.fromValue(recoveryApproach);
    }

    /**
     * <p>
     * The recovery approach for a Region switch plan, which can be active/active (activeActive) or active/passive
     * (activePassive).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recoveryApproach}
     * will return {@link RecoveryApproach#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #recoveryApproachAsString}.
     * </p>
     * 
     * @return The recovery approach for a Region switch plan, which can be active/active (activeActive) or
     *         active/passive (activePassive).
     * @see RecoveryApproach
     */
    public final String recoveryApproachAsString() {
        return recoveryApproach;
    }

    /**
     * <p>
     * The primary Region for a plan.
     * </p>
     * 
     * @return The primary Region for a plan.
     */
    public final String primaryRegion() {
        return primaryRegion;
    }

    /**
     * <p>
     * The owner of a plan.
     * </p>
     * 
     * @return The owner of a plan.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * The version for the plan.
     * </p>
     * 
     * @return The version for the plan.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The timestamp when the plan was last updated.
     * </p>
     * 
     * @return The timestamp when the plan was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkflows() ? workflows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryTimeObjectiveMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedAlarms() ? associatedAlarms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTriggers() ? triggers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegions() ? regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(recoveryApproachAsString());
        hashCode = 31 * hashCode + Objects.hashCode(primaryRegion());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Plan)) {
            return false;
        }
        Plan other = (Plan) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(description(), other.description())
                && hasWorkflows() == other.hasWorkflows() && Objects.equals(workflows(), other.workflows())
                && Objects.equals(executionRole(), other.executionRole())
                && Objects.equals(recoveryTimeObjectiveMinutes(), other.recoveryTimeObjectiveMinutes())
                && hasAssociatedAlarms() == other.hasAssociatedAlarms()
                && Objects.equals(associatedAlarms(), other.associatedAlarms()) && hasTriggers() == other.hasTriggers()
                && Objects.equals(triggers(), other.triggers()) && Objects.equals(name(), other.name())
                && hasRegions() == other.hasRegions() && Objects.equals(regions(), other.regions())
                && Objects.equals(recoveryApproachAsString(), other.recoveryApproachAsString())
                && Objects.equals(primaryRegion(), other.primaryRegion()) && Objects.equals(owner(), other.owner())
                && Objects.equals(version(), other.version()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Plan").add("Arn", arn()).add("Description", description())
                .add("Workflows", hasWorkflows() ? workflows() : null).add("ExecutionRole", executionRole())
                .add("RecoveryTimeObjectiveMinutes", recoveryTimeObjectiveMinutes())
                .add("AssociatedAlarms", hasAssociatedAlarms() ? associatedAlarms() : null)
                .add("Triggers", hasTriggers() ? triggers() : null).add("Name", name())
                .add("Regions", hasRegions() ? regions() : null).add("RecoveryApproach", recoveryApproachAsString())
                .add("PrimaryRegion", primaryRegion()).add("Owner", owner()).add("Version", version())
                .add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "workflows":
            return Optional.ofNullable(clazz.cast(workflows()));
        case "executionRole":
            return Optional.ofNullable(clazz.cast(executionRole()));
        case "recoveryTimeObjectiveMinutes":
            return Optional.ofNullable(clazz.cast(recoveryTimeObjectiveMinutes()));
        case "associatedAlarms":
            return Optional.ofNullable(clazz.cast(associatedAlarms()));
        case "triggers":
            return Optional.ofNullable(clazz.cast(triggers()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "regions":
            return Optional.ofNullable(clazz.cast(regions()));
        case "recoveryApproach":
            return Optional.ofNullable(clazz.cast(recoveryApproachAsString()));
        case "primaryRegion":
            return Optional.ofNullable(clazz.cast(primaryRegion()));
        case "owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("workflows", WORKFLOWS_FIELD);
        map.put("executionRole", EXECUTION_ROLE_FIELD);
        map.put("recoveryTimeObjectiveMinutes", RECOVERY_TIME_OBJECTIVE_MINUTES_FIELD);
        map.put("associatedAlarms", ASSOCIATED_ALARMS_FIELD);
        map.put("triggers", TRIGGERS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("regions", REGIONS_FIELD);
        map.put("recoveryApproach", RECOVERY_APPROACH_FIELD);
        map.put("primaryRegion", PRIMARY_REGION_FIELD);
        map.put("owner", OWNER_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Plan, T> g) {
        return obj -> g.apply((Plan) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Plan> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the plan.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The description for a plan.
         * </p>
         * 
         * @param description
         *        The description for a plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The workflows for a plan.
         * </p>
         * 
         * @param workflows
         *        The workflows for a plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflows(Collection<Workflow> workflows);

        /**
         * <p>
         * The workflows for a plan.
         * </p>
         * 
         * @param workflows
         *        The workflows for a plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflows(Workflow... workflows);

        /**
         * <p>
         * The workflows for a plan.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.arcregionswitch.model.Workflow.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.arcregionswitch.model.Workflow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.arcregionswitch.model.Workflow.Builder#build()} is called immediately
         * and its result is passed to {@link #workflows(List<Workflow>)}.
         * 
         * @param workflows
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.arcregionswitch.model.Workflow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflows(java.util.Collection<Workflow>)
         */
        Builder workflows(Consumer<Workflow.Builder>... workflows);

        /**
         * <p>
         * The execution role for a plan.
         * </p>
         * 
         * @param executionRole
         *        The execution role for a plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRole(String executionRole);

        /**
         * <p>
         * The recovery time objective for a plan.
         * </p>
         * 
         * @param recoveryTimeObjectiveMinutes
         *        The recovery time objective for a plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryTimeObjectiveMinutes(Integer recoveryTimeObjectiveMinutes);

        /**
         * <p>
         * The associated application health alarms for a plan.
         * </p>
         * 
         * @param associatedAlarms
         *        The associated application health alarms for a plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedAlarms(Map<String, AssociatedAlarm> associatedAlarms);

        /**
         * <p>
         * The triggers for a plan.
         * </p>
         * 
         * @param triggers
         *        The triggers for a plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggers(Collection<Trigger> triggers);

        /**
         * <p>
         * The triggers for a plan.
         * </p>
         * 
         * @param triggers
         *        The triggers for a plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggers(Trigger... triggers);

        /**
         * <p>
         * The triggers for a plan.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.arcregionswitch.model.Trigger.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.arcregionswitch.model.Trigger#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.arcregionswitch.model.Trigger.Builder#build()} is called immediately
         * and its result is passed to {@link #triggers(List<Trigger>)}.
         * 
         * @param triggers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.arcregionswitch.model.Trigger.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #triggers(java.util.Collection<Trigger>)
         */
        Builder triggers(Consumer<Trigger.Builder>... triggers);

        /**
         * <p>
         * The name for a plan.
         * </p>
         * 
         * @param name
         *        The name for a plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Web Services Regions for a plan.
         * </p>
         * 
         * @param regions
         *        The Amazon Web Services Regions for a plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Collection<String> regions);

        /**
         * <p>
         * The Amazon Web Services Regions for a plan.
         * </p>
         * 
         * @param regions
         *        The Amazon Web Services Regions for a plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(String... regions);

        /**
         * <p>
         * The recovery approach for a Region switch plan, which can be active/active (activeActive) or active/passive
         * (activePassive).
         * </p>
         * 
         * @param recoveryApproach
         *        The recovery approach for a Region switch plan, which can be active/active (activeActive) or
         *        active/passive (activePassive).
         * @see RecoveryApproach
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecoveryApproach
         */
        Builder recoveryApproach(String recoveryApproach);

        /**
         * <p>
         * The recovery approach for a Region switch plan, which can be active/active (activeActive) or active/passive
         * (activePassive).
         * </p>
         * 
         * @param recoveryApproach
         *        The recovery approach for a Region switch plan, which can be active/active (activeActive) or
         *        active/passive (activePassive).
         * @see RecoveryApproach
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecoveryApproach
         */
        Builder recoveryApproach(RecoveryApproach recoveryApproach);

        /**
         * <p>
         * The primary Region for a plan.
         * </p>
         * 
         * @param primaryRegion
         *        The primary Region for a plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryRegion(String primaryRegion);

        /**
         * <p>
         * The owner of a plan.
         * </p>
         * 
         * @param owner
         *        The owner of a plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The version for the plan.
         * </p>
         * 
         * @param version
         *        The version for the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The timestamp when the plan was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the plan was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String description;

        private List<Workflow> workflows = DefaultSdkAutoConstructList.getInstance();

        private String executionRole;

        private Integer recoveryTimeObjectiveMinutes;

        private Map<String, AssociatedAlarm> associatedAlarms = DefaultSdkAutoConstructMap.getInstance();

        private List<Trigger> triggers = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private String recoveryApproach;

        private String primaryRegion;

        private String owner;

        private String version;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Plan model) {
            arn(model.arn);
            description(model.description);
            workflows(model.workflows);
            executionRole(model.executionRole);
            recoveryTimeObjectiveMinutes(model.recoveryTimeObjectiveMinutes);
            associatedAlarms(model.associatedAlarms);
            triggers(model.triggers);
            name(model.name);
            regions(model.regions);
            recoveryApproach(model.recoveryApproach);
            primaryRegion(model.primaryRegion);
            owner(model.owner);
            version(model.version);
            updatedAt(model.updatedAt);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Workflow.Builder> getWorkflows() {
            List<Workflow.Builder> result = WorkflowListCopier.copyToBuilder(this.workflows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkflows(Collection<Workflow.BuilderImpl> workflows) {
            this.workflows = WorkflowListCopier.copyFromBuilder(workflows);
        }

        @Override
        public final Builder workflows(Collection<Workflow> workflows) {
            this.workflows = WorkflowListCopier.copy(workflows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflows(Workflow... workflows) {
            workflows(Arrays.asList(workflows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflows(Consumer<Workflow.Builder>... workflows) {
            workflows(Stream.of(workflows).map(c -> Workflow.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getExecutionRole() {
            return executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final Integer getRecoveryTimeObjectiveMinutes() {
            return recoveryTimeObjectiveMinutes;
        }

        public final void setRecoveryTimeObjectiveMinutes(Integer recoveryTimeObjectiveMinutes) {
            this.recoveryTimeObjectiveMinutes = recoveryTimeObjectiveMinutes;
        }

        @Override
        public final Builder recoveryTimeObjectiveMinutes(Integer recoveryTimeObjectiveMinutes) {
            this.recoveryTimeObjectiveMinutes = recoveryTimeObjectiveMinutes;
            return this;
        }

        public final Map<String, AssociatedAlarm.Builder> getAssociatedAlarms() {
            Map<String, AssociatedAlarm.Builder> result = AssociatedAlarmMapCopier.copyToBuilder(this.associatedAlarms);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAssociatedAlarms(Map<String, AssociatedAlarm.BuilderImpl> associatedAlarms) {
            this.associatedAlarms = AssociatedAlarmMapCopier.copyFromBuilder(associatedAlarms);
        }

        @Override
        public final Builder associatedAlarms(Map<String, AssociatedAlarm> associatedAlarms) {
            this.associatedAlarms = AssociatedAlarmMapCopier.copy(associatedAlarms);
            return this;
        }

        public final List<Trigger.Builder> getTriggers() {
            List<Trigger.Builder> result = TriggerListCopier.copyToBuilder(this.triggers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTriggers(Collection<Trigger.BuilderImpl> triggers) {
            this.triggers = TriggerListCopier.copyFromBuilder(triggers);
        }

        @Override
        public final Builder triggers(Collection<Trigger> triggers) {
            this.triggers = TriggerListCopier.copy(triggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(Trigger... triggers) {
            triggers(Arrays.asList(triggers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(Consumer<Trigger.Builder>... triggers) {
            triggers(Stream.of(triggers).map(c -> Trigger.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getRegions() {
            if (regions instanceof SdkAutoConstructList) {
                return null;
            }
            return regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String... regions) {
            regions(Arrays.asList(regions));
            return this;
        }

        public final String getRecoveryApproach() {
            return recoveryApproach;
        }

        public final void setRecoveryApproach(String recoveryApproach) {
            this.recoveryApproach = recoveryApproach;
        }

        @Override
        public final Builder recoveryApproach(String recoveryApproach) {
            this.recoveryApproach = recoveryApproach;
            return this;
        }

        @Override
        public final Builder recoveryApproach(RecoveryApproach recoveryApproach) {
            this.recoveryApproach(recoveryApproach == null ? null : recoveryApproach.toString());
            return this;
        }

        public final String getPrimaryRegion() {
            return primaryRegion;
        }

        public final void setPrimaryRegion(String primaryRegion) {
            this.primaryRegion = primaryRegion;
        }

        @Override
        public final Builder primaryRegion(String primaryRegion) {
            this.primaryRegion = primaryRegion;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public Plan build() {
            return new Plan(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
