/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * Amazon Application Recovery Controller (ARC) Region switch helps you to quickly and reliably shift traffic away from
 * an impaired Amazon Web Services Region to a healthy Region. With Region switch, you can create plans that define the
 * steps to shift traffic for your application from one Amazon Web Services Region to another. You can test your plans
 * in practice mode before using them in a real recovery scenario.
 * </p>
 * <p>
 * Region switch provides a structured approach to multi-Region failover, helping you to meet your recovery time
 * objectives (RTOs) and maintain business continuity during regional disruptions.
 * </p>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/region-switch.html">Region
 * switch in ARC</a> in the <i>Amazon Application Recovery Controller User Guide</i>.
 * </p>
 */
package software.amazon.awssdk.services.arcregionswitch;