/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a step in a Region switch plan workflow. Each step performs a specific action during the Region switch
 * process.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Step implements SdkPojo, Serializable, ToCopyableBuilder<Step.Builder, Step> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Step::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Step::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<ExecutionBlockConfiguration> EXECUTION_BLOCK_CONFIGURATION_FIELD = SdkField
            .<ExecutionBlockConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("executionBlockConfiguration")
            .getter(getter(Step::executionBlockConfiguration))
            .setter(setter(Builder::executionBlockConfiguration))
            .constructor(ExecutionBlockConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionBlockConfiguration")
                    .build()).build();

    private static final SdkField<String> EXECUTION_BLOCK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionBlockType").getter(getter(Step::executionBlockTypeAsString))
            .setter(setter(Builder::executionBlockType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionBlockType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            EXECUTION_BLOCK_CONFIGURATION_FIELD, EXECUTION_BLOCK_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final ExecutionBlockConfiguration executionBlockConfiguration;

    private final String executionBlockType;

    private Step(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.executionBlockConfiguration = builder.executionBlockConfiguration;
        this.executionBlockType = builder.executionBlockType;
    }

    /**
     * <p>
     * The name of a step in a workflow.
     * </p>
     * 
     * @return The name of a step in a workflow.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of a step in a workflow.
     * </p>
     * 
     * @return The description of a step in a workflow.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The configuration for an execution block in a workflow.
     * </p>
     * 
     * @return The configuration for an execution block in a workflow.
     */
    public final ExecutionBlockConfiguration executionBlockConfiguration() {
        return executionBlockConfiguration;
    }

    /**
     * <p>
     * The type of an execution block in a workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #executionBlockType} will return {@link ExecutionBlockType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #executionBlockTypeAsString}.
     * </p>
     * 
     * @return The type of an execution block in a workflow.
     * @see ExecutionBlockType
     */
    public final ExecutionBlockType executionBlockType() {
        return ExecutionBlockType.fromValue(executionBlockType);
    }

    /**
     * <p>
     * The type of an execution block in a workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #executionBlockType} will return {@link ExecutionBlockType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #executionBlockTypeAsString}.
     * </p>
     * 
     * @return The type of an execution block in a workflow.
     * @see ExecutionBlockType
     */
    public final String executionBlockTypeAsString() {
        return executionBlockType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(executionBlockConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(executionBlockTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Step)) {
            return false;
        }
        Step other = (Step) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(executionBlockConfiguration(), other.executionBlockConfiguration())
                && Objects.equals(executionBlockTypeAsString(), other.executionBlockTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Step").add("Name", name()).add("Description", description())
                .add("ExecutionBlockConfiguration", executionBlockConfiguration())
                .add("ExecutionBlockType", executionBlockTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "executionBlockConfiguration":
            return Optional.ofNullable(clazz.cast(executionBlockConfiguration()));
        case "executionBlockType":
            return Optional.ofNullable(clazz.cast(executionBlockTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("executionBlockConfiguration", EXECUTION_BLOCK_CONFIGURATION_FIELD);
        map.put("executionBlockType", EXECUTION_BLOCK_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Step, T> g) {
        return obj -> g.apply((Step) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Step> {
        /**
         * <p>
         * The name of a step in a workflow.
         * </p>
         * 
         * @param name
         *        The name of a step in a workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of a step in a workflow.
         * </p>
         * 
         * @param description
         *        The description of a step in a workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The configuration for an execution block in a workflow.
         * </p>
         * 
         * @param executionBlockConfiguration
         *        The configuration for an execution block in a workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionBlockConfiguration(ExecutionBlockConfiguration executionBlockConfiguration);

        /**
         * <p>
         * The configuration for an execution block in a workflow.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecutionBlockConfiguration.Builder}
         * avoiding the need to create one manually via {@link ExecutionBlockConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecutionBlockConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #executionBlockConfiguration(ExecutionBlockConfiguration)}.
         * 
         * @param executionBlockConfiguration
         *        a consumer that will call methods on {@link ExecutionBlockConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionBlockConfiguration(ExecutionBlockConfiguration)
         */
        default Builder executionBlockConfiguration(Consumer<ExecutionBlockConfiguration.Builder> executionBlockConfiguration) {
            return executionBlockConfiguration(ExecutionBlockConfiguration.builder().applyMutation(executionBlockConfiguration)
                    .build());
        }

        /**
         * <p>
         * The type of an execution block in a workflow.
         * </p>
         * 
         * @param executionBlockType
         *        The type of an execution block in a workflow.
         * @see ExecutionBlockType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionBlockType
         */
        Builder executionBlockType(String executionBlockType);

        /**
         * <p>
         * The type of an execution block in a workflow.
         * </p>
         * 
         * @param executionBlockType
         *        The type of an execution block in a workflow.
         * @see ExecutionBlockType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionBlockType
         */
        Builder executionBlockType(ExecutionBlockType executionBlockType);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private ExecutionBlockConfiguration executionBlockConfiguration;

        private String executionBlockType;

        private BuilderImpl() {
        }

        private BuilderImpl(Step model) {
            name(model.name);
            description(model.description);
            executionBlockConfiguration(model.executionBlockConfiguration);
            executionBlockType(model.executionBlockType);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ExecutionBlockConfiguration.Builder getExecutionBlockConfiguration() {
            return executionBlockConfiguration != null ? executionBlockConfiguration.toBuilder() : null;
        }

        public final void setExecutionBlockConfiguration(ExecutionBlockConfiguration.BuilderImpl executionBlockConfiguration) {
            this.executionBlockConfiguration = executionBlockConfiguration != null ? executionBlockConfiguration.build() : null;
        }

        @Override
        public final Builder executionBlockConfiguration(ExecutionBlockConfiguration executionBlockConfiguration) {
            this.executionBlockConfiguration = executionBlockConfiguration;
            return this;
        }

        public final String getExecutionBlockType() {
            return executionBlockType;
        }

        public final void setExecutionBlockType(String executionBlockType) {
            this.executionBlockType = executionBlockType;
        }

        @Override
        public final Builder executionBlockType(String executionBlockType) {
            this.executionBlockType = executionBlockType;
            return this;
        }

        @Override
        public final Builder executionBlockType(ExecutionBlockType executionBlockType) {
            this.executionBlockType(executionBlockType == null ? null : executionBlockType.toString());
            return this;
        }

        @Override
        public Step build() {
            return new Step(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
