/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class LambdaListCopier {
    static List<Lambdas> copy(Collection<? extends Lambdas> lambdaListParam) {
        List<Lambdas> list;
        if (lambdaListParam == null || lambdaListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Lambdas> modifiableList = new ArrayList<>(lambdaListParam.size());
            lambdaListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Lambdas> copyFromBuilder(Collection<? extends Lambdas.Builder> lambdaListParam) {
        List<Lambdas> list;
        if (lambdaListParam == null || lambdaListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Lambdas> modifiableList = new ArrayList<>(lambdaListParam.size());
            lambdaListParam.forEach(entry -> {
                Lambdas member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Lambdas.Builder> copyToBuilder(Collection<? extends Lambdas> lambdaListParam) {
        List<Lambdas.Builder> list;
        if (lambdaListParam == null || lambdaListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Lambdas.Builder> modifiableList = new ArrayList<>(lambdaListParam.size());
            lambdaListParam.forEach(entry -> {
                Lambdas.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
