/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ExecutionEventType {
    UNKNOWN("unknown"),

    EXECUTION_PENDING("executionPending"),

    EXECUTION_STARTED("executionStarted"),

    EXECUTION_SUCCEEDED("executionSucceeded"),

    EXECUTION_FAILED("executionFailed"),

    EXECUTION_PAUSING("executionPausing"),

    EXECUTION_PAUSED("executionPaused"),

    EXECUTION_CANCELING("executionCanceling"),

    EXECUTION_CANCELED("executionCanceled"),

    EXECUTION_PENDING_APPROVAL("executionPendingApproval"),

    EXECUTION_BEHAVIOR_CHANGED_TO_UNGRACEFUL("executionBehaviorChangedToUngraceful"),

    EXECUTION_BEHAVIOR_CHANGED_TO_GRACEFUL("executionBehaviorChangedToGraceful"),

    EXECUTION_PENDING_CHILD_PLAN_MANUAL_APPROVAL("executionPendingChildPlanManualApproval"),

    EXECUTION_SUCCESS_MONITORING_APPLICATION_HEALTH("executionSuccessMonitoringApplicationHealth"),

    STEP_STARTED("stepStarted"),

    STEP_UPDATE("stepUpdate"),

    STEP_SUCCEEDED("stepSucceeded"),

    STEP_FAILED("stepFailed"),

    STEP_SKIPPED("stepSkipped"),

    STEP_PAUSED_BY_ERROR("stepPausedByError"),

    STEP_PAUSED_BY_OPERATOR("stepPausedByOperator"),

    STEP_CANCELED("stepCanceled"),

    STEP_PENDING_APPROVAL("stepPendingApproval"),

    STEP_EXECUTION_BEHAVIOR_CHANGED_TO_UNGRACEFUL("stepExecutionBehaviorChangedToUngraceful"),

    STEP_PENDING_APPLICATION_HEALTH_MONITOR("stepPendingApplicationHealthMonitor"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExecutionEventType> VALUE_MAP = EnumUtils.uniqueIndex(ExecutionEventType.class,
            ExecutionEventType::toString);

    private final String value;

    private ExecutionEventType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ExecutionEventType corresponding to the value
     */
    public static ExecutionEventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ExecutionEventType}s
     */
    public static Set<ExecutionEventType> knownValues() {
        Set<ExecutionEventType> knownValues = EnumSet.allOf(ExecutionEventType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
