/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for Amazon Web Services Lambda functions that perform custom actions during a Region switch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomActionLambdaConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomActionLambdaConfiguration.Builder, CustomActionLambdaConfiguration> {
    private static final SdkField<Integer> TIMEOUT_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("timeoutMinutes").getter(getter(CustomActionLambdaConfiguration::timeoutMinutes))
            .setter(setter(Builder::timeoutMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutMinutes").build()).build();

    private static final SdkField<List<Lambdas>> LAMBDAS_FIELD = SdkField
            .<List<Lambdas>> builder(MarshallingType.LIST)
            .memberName("lambdas")
            .getter(getter(CustomActionLambdaConfiguration::lambdas))
            .setter(setter(Builder::lambdas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Lambdas> builder(MarshallingType.SDK_POJO)
                                            .constructor(Lambdas::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Float> RETRY_INTERVAL_MINUTES_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("retryIntervalMinutes").getter(getter(CustomActionLambdaConfiguration::retryIntervalMinutes))
            .setter(setter(Builder::retryIntervalMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryIntervalMinutes").build())
            .build();

    private static final SdkField<String> REGION_TO_RUN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("regionToRun").getter(getter(CustomActionLambdaConfiguration::regionToRunAsString))
            .setter(setter(Builder::regionToRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionToRun").build()).build();

    private static final SdkField<LambdaUngraceful> UNGRACEFUL_FIELD = SdkField
            .<LambdaUngraceful> builder(MarshallingType.SDK_POJO).memberName("ungraceful")
            .getter(getter(CustomActionLambdaConfiguration::ungraceful)).setter(setter(Builder::ungraceful))
            .constructor(LambdaUngraceful::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ungraceful").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEOUT_MINUTES_FIELD,
            LAMBDAS_FIELD, RETRY_INTERVAL_MINUTES_FIELD, REGION_TO_RUN_FIELD, UNGRACEFUL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer timeoutMinutes;

    private final List<Lambdas> lambdas;

    private final Float retryIntervalMinutes;

    private final String regionToRun;

    private final LambdaUngraceful ungraceful;

    private CustomActionLambdaConfiguration(BuilderImpl builder) {
        this.timeoutMinutes = builder.timeoutMinutes;
        this.lambdas = builder.lambdas;
        this.retryIntervalMinutes = builder.retryIntervalMinutes;
        this.regionToRun = builder.regionToRun;
        this.ungraceful = builder.ungraceful;
    }

    /**
     * <p>
     * The timeout value specified for the configuration.
     * </p>
     * 
     * @return The timeout value specified for the configuration.
     */
    public final Integer timeoutMinutes() {
        return timeoutMinutes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Lambdas property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLambdas() {
        return lambdas != null && !(lambdas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services Lambda functions for the execution block.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLambdas} method.
     * </p>
     * 
     * @return The Amazon Web Services Lambda functions for the execution block.
     */
    public final List<Lambdas> lambdas() {
        return lambdas;
    }

    /**
     * <p>
     * The retry interval specified.
     * </p>
     * 
     * @return The retry interval specified.
     */
    public final Float retryIntervalMinutes() {
        return retryIntervalMinutes;
    }

    /**
     * <p>
     * The Amazon Web Services Region for the function to run in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #regionToRun} will
     * return {@link RegionToRunIn#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #regionToRunAsString}.
     * </p>
     * 
     * @return The Amazon Web Services Region for the function to run in.
     * @see RegionToRunIn
     */
    public final RegionToRunIn regionToRun() {
        return RegionToRunIn.fromValue(regionToRun);
    }

    /**
     * <p>
     * The Amazon Web Services Region for the function to run in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #regionToRun} will
     * return {@link RegionToRunIn#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #regionToRunAsString}.
     * </p>
     * 
     * @return The Amazon Web Services Region for the function to run in.
     * @see RegionToRunIn
     */
    public final String regionToRunAsString() {
        return regionToRun;
    }

    /**
     * <p>
     * The settings for ungraceful execution.
     * </p>
     * 
     * @return The settings for ungraceful execution.
     */
    public final LambdaUngraceful ungraceful() {
        return ungraceful;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(hasLambdas() ? lambdas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(retryIntervalMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(regionToRunAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ungraceful());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomActionLambdaConfiguration)) {
            return false;
        }
        CustomActionLambdaConfiguration other = (CustomActionLambdaConfiguration) obj;
        return Objects.equals(timeoutMinutes(), other.timeoutMinutes()) && hasLambdas() == other.hasLambdas()
                && Objects.equals(lambdas(), other.lambdas())
                && Objects.equals(retryIntervalMinutes(), other.retryIntervalMinutes())
                && Objects.equals(regionToRunAsString(), other.regionToRunAsString())
                && Objects.equals(ungraceful(), other.ungraceful());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomActionLambdaConfiguration").add("TimeoutMinutes", timeoutMinutes())
                .add("Lambdas", hasLambdas() ? lambdas() : null).add("RetryIntervalMinutes", retryIntervalMinutes())
                .add("RegionToRun", regionToRunAsString()).add("Ungraceful", ungraceful()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timeoutMinutes":
            return Optional.ofNullable(clazz.cast(timeoutMinutes()));
        case "lambdas":
            return Optional.ofNullable(clazz.cast(lambdas()));
        case "retryIntervalMinutes":
            return Optional.ofNullable(clazz.cast(retryIntervalMinutes()));
        case "regionToRun":
            return Optional.ofNullable(clazz.cast(regionToRunAsString()));
        case "ungraceful":
            return Optional.ofNullable(clazz.cast(ungraceful()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("timeoutMinutes", TIMEOUT_MINUTES_FIELD);
        map.put("lambdas", LAMBDAS_FIELD);
        map.put("retryIntervalMinutes", RETRY_INTERVAL_MINUTES_FIELD);
        map.put("regionToRun", REGION_TO_RUN_FIELD);
        map.put("ungraceful", UNGRACEFUL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomActionLambdaConfiguration, T> g) {
        return obj -> g.apply((CustomActionLambdaConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomActionLambdaConfiguration> {
        /**
         * <p>
         * The timeout value specified for the configuration.
         * </p>
         * 
         * @param timeoutMinutes
         *        The timeout value specified for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutMinutes(Integer timeoutMinutes);

        /**
         * <p>
         * The Amazon Web Services Lambda functions for the execution block.
         * </p>
         * 
         * @param lambdas
         *        The Amazon Web Services Lambda functions for the execution block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdas(Collection<Lambdas> lambdas);

        /**
         * <p>
         * The Amazon Web Services Lambda functions for the execution block.
         * </p>
         * 
         * @param lambdas
         *        The Amazon Web Services Lambda functions for the execution block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdas(Lambdas... lambdas);

        /**
         * <p>
         * The Amazon Web Services Lambda functions for the execution block.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.arcregionswitch.model.Lambdas.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.arcregionswitch.model.Lambdas#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.arcregionswitch.model.Lambdas.Builder#build()} is called immediately
         * and its result is passed to {@link #lambdas(List<Lambdas>)}.
         * 
         * @param lambdas
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.arcregionswitch.model.Lambdas.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdas(java.util.Collection<Lambdas>)
         */
        Builder lambdas(Consumer<Lambdas.Builder>... lambdas);

        /**
         * <p>
         * The retry interval specified.
         * </p>
         * 
         * @param retryIntervalMinutes
         *        The retry interval specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryIntervalMinutes(Float retryIntervalMinutes);

        /**
         * <p>
         * The Amazon Web Services Region for the function to run in.
         * </p>
         * 
         * @param regionToRun
         *        The Amazon Web Services Region for the function to run in.
         * @see RegionToRunIn
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegionToRunIn
         */
        Builder regionToRun(String regionToRun);

        /**
         * <p>
         * The Amazon Web Services Region for the function to run in.
         * </p>
         * 
         * @param regionToRun
         *        The Amazon Web Services Region for the function to run in.
         * @see RegionToRunIn
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegionToRunIn
         */
        Builder regionToRun(RegionToRunIn regionToRun);

        /**
         * <p>
         * The settings for ungraceful execution.
         * </p>
         * 
         * @param ungraceful
         *        The settings for ungraceful execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ungraceful(LambdaUngraceful ungraceful);

        /**
         * <p>
         * The settings for ungraceful execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link LambdaUngraceful.Builder} avoiding the
         * need to create one manually via {@link LambdaUngraceful#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaUngraceful.Builder#build()} is called immediately and its
         * result is passed to {@link #ungraceful(LambdaUngraceful)}.
         * 
         * @param ungraceful
         *        a consumer that will call methods on {@link LambdaUngraceful.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ungraceful(LambdaUngraceful)
         */
        default Builder ungraceful(Consumer<LambdaUngraceful.Builder> ungraceful) {
            return ungraceful(LambdaUngraceful.builder().applyMutation(ungraceful).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer timeoutMinutes;

        private List<Lambdas> lambdas = DefaultSdkAutoConstructList.getInstance();

        private Float retryIntervalMinutes;

        private String regionToRun;

        private LambdaUngraceful ungraceful;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomActionLambdaConfiguration model) {
            timeoutMinutes(model.timeoutMinutes);
            lambdas(model.lambdas);
            retryIntervalMinutes(model.retryIntervalMinutes);
            regionToRun(model.regionToRun);
            ungraceful(model.ungraceful);
        }

        public final Integer getTimeoutMinutes() {
            return timeoutMinutes;
        }

        public final void setTimeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
        }

        @Override
        public final Builder timeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
            return this;
        }

        public final List<Lambdas.Builder> getLambdas() {
            List<Lambdas.Builder> result = LambdaListCopier.copyToBuilder(this.lambdas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLambdas(Collection<Lambdas.BuilderImpl> lambdas) {
            this.lambdas = LambdaListCopier.copyFromBuilder(lambdas);
        }

        @Override
        public final Builder lambdas(Collection<Lambdas> lambdas) {
            this.lambdas = LambdaListCopier.copy(lambdas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdas(Lambdas... lambdas) {
            lambdas(Arrays.asList(lambdas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdas(Consumer<Lambdas.Builder>... lambdas) {
            lambdas(Stream.of(lambdas).map(c -> Lambdas.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Float getRetryIntervalMinutes() {
            return retryIntervalMinutes;
        }

        public final void setRetryIntervalMinutes(Float retryIntervalMinutes) {
            this.retryIntervalMinutes = retryIntervalMinutes;
        }

        @Override
        public final Builder retryIntervalMinutes(Float retryIntervalMinutes) {
            this.retryIntervalMinutes = retryIntervalMinutes;
            return this;
        }

        public final String getRegionToRun() {
            return regionToRun;
        }

        public final void setRegionToRun(String regionToRun) {
            this.regionToRun = regionToRun;
        }

        @Override
        public final Builder regionToRun(String regionToRun) {
            this.regionToRun = regionToRun;
            return this;
        }

        @Override
        public final Builder regionToRun(RegionToRunIn regionToRun) {
            this.regionToRun(regionToRun == null ? null : regionToRun.toString());
            return this;
        }

        public final LambdaUngraceful.Builder getUngraceful() {
            return ungraceful != null ? ungraceful.toBuilder() : null;
        }

        public final void setUngraceful(LambdaUngraceful.BuilderImpl ungraceful) {
            this.ungraceful = ungraceful != null ? ungraceful.build() : null;
        }

        @Override
        public final Builder ungraceful(LambdaUngraceful ungraceful) {
            this.ungraceful = ungraceful;
            return this;
        }

        @Override
        public CustomActionLambdaConfiguration build() {
            return new CustomActionLambdaConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
