/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Amazon CloudWatch alarm associated with a Region switch plan. These alarms can be used to trigger automatic
 * execution of the plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociatedAlarm implements SdkPojo, Serializable, ToCopyableBuilder<AssociatedAlarm.Builder, AssociatedAlarm> {
    private static final SdkField<String> CROSS_ACCOUNT_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("crossAccountRole").getter(getter(AssociatedAlarm::crossAccountRole))
            .setter(setter(Builder::crossAccountRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crossAccountRole").build()).build();

    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalId").getter(getter(AssociatedAlarm::externalId)).setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()).build();

    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceIdentifier").getter(getter(AssociatedAlarm::resourceIdentifier))
            .setter(setter(Builder::resourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIdentifier").build())
            .build();

    private static final SdkField<String> ALARM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("alarmType").getter(getter(AssociatedAlarm::alarmTypeAsString)).setter(setter(Builder::alarmType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CROSS_ACCOUNT_ROLE_FIELD,
            EXTERNAL_ID_FIELD, RESOURCE_IDENTIFIER_FIELD, ALARM_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String crossAccountRole;

    private final String externalId;

    private final String resourceIdentifier;

    private final String alarmType;

    private AssociatedAlarm(BuilderImpl builder) {
        this.crossAccountRole = builder.crossAccountRole;
        this.externalId = builder.externalId;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.alarmType = builder.alarmType;
    }

    /**
     * <p>
     * The cross account role for the configuration.
     * </p>
     * 
     * @return The cross account role for the configuration.
     */
    public final String crossAccountRole() {
        return crossAccountRole;
    }

    /**
     * <p>
     * The external ID (secret key) for the configuration.
     * </p>
     * 
     * @return The external ID (secret key) for the configuration.
     */
    public final String externalId() {
        return externalId;
    }

    /**
     * <p>
     * The resource identifier for alarms that you associate with a plan.
     * </p>
     * 
     * @return The resource identifier for alarms that you associate with a plan.
     */
    public final String resourceIdentifier() {
        return resourceIdentifier;
    }

    /**
     * <p>
     * The alarm type for an associated alarm. An associated CloudWatch alarm can be an application health alarm or a
     * trigger alarm.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #alarmType} will
     * return {@link AlarmType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #alarmTypeAsString}.
     * </p>
     * 
     * @return The alarm type for an associated alarm. An associated CloudWatch alarm can be an application health alarm
     *         or a trigger alarm.
     * @see AlarmType
     */
    public final AlarmType alarmType() {
        return AlarmType.fromValue(alarmType);
    }

    /**
     * <p>
     * The alarm type for an associated alarm. An associated CloudWatch alarm can be an application health alarm or a
     * trigger alarm.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #alarmType} will
     * return {@link AlarmType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #alarmTypeAsString}.
     * </p>
     * 
     * @return The alarm type for an associated alarm. An associated CloudWatch alarm can be an application health alarm
     *         or a trigger alarm.
     * @see AlarmType
     */
    public final String alarmTypeAsString() {
        return alarmType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(crossAccountRole());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(alarmTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatedAlarm)) {
            return false;
        }
        AssociatedAlarm other = (AssociatedAlarm) obj;
        return Objects.equals(crossAccountRole(), other.crossAccountRole()) && Objects.equals(externalId(), other.externalId())
                && Objects.equals(resourceIdentifier(), other.resourceIdentifier())
                && Objects.equals(alarmTypeAsString(), other.alarmTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociatedAlarm").add("CrossAccountRole", crossAccountRole()).add("ExternalId", externalId())
                .add("ResourceIdentifier", resourceIdentifier()).add("AlarmType", alarmTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "crossAccountRole":
            return Optional.ofNullable(clazz.cast(crossAccountRole()));
        case "externalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        case "resourceIdentifier":
            return Optional.ofNullable(clazz.cast(resourceIdentifier()));
        case "alarmType":
            return Optional.ofNullable(clazz.cast(alarmTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("crossAccountRole", CROSS_ACCOUNT_ROLE_FIELD);
        map.put("externalId", EXTERNAL_ID_FIELD);
        map.put("resourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
        map.put("alarmType", ALARM_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociatedAlarm, T> g) {
        return obj -> g.apply((AssociatedAlarm) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssociatedAlarm> {
        /**
         * <p>
         * The cross account role for the configuration.
         * </p>
         * 
         * @param crossAccountRole
         *        The cross account role for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossAccountRole(String crossAccountRole);

        /**
         * <p>
         * The external ID (secret key) for the configuration.
         * </p>
         * 
         * @param externalId
         *        The external ID (secret key) for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);

        /**
         * <p>
         * The resource identifier for alarms that you associate with a plan.
         * </p>
         * 
         * @param resourceIdentifier
         *        The resource identifier for alarms that you associate with a plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(String resourceIdentifier);

        /**
         * <p>
         * The alarm type for an associated alarm. An associated CloudWatch alarm can be an application health alarm or
         * a trigger alarm.
         * </p>
         * 
         * @param alarmType
         *        The alarm type for an associated alarm. An associated CloudWatch alarm can be an application health
         *        alarm or a trigger alarm.
         * @see AlarmType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlarmType
         */
        Builder alarmType(String alarmType);

        /**
         * <p>
         * The alarm type for an associated alarm. An associated CloudWatch alarm can be an application health alarm or
         * a trigger alarm.
         * </p>
         * 
         * @param alarmType
         *        The alarm type for an associated alarm. An associated CloudWatch alarm can be an application health
         *        alarm or a trigger alarm.
         * @see AlarmType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlarmType
         */
        Builder alarmType(AlarmType alarmType);
    }

    static final class BuilderImpl implements Builder {
        private String crossAccountRole;

        private String externalId;

        private String resourceIdentifier;

        private String alarmType;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatedAlarm model) {
            crossAccountRole(model.crossAccountRole);
            externalId(model.externalId);
            resourceIdentifier(model.resourceIdentifier);
            alarmType(model.alarmType);
        }

        public final String getCrossAccountRole() {
            return crossAccountRole;
        }

        public final void setCrossAccountRole(String crossAccountRole) {
            this.crossAccountRole = crossAccountRole;
        }

        @Override
        public final Builder crossAccountRole(String crossAccountRole) {
            this.crossAccountRole = crossAccountRole;
            return this;
        }

        public final String getExternalId() {
            return externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final String getResourceIdentifier() {
            return resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final String getAlarmType() {
            return alarmType;
        }

        public final void setAlarmType(String alarmType) {
            this.alarmType = alarmType;
        }

        @Override
        public final Builder alarmType(String alarmType) {
            this.alarmType = alarmType;
            return this;
        }

        @Override
        public final Builder alarmType(AlarmType alarmType) {
            this.alarmType(alarmType == null ? null : alarmType.toString());
            return this;
        }

        @Override
        public AssociatedAlarm build() {
            return new AssociatedAlarm(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
