/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.arcregionswitch.model.LambdaListCopier;
import software.amazon.awssdk.services.arcregionswitch.model.LambdaUngraceful;
import software.amazon.awssdk.services.arcregionswitch.model.Lambdas;
import software.amazon.awssdk.services.arcregionswitch.model.RegionToRunIn;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomActionLambdaConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomActionLambdaConfiguration> {
    private static final SdkField<Integer> TIMEOUT_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("timeoutMinutes").getter(CustomActionLambdaConfiguration.getter(CustomActionLambdaConfiguration::timeoutMinutes)).setter(CustomActionLambdaConfiguration.setter(Builder::timeoutMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutMinutes").build()}).build();
    private static final SdkField<List<Lambdas>> LAMBDAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("lambdas").getter(CustomActionLambdaConfiguration.getter(CustomActionLambdaConfiguration::lambdas)).setter(CustomActionLambdaConfiguration.setter(Builder::lambdas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Lambdas::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Float> RETRY_INTERVAL_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("retryIntervalMinutes").getter(CustomActionLambdaConfiguration.getter(CustomActionLambdaConfiguration::retryIntervalMinutes)).setter(CustomActionLambdaConfiguration.setter(Builder::retryIntervalMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryIntervalMinutes").build()}).build();
    private static final SdkField<String> REGION_TO_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("regionToRun").getter(CustomActionLambdaConfiguration.getter(CustomActionLambdaConfiguration::regionToRunAsString)).setter(CustomActionLambdaConfiguration.setter(Builder::regionToRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionToRun").build()}).build();
    private static final SdkField<LambdaUngraceful> UNGRACEFUL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ungraceful").getter(CustomActionLambdaConfiguration.getter(CustomActionLambdaConfiguration::ungraceful)).setter(CustomActionLambdaConfiguration.setter(Builder::ungraceful)).constructor(LambdaUngraceful::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ungraceful").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEOUT_MINUTES_FIELD, LAMBDAS_FIELD, RETRY_INTERVAL_MINUTES_FIELD, REGION_TO_RUN_FIELD, UNGRACEFUL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomActionLambdaConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer timeoutMinutes;
    private final List<Lambdas> lambdas;
    private final Float retryIntervalMinutes;
    private final String regionToRun;
    private final LambdaUngraceful ungraceful;

    private CustomActionLambdaConfiguration(BuilderImpl builder) {
        this.timeoutMinutes = builder.timeoutMinutes;
        this.lambdas = builder.lambdas;
        this.retryIntervalMinutes = builder.retryIntervalMinutes;
        this.regionToRun = builder.regionToRun;
        this.ungraceful = builder.ungraceful;
    }

    public final Integer timeoutMinutes() {
        return this.timeoutMinutes;
    }

    public final boolean hasLambdas() {
        return this.lambdas != null && !(this.lambdas instanceof SdkAutoConstructList);
    }

    public final List<Lambdas> lambdas() {
        return this.lambdas;
    }

    public final Float retryIntervalMinutes() {
        return this.retryIntervalMinutes;
    }

    public final RegionToRunIn regionToRun() {
        return RegionToRunIn.fromValue(this.regionToRun);
    }

    public final String regionToRunAsString() {
        return this.regionToRun;
    }

    public final LambdaUngraceful ungraceful() {
        return this.ungraceful;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLambdas() ? this.lambdas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.retryIntervalMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionToRunAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ungraceful());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomActionLambdaConfiguration)) {
            return false;
        }
        CustomActionLambdaConfiguration other = (CustomActionLambdaConfiguration)obj;
        return Objects.equals(this.timeoutMinutes(), other.timeoutMinutes()) && this.hasLambdas() == other.hasLambdas() && Objects.equals(this.lambdas(), other.lambdas()) && Objects.equals(this.retryIntervalMinutes(), other.retryIntervalMinutes()) && Objects.equals(this.regionToRunAsString(), other.regionToRunAsString()) && Objects.equals(this.ungraceful(), other.ungraceful());
    }

    public final String toString() {
        return ToString.builder((String)"CustomActionLambdaConfiguration").add("TimeoutMinutes", (Object)this.timeoutMinutes()).add("Lambdas", this.hasLambdas() ? this.lambdas() : null).add("RetryIntervalMinutes", (Object)this.retryIntervalMinutes()).add("RegionToRun", (Object)this.regionToRunAsString()).add("Ungraceful", (Object)this.ungraceful()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "timeoutMinutes": {
                return Optional.ofNullable(clazz.cast(this.timeoutMinutes()));
            }
            case "lambdas": {
                return Optional.ofNullable(clazz.cast(this.lambdas()));
            }
            case "retryIntervalMinutes": {
                return Optional.ofNullable(clazz.cast(this.retryIntervalMinutes()));
            }
            case "regionToRun": {
                return Optional.ofNullable(clazz.cast(this.regionToRunAsString()));
            }
            case "ungraceful": {
                return Optional.ofNullable(clazz.cast(this.ungraceful()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("timeoutMinutes", TIMEOUT_MINUTES_FIELD);
        map.put("lambdas", LAMBDAS_FIELD);
        map.put("retryIntervalMinutes", RETRY_INTERVAL_MINUTES_FIELD);
        map.put("regionToRun", REGION_TO_RUN_FIELD);
        map.put("ungraceful", UNGRACEFUL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomActionLambdaConfiguration, T> g) {
        return obj -> g.apply((CustomActionLambdaConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer timeoutMinutes;
        private List<Lambdas> lambdas = DefaultSdkAutoConstructList.getInstance();
        private Float retryIntervalMinutes;
        private String regionToRun;
        private LambdaUngraceful ungraceful;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomActionLambdaConfiguration model) {
            this.timeoutMinutes(model.timeoutMinutes);
            this.lambdas(model.lambdas);
            this.retryIntervalMinutes(model.retryIntervalMinutes);
            this.regionToRun(model.regionToRun);
            this.ungraceful(model.ungraceful);
        }

        public final Integer getTimeoutMinutes() {
            return this.timeoutMinutes;
        }

        public final void setTimeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
        }

        @Override
        public final Builder timeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
            return this;
        }

        public final List<Lambdas.Builder> getLambdas() {
            List<Lambdas.Builder> result = LambdaListCopier.copyToBuilder(this.lambdas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLambdas(Collection<Lambdas.BuilderImpl> lambdas) {
            this.lambdas = LambdaListCopier.copyFromBuilder(lambdas);
        }

        @Override
        public final Builder lambdas(Collection<Lambdas> lambdas) {
            this.lambdas = LambdaListCopier.copy(lambdas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdas(Lambdas ... lambdas) {
            this.lambdas(Arrays.asList(lambdas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdas(Consumer<Lambdas.Builder> ... lambdas) {
            this.lambdas(Stream.of(lambdas).map(c -> (Lambdas)((Lambdas.Builder)Lambdas.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Float getRetryIntervalMinutes() {
            return this.retryIntervalMinutes;
        }

        public final void setRetryIntervalMinutes(Float retryIntervalMinutes) {
            this.retryIntervalMinutes = retryIntervalMinutes;
        }

        @Override
        public final Builder retryIntervalMinutes(Float retryIntervalMinutes) {
            this.retryIntervalMinutes = retryIntervalMinutes;
            return this;
        }

        public final String getRegionToRun() {
            return this.regionToRun;
        }

        public final void setRegionToRun(String regionToRun) {
            this.regionToRun = regionToRun;
        }

        @Override
        public final Builder regionToRun(String regionToRun) {
            this.regionToRun = regionToRun;
            return this;
        }

        @Override
        public final Builder regionToRun(RegionToRunIn regionToRun) {
            this.regionToRun(regionToRun == null ? null : regionToRun.toString());
            return this;
        }

        public final LambdaUngraceful.Builder getUngraceful() {
            return this.ungraceful != null ? this.ungraceful.toBuilder() : null;
        }

        public final void setUngraceful(LambdaUngraceful.BuilderImpl ungraceful) {
            this.ungraceful = ungraceful != null ? ungraceful.build() : null;
        }

        @Override
        public final Builder ungraceful(LambdaUngraceful ungraceful) {
            this.ungraceful = ungraceful;
            return this;
        }

        public CustomActionLambdaConfiguration build() {
            return new CustomActionLambdaConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomActionLambdaConfiguration> {
        public Builder timeoutMinutes(Integer var1);

        public Builder lambdas(Collection<Lambdas> var1);

        public Builder lambdas(Lambdas ... var1);

        public Builder lambdas(Consumer<Lambdas.Builder> ... var1);

        public Builder retryIntervalMinutes(Float var1);

        public Builder regionToRun(String var1);

        public Builder regionToRun(RegionToRunIn var1);

        public Builder ungraceful(LambdaUngraceful var1);

        default public Builder ungraceful(Consumer<LambdaUngraceful.Builder> ungraceful) {
            return this.ungraceful((LambdaUngraceful)((LambdaUngraceful.Builder)LambdaUngraceful.builder().applyMutation(ungraceful)).build());
        }
    }
}

