/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.arcregionswitch.model.ExecutionBlockConfiguration;
import software.amazon.awssdk.services.arcregionswitch.model.ExecutionBlockType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Step
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Step> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Step.getter(Step::name)).setter(Step.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Step.getter(Step::description)).setter(Step.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<ExecutionBlockConfiguration> EXECUTION_BLOCK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("executionBlockConfiguration").getter(Step.getter(Step::executionBlockConfiguration)).setter(Step.setter(Builder::executionBlockConfiguration)).constructor(ExecutionBlockConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionBlockConfiguration").build()}).build();
    private static final SdkField<String> EXECUTION_BLOCK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionBlockType").getter(Step.getter(Step::executionBlockTypeAsString)).setter(Step.setter(Builder::executionBlockType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionBlockType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, EXECUTION_BLOCK_CONFIGURATION_FIELD, EXECUTION_BLOCK_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Step.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final ExecutionBlockConfiguration executionBlockConfiguration;
    private final String executionBlockType;

    private Step(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.executionBlockConfiguration = builder.executionBlockConfiguration;
        this.executionBlockType = builder.executionBlockType;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final ExecutionBlockConfiguration executionBlockConfiguration() {
        return this.executionBlockConfiguration;
    }

    public final ExecutionBlockType executionBlockType() {
        return ExecutionBlockType.fromValue(this.executionBlockType);
    }

    public final String executionBlockTypeAsString() {
        return this.executionBlockType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionBlockConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionBlockTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Step)) {
            return false;
        }
        Step other = (Step)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.executionBlockConfiguration(), other.executionBlockConfiguration()) && Objects.equals(this.executionBlockTypeAsString(), other.executionBlockTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Step").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("ExecutionBlockConfiguration", (Object)this.executionBlockConfiguration()).add("ExecutionBlockType", (Object)this.executionBlockTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "executionBlockConfiguration": {
                return Optional.ofNullable(clazz.cast(this.executionBlockConfiguration()));
            }
            case "executionBlockType": {
                return Optional.ofNullable(clazz.cast(this.executionBlockTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("executionBlockConfiguration", EXECUTION_BLOCK_CONFIGURATION_FIELD);
        map.put("executionBlockType", EXECUTION_BLOCK_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Step, T> g) {
        return obj -> g.apply((Step)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private ExecutionBlockConfiguration executionBlockConfiguration;
        private String executionBlockType;

        private BuilderImpl() {
        }

        private BuilderImpl(Step model) {
            this.name(model.name);
            this.description(model.description);
            this.executionBlockConfiguration(model.executionBlockConfiguration);
            this.executionBlockType(model.executionBlockType);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ExecutionBlockConfiguration.Builder getExecutionBlockConfiguration() {
            return this.executionBlockConfiguration != null ? this.executionBlockConfiguration.toBuilder() : null;
        }

        public final void setExecutionBlockConfiguration(ExecutionBlockConfiguration.BuilderImpl executionBlockConfiguration) {
            this.executionBlockConfiguration = executionBlockConfiguration != null ? executionBlockConfiguration.build() : null;
        }

        @Override
        public final Builder executionBlockConfiguration(ExecutionBlockConfiguration executionBlockConfiguration) {
            this.executionBlockConfiguration = executionBlockConfiguration;
            return this;
        }

        public final String getExecutionBlockType() {
            return this.executionBlockType;
        }

        public final void setExecutionBlockType(String executionBlockType) {
            this.executionBlockType = executionBlockType;
        }

        @Override
        public final Builder executionBlockType(String executionBlockType) {
            this.executionBlockType = executionBlockType;
            return this;
        }

        @Override
        public final Builder executionBlockType(ExecutionBlockType executionBlockType) {
            this.executionBlockType(executionBlockType == null ? null : executionBlockType.toString());
            return this;
        }

        public Step build() {
            return new Step(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Step> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder executionBlockConfiguration(ExecutionBlockConfiguration var1);

        default public Builder executionBlockConfiguration(Consumer<ExecutionBlockConfiguration.Builder> executionBlockConfiguration) {
            return this.executionBlockConfiguration((ExecutionBlockConfiguration)((ExecutionBlockConfiguration.Builder)ExecutionBlockConfiguration.builder().applyMutation(executionBlockConfiguration)).build());
        }

        public Builder executionBlockType(String var1);

        public Builder executionBlockType(ExecutionBlockType var1);
    }
}

