/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.arcregionswitch.ArcRegionSwitchClient;
import software.amazon.awssdk.services.arcregionswitch.internal.UserAgentUtils;
import software.amazon.awssdk.services.arcregionswitch.model.ListRoute53HealthChecksRequest;
import software.amazon.awssdk.services.arcregionswitch.model.ListRoute53HealthChecksResponse;
import software.amazon.awssdk.services.arcregionswitch.model.Route53HealthCheck;

public class ListRoute53HealthChecksIterable
implements SdkIterable<ListRoute53HealthChecksResponse> {
    private final ArcRegionSwitchClient client;
    private final ListRoute53HealthChecksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRoute53HealthChecksIterable(ArcRegionSwitchClient client, ListRoute53HealthChecksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRoute53HealthChecksResponseFetcher();
    }

    public Iterator<ListRoute53HealthChecksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Route53HealthCheck> healthChecks() {
        Function<ListRoute53HealthChecksResponse, Iterator> getIterator = response -> {
            if (response != null && response.healthChecks() != null) {
                return response.healthChecks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRoute53HealthChecksResponseFetcher
    implements SyncPageFetcher<ListRoute53HealthChecksResponse> {
        private ListRoute53HealthChecksResponseFetcher() {
        }

        public boolean hasNextPage(ListRoute53HealthChecksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRoute53HealthChecksResponse nextPage(ListRoute53HealthChecksResponse previousPage) {
            if (previousPage == null) {
                return ListRoute53HealthChecksIterable.this.client.listRoute53HealthChecks(ListRoute53HealthChecksIterable.this.firstRequest);
            }
            return ListRoute53HealthChecksIterable.this.client.listRoute53HealthChecks((ListRoute53HealthChecksRequest)((Object)ListRoute53HealthChecksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

