/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.arcregionswitch.ArcRegionSwitchClient;
import software.amazon.awssdk.services.arcregionswitch.internal.UserAgentUtils;
import software.amazon.awssdk.services.arcregionswitch.model.AbbreviatedExecution;
import software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionsRequest;
import software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionsResponse;

public class ListPlanExecutionsIterable
implements SdkIterable<ListPlanExecutionsResponse> {
    private final ArcRegionSwitchClient client;
    private final ListPlanExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPlanExecutionsIterable(ArcRegionSwitchClient client, ListPlanExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPlanExecutionsResponseFetcher();
    }

    public Iterator<ListPlanExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AbbreviatedExecution> items() {
        Function<ListPlanExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPlanExecutionsResponseFetcher
    implements SyncPageFetcher<ListPlanExecutionsResponse> {
        private ListPlanExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListPlanExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPlanExecutionsResponse nextPage(ListPlanExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListPlanExecutionsIterable.this.client.listPlanExecutions(ListPlanExecutionsIterable.this.firstRequest);
            }
            return ListPlanExecutionsIterable.this.client.listPlanExecutions((ListPlanExecutionsRequest)((Object)ListPlanExecutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

