/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.arcregionswitch.ArcRegionSwitchAsyncClient;
import software.amazon.awssdk.services.arcregionswitch.internal.UserAgentUtils;
import software.amazon.awssdk.services.arcregionswitch.model.GetPlanExecutionRequest;
import software.amazon.awssdk.services.arcregionswitch.model.GetPlanExecutionResponse;
import software.amazon.awssdk.services.arcregionswitch.model.StepState;

public class GetPlanExecutionPublisher
implements SdkPublisher<GetPlanExecutionResponse> {
    private final ArcRegionSwitchAsyncClient client;
    private final GetPlanExecutionRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetPlanExecutionPublisher(ArcRegionSwitchAsyncClient client, GetPlanExecutionRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetPlanExecutionPublisher(ArcRegionSwitchAsyncClient client, GetPlanExecutionRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetPlanExecutionResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetPlanExecutionResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StepState> stepStates() {
        Function<GetPlanExecutionResponse, Iterator> getIterator = response -> {
            if (response != null && response.stepStates() != null) {
                return response.stepStates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetPlanExecutionResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetPlanExecutionResponseFetcher
    implements AsyncPageFetcher<GetPlanExecutionResponse> {
        private GetPlanExecutionResponseFetcher() {
        }

        public boolean hasNextPage(GetPlanExecutionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetPlanExecutionResponse> nextPage(GetPlanExecutionResponse previousPage) {
            if (previousPage == null) {
                return GetPlanExecutionPublisher.this.client.getPlanExecution(GetPlanExecutionPublisher.this.firstRequest);
            }
            return GetPlanExecutionPublisher.this.client.getPlanExecution((GetPlanExecutionRequest)((Object)GetPlanExecutionPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

