/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.arcregionswitch.ArcRegionSwitchAsyncClient;
import software.amazon.awssdk.services.arcregionswitch.internal.UserAgentUtils;
import software.amazon.awssdk.services.arcregionswitch.model.GetPlanEvaluationStatusRequest;
import software.amazon.awssdk.services.arcregionswitch.model.GetPlanEvaluationStatusResponse;
import software.amazon.awssdk.services.arcregionswitch.model.ResourceWarning;

public class GetPlanEvaluationStatusPublisher
implements SdkPublisher<GetPlanEvaluationStatusResponse> {
    private final ArcRegionSwitchAsyncClient client;
    private final GetPlanEvaluationStatusRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetPlanEvaluationStatusPublisher(ArcRegionSwitchAsyncClient client, GetPlanEvaluationStatusRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetPlanEvaluationStatusPublisher(ArcRegionSwitchAsyncClient client, GetPlanEvaluationStatusRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetPlanEvaluationStatusResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetPlanEvaluationStatusResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResourceWarning> warnings() {
        Function<GetPlanEvaluationStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.warnings() != null) {
                return response.warnings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetPlanEvaluationStatusResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetPlanEvaluationStatusResponseFetcher
    implements AsyncPageFetcher<GetPlanEvaluationStatusResponse> {
        private GetPlanEvaluationStatusResponseFetcher() {
        }

        public boolean hasNextPage(GetPlanEvaluationStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetPlanEvaluationStatusResponse> nextPage(GetPlanEvaluationStatusResponse previousPage) {
            if (previousPage == null) {
                return GetPlanEvaluationStatusPublisher.this.client.getPlanEvaluationStatus(GetPlanEvaluationStatusPublisher.this.firstRequest);
            }
            return GetPlanEvaluationStatusPublisher.this.client.getPlanEvaluationStatus((GetPlanEvaluationStatusRequest)((Object)GetPlanEvaluationStatusPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

