/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.arcregionswitch.model.ArcRegionSwitchRequest;
import software.amazon.awssdk.services.arcregionswitch.model.UpdatePlanExecutionStepAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePlanExecutionStepRequest
extends ArcRegionSwitchRequest
implements ToCopyableBuilder<Builder, UpdatePlanExecutionStepRequest> {
    private static final SdkField<String> PLAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("planArn").getter(UpdatePlanExecutionStepRequest.getter(UpdatePlanExecutionStepRequest::planArn)).setter(UpdatePlanExecutionStepRequest.setter(Builder::planArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("planArn").build()}).build();
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionId").getter(UpdatePlanExecutionStepRequest.getter(UpdatePlanExecutionStepRequest::executionId)).setter(UpdatePlanExecutionStepRequest.setter(Builder::executionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("comment").getter(UpdatePlanExecutionStepRequest.getter(UpdatePlanExecutionStepRequest::comment)).setter(UpdatePlanExecutionStepRequest.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()}).build();
    private static final SdkField<String> STEP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stepName").getter(UpdatePlanExecutionStepRequest.getter(UpdatePlanExecutionStepRequest::stepName)).setter(UpdatePlanExecutionStepRequest.setter(Builder::stepName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepName").build()}).build();
    private static final SdkField<String> ACTION_TO_TAKE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionToTake").getter(UpdatePlanExecutionStepRequest.getter(UpdatePlanExecutionStepRequest::actionToTakeAsString)).setter(UpdatePlanExecutionStepRequest.setter(Builder::actionToTake)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionToTake").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAN_ARN_FIELD, EXECUTION_ID_FIELD, COMMENT_FIELD, STEP_NAME_FIELD, ACTION_TO_TAKE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdatePlanExecutionStepRequest.memberNameToFieldInitializer();
    private final String planArn;
    private final String executionId;
    private final String comment;
    private final String stepName;
    private final String actionToTake;

    private UpdatePlanExecutionStepRequest(BuilderImpl builder) {
        super(builder);
        this.planArn = builder.planArn;
        this.executionId = builder.executionId;
        this.comment = builder.comment;
        this.stepName = builder.stepName;
        this.actionToTake = builder.actionToTake;
    }

    public final String planArn() {
        return this.planArn;
    }

    public final String executionId() {
        return this.executionId;
    }

    public final String comment() {
        return this.comment;
    }

    public final String stepName() {
        return this.stepName;
    }

    public final UpdatePlanExecutionStepAction actionToTake() {
        return UpdatePlanExecutionStepAction.fromValue(this.actionToTake);
    }

    public final String actionToTakeAsString() {
        return this.actionToTake;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.planArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepName());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionToTakeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePlanExecutionStepRequest)) {
            return false;
        }
        UpdatePlanExecutionStepRequest other = (UpdatePlanExecutionStepRequest)((Object)obj);
        return Objects.equals(this.planArn(), other.planArn()) && Objects.equals(this.executionId(), other.executionId()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.stepName(), other.stepName()) && Objects.equals(this.actionToTakeAsString(), other.actionToTakeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePlanExecutionStepRequest").add("PlanArn", (Object)this.planArn()).add("ExecutionId", (Object)this.executionId()).add("Comment", (Object)this.comment()).add("StepName", (Object)this.stepName()).add("ActionToTake", (Object)this.actionToTakeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "planArn": {
                return Optional.ofNullable(clazz.cast(this.planArn()));
            }
            case "executionId": {
                return Optional.ofNullable(clazz.cast(this.executionId()));
            }
            case "comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "stepName": {
                return Optional.ofNullable(clazz.cast(this.stepName()));
            }
            case "actionToTake": {
                return Optional.ofNullable(clazz.cast(this.actionToTakeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("planArn", PLAN_ARN_FIELD);
        map.put("executionId", EXECUTION_ID_FIELD);
        map.put("comment", COMMENT_FIELD);
        map.put("stepName", STEP_NAME_FIELD);
        map.put("actionToTake", ACTION_TO_TAKE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePlanExecutionStepRequest, T> g) {
        return obj -> g.apply((UpdatePlanExecutionStepRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ArcRegionSwitchRequest.BuilderImpl
    implements Builder {
        private String planArn;
        private String executionId;
        private String comment;
        private String stepName;
        private String actionToTake;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePlanExecutionStepRequest model) {
            super(model);
            this.planArn(model.planArn);
            this.executionId(model.executionId);
            this.comment(model.comment);
            this.stepName(model.stepName);
            this.actionToTake(model.actionToTake);
        }

        public final String getPlanArn() {
            return this.planArn;
        }

        public final void setPlanArn(String planArn) {
            this.planArn = planArn;
        }

        @Override
        public final Builder planArn(String planArn) {
            this.planArn = planArn;
            return this;
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getStepName() {
            return this.stepName;
        }

        public final void setStepName(String stepName) {
            this.stepName = stepName;
        }

        @Override
        public final Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public final String getActionToTake() {
            return this.actionToTake;
        }

        public final void setActionToTake(String actionToTake) {
            this.actionToTake = actionToTake;
        }

        @Override
        public final Builder actionToTake(String actionToTake) {
            this.actionToTake = actionToTake;
            return this;
        }

        @Override
        public final Builder actionToTake(UpdatePlanExecutionStepAction actionToTake) {
            this.actionToTake(actionToTake == null ? null : actionToTake.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePlanExecutionStepRequest build() {
            return new UpdatePlanExecutionStepRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ArcRegionSwitchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePlanExecutionStepRequest> {
        public Builder planArn(String var1);

        public Builder executionId(String var1);

        public Builder comment(String var1);

        public Builder stepName(String var1);

        public Builder actionToTake(String var1);

        public Builder actionToTake(UpdatePlanExecutionStepAction var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

