/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.arcregionswitch.model.ArcRegionSwitchRequest;
import software.amazon.awssdk.services.arcregionswitch.model.AssociatedAlarm;
import software.amazon.awssdk.services.arcregionswitch.model.AssociatedAlarmMapCopier;
import software.amazon.awssdk.services.arcregionswitch.model.RecoveryApproach;
import software.amazon.awssdk.services.arcregionswitch.model.RegionListCopier;
import software.amazon.awssdk.services.arcregionswitch.model.TagsCopier;
import software.amazon.awssdk.services.arcregionswitch.model.Trigger;
import software.amazon.awssdk.services.arcregionswitch.model.TriggerListCopier;
import software.amazon.awssdk.services.arcregionswitch.model.Workflow;
import software.amazon.awssdk.services.arcregionswitch.model.WorkflowListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePlanRequest
extends ArcRegionSwitchRequest
implements ToCopyableBuilder<Builder, CreatePlanRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreatePlanRequest.getter(CreatePlanRequest::description)).setter(CreatePlanRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<Workflow>> WORKFLOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("workflows").getter(CreatePlanRequest.getter(CreatePlanRequest::workflows)).setter(CreatePlanRequest.setter(Builder::workflows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Workflow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRole").getter(CreatePlanRequest.getter(CreatePlanRequest::executionRole)).setter(CreatePlanRequest.setter(Builder::executionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRole").build()}).build();
    private static final SdkField<Integer> RECOVERY_TIME_OBJECTIVE_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("recoveryTimeObjectiveMinutes").getter(CreatePlanRequest.getter(CreatePlanRequest::recoveryTimeObjectiveMinutes)).setter(CreatePlanRequest.setter(Builder::recoveryTimeObjectiveMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryTimeObjectiveMinutes").build()}).build();
    private static final SdkField<Map<String, AssociatedAlarm>> ASSOCIATED_ALARMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("associatedAlarms").getter(CreatePlanRequest.getter(CreatePlanRequest::associatedAlarms)).setter(CreatePlanRequest.setter(Builder::associatedAlarms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedAlarms").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociatedAlarm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<Trigger>> TRIGGERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("triggers").getter(CreatePlanRequest.getter(CreatePlanRequest::triggers)).setter(CreatePlanRequest.setter(Builder::triggers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Trigger::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreatePlanRequest.getter(CreatePlanRequest::name)).setter(CreatePlanRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<String>> REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("regions").getter(CreatePlanRequest.getter(CreatePlanRequest::regions)).setter(CreatePlanRequest.setter(Builder::regions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RECOVERY_APPROACH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recoveryApproach").getter(CreatePlanRequest.getter(CreatePlanRequest::recoveryApproachAsString)).setter(CreatePlanRequest.setter(Builder::recoveryApproach)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryApproach").build()}).build();
    private static final SdkField<String> PRIMARY_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("primaryRegion").getter(CreatePlanRequest.getter(CreatePlanRequest::primaryRegion)).setter(CreatePlanRequest.setter(Builder::primaryRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primaryRegion").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreatePlanRequest.getter(CreatePlanRequest::tags)).setter(CreatePlanRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, WORKFLOWS_FIELD, EXECUTION_ROLE_FIELD, RECOVERY_TIME_OBJECTIVE_MINUTES_FIELD, ASSOCIATED_ALARMS_FIELD, TRIGGERS_FIELD, NAME_FIELD, REGIONS_FIELD, RECOVERY_APPROACH_FIELD, PRIMARY_REGION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreatePlanRequest.memberNameToFieldInitializer();
    private final String description;
    private final List<Workflow> workflows;
    private final String executionRole;
    private final Integer recoveryTimeObjectiveMinutes;
    private final Map<String, AssociatedAlarm> associatedAlarms;
    private final List<Trigger> triggers;
    private final String name;
    private final List<String> regions;
    private final String recoveryApproach;
    private final String primaryRegion;
    private final Map<String, String> tags;

    private CreatePlanRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.workflows = builder.workflows;
        this.executionRole = builder.executionRole;
        this.recoveryTimeObjectiveMinutes = builder.recoveryTimeObjectiveMinutes;
        this.associatedAlarms = builder.associatedAlarms;
        this.triggers = builder.triggers;
        this.name = builder.name;
        this.regions = builder.regions;
        this.recoveryApproach = builder.recoveryApproach;
        this.primaryRegion = builder.primaryRegion;
        this.tags = builder.tags;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasWorkflows() {
        return this.workflows != null && !(this.workflows instanceof SdkAutoConstructList);
    }

    public final List<Workflow> workflows() {
        return this.workflows;
    }

    public final String executionRole() {
        return this.executionRole;
    }

    public final Integer recoveryTimeObjectiveMinutes() {
        return this.recoveryTimeObjectiveMinutes;
    }

    public final boolean hasAssociatedAlarms() {
        return this.associatedAlarms != null && !(this.associatedAlarms instanceof SdkAutoConstructMap);
    }

    public final Map<String, AssociatedAlarm> associatedAlarms() {
        return this.associatedAlarms;
    }

    public final boolean hasTriggers() {
        return this.triggers != null && !(this.triggers instanceof SdkAutoConstructList);
    }

    public final List<Trigger> triggers() {
        return this.triggers;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasRegions() {
        return this.regions != null && !(this.regions instanceof SdkAutoConstructList);
    }

    public final List<String> regions() {
        return this.regions;
    }

    public final RecoveryApproach recoveryApproach() {
        return RecoveryApproach.fromValue(this.recoveryApproach);
    }

    public final String recoveryApproachAsString() {
        return this.recoveryApproach;
    }

    public final String primaryRegion() {
        return this.primaryRegion;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkflows() ? this.workflows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryTimeObjectiveMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedAlarms() ? this.associatedAlarms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTriggers() ? this.triggers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegions() ? this.regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryApproachAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlanRequest)) {
            return false;
        }
        CreatePlanRequest other = (CreatePlanRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && this.hasWorkflows() == other.hasWorkflows() && Objects.equals(this.workflows(), other.workflows()) && Objects.equals(this.executionRole(), other.executionRole()) && Objects.equals(this.recoveryTimeObjectiveMinutes(), other.recoveryTimeObjectiveMinutes()) && this.hasAssociatedAlarms() == other.hasAssociatedAlarms() && Objects.equals(this.associatedAlarms(), other.associatedAlarms()) && this.hasTriggers() == other.hasTriggers() && Objects.equals(this.triggers(), other.triggers()) && Objects.equals(this.name(), other.name()) && this.hasRegions() == other.hasRegions() && Objects.equals(this.regions(), other.regions()) && Objects.equals(this.recoveryApproachAsString(), other.recoveryApproachAsString()) && Objects.equals(this.primaryRegion(), other.primaryRegion()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePlanRequest").add("Description", (Object)this.description()).add("Workflows", this.hasWorkflows() ? this.workflows() : null).add("ExecutionRole", (Object)this.executionRole()).add("RecoveryTimeObjectiveMinutes", (Object)this.recoveryTimeObjectiveMinutes()).add("AssociatedAlarms", this.hasAssociatedAlarms() ? this.associatedAlarms() : null).add("Triggers", this.hasTriggers() ? this.triggers() : null).add("Name", (Object)this.name()).add("Regions", this.hasRegions() ? this.regions() : null).add("RecoveryApproach", (Object)this.recoveryApproachAsString()).add("PrimaryRegion", (Object)this.primaryRegion()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "workflows": {
                return Optional.ofNullable(clazz.cast(this.workflows()));
            }
            case "executionRole": {
                return Optional.ofNullable(clazz.cast(this.executionRole()));
            }
            case "recoveryTimeObjectiveMinutes": {
                return Optional.ofNullable(clazz.cast(this.recoveryTimeObjectiveMinutes()));
            }
            case "associatedAlarms": {
                return Optional.ofNullable(clazz.cast(this.associatedAlarms()));
            }
            case "triggers": {
                return Optional.ofNullable(clazz.cast(this.triggers()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "regions": {
                return Optional.ofNullable(clazz.cast(this.regions()));
            }
            case "recoveryApproach": {
                return Optional.ofNullable(clazz.cast(this.recoveryApproachAsString()));
            }
            case "primaryRegion": {
                return Optional.ofNullable(clazz.cast(this.primaryRegion()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("workflows", WORKFLOWS_FIELD);
        map.put("executionRole", EXECUTION_ROLE_FIELD);
        map.put("recoveryTimeObjectiveMinutes", RECOVERY_TIME_OBJECTIVE_MINUTES_FIELD);
        map.put("associatedAlarms", ASSOCIATED_ALARMS_FIELD);
        map.put("triggers", TRIGGERS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("regions", REGIONS_FIELD);
        map.put("recoveryApproach", RECOVERY_APPROACH_FIELD);
        map.put("primaryRegion", PRIMARY_REGION_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePlanRequest, T> g) {
        return obj -> g.apply((CreatePlanRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ArcRegionSwitchRequest.BuilderImpl
    implements Builder {
        private String description;
        private List<Workflow> workflows = DefaultSdkAutoConstructList.getInstance();
        private String executionRole;
        private Integer recoveryTimeObjectiveMinutes;
        private Map<String, AssociatedAlarm> associatedAlarms = DefaultSdkAutoConstructMap.getInstance();
        private List<Trigger> triggers = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private List<String> regions = DefaultSdkAutoConstructList.getInstance();
        private String recoveryApproach;
        private String primaryRegion;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlanRequest model) {
            super(model);
            this.description(model.description);
            this.workflows(model.workflows);
            this.executionRole(model.executionRole);
            this.recoveryTimeObjectiveMinutes(model.recoveryTimeObjectiveMinutes);
            this.associatedAlarms(model.associatedAlarms);
            this.triggers(model.triggers);
            this.name(model.name);
            this.regions(model.regions);
            this.recoveryApproach(model.recoveryApproach);
            this.primaryRegion(model.primaryRegion);
            this.tags(model.tags);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Workflow.Builder> getWorkflows() {
            List<Workflow.Builder> result = WorkflowListCopier.copyToBuilder(this.workflows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkflows(Collection<Workflow.BuilderImpl> workflows) {
            this.workflows = WorkflowListCopier.copyFromBuilder(workflows);
        }

        @Override
        public final Builder workflows(Collection<Workflow> workflows) {
            this.workflows = WorkflowListCopier.copy(workflows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflows(Workflow ... workflows) {
            this.workflows(Arrays.asList(workflows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflows(Consumer<Workflow.Builder> ... workflows) {
            this.workflows(Stream.of(workflows).map(c -> (Workflow)((Workflow.Builder)Workflow.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getExecutionRole() {
            return this.executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final Integer getRecoveryTimeObjectiveMinutes() {
            return this.recoveryTimeObjectiveMinutes;
        }

        public final void setRecoveryTimeObjectiveMinutes(Integer recoveryTimeObjectiveMinutes) {
            this.recoveryTimeObjectiveMinutes = recoveryTimeObjectiveMinutes;
        }

        @Override
        public final Builder recoveryTimeObjectiveMinutes(Integer recoveryTimeObjectiveMinutes) {
            this.recoveryTimeObjectiveMinutes = recoveryTimeObjectiveMinutes;
            return this;
        }

        public final Map<String, AssociatedAlarm.Builder> getAssociatedAlarms() {
            Map<String, AssociatedAlarm.Builder> result = AssociatedAlarmMapCopier.copyToBuilder(this.associatedAlarms);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAssociatedAlarms(Map<String, AssociatedAlarm.BuilderImpl> associatedAlarms) {
            this.associatedAlarms = AssociatedAlarmMapCopier.copyFromBuilder(associatedAlarms);
        }

        @Override
        public final Builder associatedAlarms(Map<String, AssociatedAlarm> associatedAlarms) {
            this.associatedAlarms = AssociatedAlarmMapCopier.copy(associatedAlarms);
            return this;
        }

        public final List<Trigger.Builder> getTriggers() {
            List<Trigger.Builder> result = TriggerListCopier.copyToBuilder(this.triggers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTriggers(Collection<Trigger.BuilderImpl> triggers) {
            this.triggers = TriggerListCopier.copyFromBuilder(triggers);
        }

        @Override
        public final Builder triggers(Collection<Trigger> triggers) {
            this.triggers = TriggerListCopier.copy(triggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(Trigger ... triggers) {
            this.triggers(Arrays.asList(triggers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(Consumer<Trigger.Builder> ... triggers) {
            this.triggers(Stream.of(triggers).map(c -> (Trigger)((Trigger.Builder)Trigger.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getRegions() {
            if (this.regions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        public final String getRecoveryApproach() {
            return this.recoveryApproach;
        }

        public final void setRecoveryApproach(String recoveryApproach) {
            this.recoveryApproach = recoveryApproach;
        }

        @Override
        public final Builder recoveryApproach(String recoveryApproach) {
            this.recoveryApproach = recoveryApproach;
            return this;
        }

        @Override
        public final Builder recoveryApproach(RecoveryApproach recoveryApproach) {
            this.recoveryApproach(recoveryApproach == null ? null : recoveryApproach.toString());
            return this;
        }

        public final String getPrimaryRegion() {
            return this.primaryRegion;
        }

        public final void setPrimaryRegion(String primaryRegion) {
            this.primaryRegion = primaryRegion;
        }

        @Override
        public final Builder primaryRegion(String primaryRegion) {
            this.primaryRegion = primaryRegion;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePlanRequest build() {
            return new CreatePlanRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ArcRegionSwitchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePlanRequest> {
        public Builder description(String var1);

        public Builder workflows(Collection<Workflow> var1);

        public Builder workflows(Workflow ... var1);

        public Builder workflows(Consumer<Workflow.Builder> ... var1);

        public Builder executionRole(String var1);

        public Builder recoveryTimeObjectiveMinutes(Integer var1);

        public Builder associatedAlarms(Map<String, AssociatedAlarm> var1);

        public Builder triggers(Collection<Trigger> var1);

        public Builder triggers(Trigger ... var1);

        public Builder triggers(Consumer<Trigger.Builder> ... var1);

        public Builder name(String var1);

        public Builder regions(Collection<String> var1);

        public Builder regions(String ... var1);

        public Builder recoveryApproach(String var1);

        public Builder recoveryApproach(RecoveryApproach var1);

        public Builder primaryRegion(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

