/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.arcregionswitch.model.ArcRoutingControlState;
import software.amazon.awssdk.services.arcregionswitch.model.RegionAndRoutingControlsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ArcRoutingControlConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ArcRoutingControlConfiguration> {
    private static final SdkField<Integer> TIMEOUT_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("timeoutMinutes").getter(ArcRoutingControlConfiguration.getter(ArcRoutingControlConfiguration::timeoutMinutes)).setter(ArcRoutingControlConfiguration.setter(Builder::timeoutMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutMinutes").build()}).build();
    private static final SdkField<String> CROSS_ACCOUNT_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("crossAccountRole").getter(ArcRoutingControlConfiguration.getter(ArcRoutingControlConfiguration::crossAccountRole)).setter(ArcRoutingControlConfiguration.setter(Builder::crossAccountRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crossAccountRole").build()}).build();
    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("externalId").getter(ArcRoutingControlConfiguration.getter(ArcRoutingControlConfiguration::externalId)).setter(ArcRoutingControlConfiguration.setter(Builder::externalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()}).build();
    private static final SdkField<Map<String, List<ArcRoutingControlState>>> REGION_AND_ROUTING_CONTROLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("regionAndRoutingControls").getter(ArcRoutingControlConfiguration.getter(ArcRoutingControlConfiguration::regionAndRoutingControls)).setter(ArcRoutingControlConfiguration.setter(Builder::regionAndRoutingControls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionAndRoutingControls").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ArcRoutingControlState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEOUT_MINUTES_FIELD, CROSS_ACCOUNT_ROLE_FIELD, EXTERNAL_ID_FIELD, REGION_AND_ROUTING_CONTROLS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ArcRoutingControlConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer timeoutMinutes;
    private final String crossAccountRole;
    private final String externalId;
    private final Map<String, List<ArcRoutingControlState>> regionAndRoutingControls;

    private ArcRoutingControlConfiguration(BuilderImpl builder) {
        this.timeoutMinutes = builder.timeoutMinutes;
        this.crossAccountRole = builder.crossAccountRole;
        this.externalId = builder.externalId;
        this.regionAndRoutingControls = builder.regionAndRoutingControls;
    }

    public final Integer timeoutMinutes() {
        return this.timeoutMinutes;
    }

    public final String crossAccountRole() {
        return this.crossAccountRole;
    }

    public final String externalId() {
        return this.externalId;
    }

    public final boolean hasRegionAndRoutingControls() {
        return this.regionAndRoutingControls != null && !(this.regionAndRoutingControls instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<ArcRoutingControlState>> regionAndRoutingControls() {
        return this.regionAndRoutingControls;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.crossAccountRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegionAndRoutingControls() ? this.regionAndRoutingControls() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArcRoutingControlConfiguration)) {
            return false;
        }
        ArcRoutingControlConfiguration other = (ArcRoutingControlConfiguration)obj;
        return Objects.equals(this.timeoutMinutes(), other.timeoutMinutes()) && Objects.equals(this.crossAccountRole(), other.crossAccountRole()) && Objects.equals(this.externalId(), other.externalId()) && this.hasRegionAndRoutingControls() == other.hasRegionAndRoutingControls() && Objects.equals(this.regionAndRoutingControls(), other.regionAndRoutingControls());
    }

    public final String toString() {
        return ToString.builder((String)"ArcRoutingControlConfiguration").add("TimeoutMinutes", (Object)this.timeoutMinutes()).add("CrossAccountRole", (Object)this.crossAccountRole()).add("ExternalId", (Object)this.externalId()).add("RegionAndRoutingControls", this.hasRegionAndRoutingControls() ? this.regionAndRoutingControls() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "timeoutMinutes": {
                return Optional.ofNullable(clazz.cast(this.timeoutMinutes()));
            }
            case "crossAccountRole": {
                return Optional.ofNullable(clazz.cast(this.crossAccountRole()));
            }
            case "externalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
            case "regionAndRoutingControls": {
                return Optional.ofNullable(clazz.cast(this.regionAndRoutingControls()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("timeoutMinutes", TIMEOUT_MINUTES_FIELD);
        map.put("crossAccountRole", CROSS_ACCOUNT_ROLE_FIELD);
        map.put("externalId", EXTERNAL_ID_FIELD);
        map.put("regionAndRoutingControls", REGION_AND_ROUTING_CONTROLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ArcRoutingControlConfiguration, T> g) {
        return obj -> g.apply((ArcRoutingControlConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer timeoutMinutes;
        private String crossAccountRole;
        private String externalId;
        private Map<String, List<ArcRoutingControlState>> regionAndRoutingControls = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ArcRoutingControlConfiguration model) {
            this.timeoutMinutes(model.timeoutMinutes);
            this.crossAccountRole(model.crossAccountRole);
            this.externalId(model.externalId);
            this.regionAndRoutingControls(model.regionAndRoutingControls);
        }

        public final Integer getTimeoutMinutes() {
            return this.timeoutMinutes;
        }

        public final void setTimeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
        }

        @Override
        public final Builder timeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
            return this;
        }

        public final String getCrossAccountRole() {
            return this.crossAccountRole;
        }

        public final void setCrossAccountRole(String crossAccountRole) {
            this.crossAccountRole = crossAccountRole;
        }

        @Override
        public final Builder crossAccountRole(String crossAccountRole) {
            this.crossAccountRole = crossAccountRole;
            return this;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final Map<String, List<ArcRoutingControlState.Builder>> getRegionAndRoutingControls() {
            Map<String, List<ArcRoutingControlState.Builder>> result = RegionAndRoutingControlsCopier.copyToBuilder(this.regionAndRoutingControls);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setRegionAndRoutingControls(Map<String, ? extends Collection<ArcRoutingControlState.BuilderImpl>> regionAndRoutingControls) {
            this.regionAndRoutingControls = RegionAndRoutingControlsCopier.copyFromBuilder(regionAndRoutingControls);
        }

        @Override
        public final Builder regionAndRoutingControls(Map<String, ? extends Collection<ArcRoutingControlState>> regionAndRoutingControls) {
            this.regionAndRoutingControls = RegionAndRoutingControlsCopier.copy(regionAndRoutingControls);
            return this;
        }

        public ArcRoutingControlConfiguration build() {
            return new ArcRoutingControlConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ArcRoutingControlConfiguration> {
        public Builder timeoutMinutes(Integer var1);

        public Builder crossAccountRole(String var1);

        public Builder externalId(String var1);

        public Builder regionAndRoutingControls(Map<String, ? extends Collection<ArcRoutingControlState>> var1);
    }
}

