/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExecutionState {
    IN_PROGRESS("inProgress"),
    PAUSED_BY_FAILED_STEP("pausedByFailedStep"),
    PAUSED_BY_OPERATOR("pausedByOperator"),
    COMPLETED("completed"),
    COMPLETED_WITH_EXCEPTIONS("completedWithExceptions"),
    CANCELED("canceled"),
    PLAN_EXECUTION_TIMED_OUT("planExecutionTimedOut"),
    PENDING_MANUAL_APPROVAL("pendingManualApproval"),
    FAILED("failed"),
    PENDING("pending"),
    COMPLETED_MONITORING_APPLICATION_HEALTH("completedMonitoringApplicationHealth"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExecutionState> VALUE_MAP;
    private final String value;

    private ExecutionState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExecutionState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExecutionState> knownValues() {
        EnumSet<ExecutionState> knownValues = EnumSet.allOf(ExecutionState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExecutionState.class, ExecutionState::toString);
    }
}

