/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.arcregionswitch.model.TriggerCondition;
import software.amazon.awssdk.services.arcregionswitch.model.TriggerConditionListCopier;
import software.amazon.awssdk.services.arcregionswitch.model.WorkflowTargetAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Trigger
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Trigger> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Trigger.getter(Trigger::description)).setter(Trigger.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> TARGET_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetRegion").getter(Trigger.getter(Trigger::targetRegion)).setter(Trigger.setter(Builder::targetRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetRegion").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("action").getter(Trigger.getter(Trigger::actionAsString)).setter(Trigger.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<List<TriggerCondition>> CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("conditions").getter(Trigger.getter(Trigger::conditions)).setter(Trigger.setter(Builder::conditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TriggerCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MIN_DELAY_MINUTES_BETWEEN_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minDelayMinutesBetweenExecutions").getter(Trigger.getter(Trigger::minDelayMinutesBetweenExecutions)).setter(Trigger.setter(Builder::minDelayMinutesBetweenExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minDelayMinutesBetweenExecutions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, TARGET_REGION_FIELD, ACTION_FIELD, CONDITIONS_FIELD, MIN_DELAY_MINUTES_BETWEEN_EXECUTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Trigger.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String targetRegion;
    private final String action;
    private final List<TriggerCondition> conditions;
    private final Integer minDelayMinutesBetweenExecutions;

    private Trigger(BuilderImpl builder) {
        this.description = builder.description;
        this.targetRegion = builder.targetRegion;
        this.action = builder.action;
        this.conditions = builder.conditions;
        this.minDelayMinutesBetweenExecutions = builder.minDelayMinutesBetweenExecutions;
    }

    public final String description() {
        return this.description;
    }

    public final String targetRegion() {
        return this.targetRegion;
    }

    public final WorkflowTargetAction action() {
        return WorkflowTargetAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final boolean hasConditions() {
        return this.conditions != null && !(this.conditions instanceof SdkAutoConstructList);
    }

    public final List<TriggerCondition> conditions() {
        return this.conditions;
    }

    public final Integer minDelayMinutesBetweenExecutions() {
        return this.minDelayMinutesBetweenExecutions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConditions() ? this.conditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.minDelayMinutesBetweenExecutions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Trigger)) {
            return false;
        }
        Trigger other = (Trigger)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.targetRegion(), other.targetRegion()) && Objects.equals(this.actionAsString(), other.actionAsString()) && this.hasConditions() == other.hasConditions() && Objects.equals(this.conditions(), other.conditions()) && Objects.equals(this.minDelayMinutesBetweenExecutions(), other.minDelayMinutesBetweenExecutions());
    }

    public final String toString() {
        return ToString.builder((String)"Trigger").add("Description", (Object)this.description()).add("TargetRegion", (Object)this.targetRegion()).add("Action", (Object)this.actionAsString()).add("Conditions", this.hasConditions() ? this.conditions() : null).add("MinDelayMinutesBetweenExecutions", (Object)this.minDelayMinutesBetweenExecutions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "targetRegion": {
                return Optional.ofNullable(clazz.cast(this.targetRegion()));
            }
            case "action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "conditions": {
                return Optional.ofNullable(clazz.cast(this.conditions()));
            }
            case "minDelayMinutesBetweenExecutions": {
                return Optional.ofNullable(clazz.cast(this.minDelayMinutesBetweenExecutions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("targetRegion", TARGET_REGION_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("conditions", CONDITIONS_FIELD);
        map.put("minDelayMinutesBetweenExecutions", MIN_DELAY_MINUTES_BETWEEN_EXECUTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Trigger, T> g) {
        return obj -> g.apply((Trigger)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String targetRegion;
        private String action;
        private List<TriggerCondition> conditions = DefaultSdkAutoConstructList.getInstance();
        private Integer minDelayMinutesBetweenExecutions;

        private BuilderImpl() {
        }

        private BuilderImpl(Trigger model) {
            this.description(model.description);
            this.targetRegion(model.targetRegion);
            this.action(model.action);
            this.conditions(model.conditions);
            this.minDelayMinutesBetweenExecutions(model.minDelayMinutesBetweenExecutions);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTargetRegion() {
            return this.targetRegion;
        }

        public final void setTargetRegion(String targetRegion) {
            this.targetRegion = targetRegion;
        }

        @Override
        public final Builder targetRegion(String targetRegion) {
            this.targetRegion = targetRegion;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(WorkflowTargetAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final List<TriggerCondition.Builder> getConditions() {
            List<TriggerCondition.Builder> result = TriggerConditionListCopier.copyToBuilder(this.conditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditions(Collection<TriggerCondition.BuilderImpl> conditions) {
            this.conditions = TriggerConditionListCopier.copyFromBuilder(conditions);
        }

        @Override
        public final Builder conditions(Collection<TriggerCondition> conditions) {
            this.conditions = TriggerConditionListCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(TriggerCondition ... conditions) {
            this.conditions(Arrays.asList(conditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Consumer<TriggerCondition.Builder> ... conditions) {
            this.conditions(Stream.of(conditions).map(c -> (TriggerCondition)((TriggerCondition.Builder)TriggerCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMinDelayMinutesBetweenExecutions() {
            return this.minDelayMinutesBetweenExecutions;
        }

        public final void setMinDelayMinutesBetweenExecutions(Integer minDelayMinutesBetweenExecutions) {
            this.minDelayMinutesBetweenExecutions = minDelayMinutesBetweenExecutions;
        }

        @Override
        public final Builder minDelayMinutesBetweenExecutions(Integer minDelayMinutesBetweenExecutions) {
            this.minDelayMinutesBetweenExecutions = minDelayMinutesBetweenExecutions;
            return this;
        }

        public Trigger build() {
            return new Trigger(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Trigger> {
        public Builder description(String var1);

        public Builder targetRegion(String var1);

        public Builder action(String var1);

        public Builder action(WorkflowTargetAction var1);

        public Builder conditions(Collection<TriggerCondition> var1);

        public Builder conditions(TriggerCondition ... var1);

        public Builder conditions(Consumer<TriggerCondition.Builder> ... var1);

        public Builder minDelayMinutesBetweenExecutions(Integer var1);
    }
}

