/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Route53HealthCheck
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Route53HealthCheck> {
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostedZoneId").getter(Route53HealthCheck.getter(Route53HealthCheck::hostedZoneId)).setter(Route53HealthCheck.setter(Builder::hostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostedZoneId").build()}).build();
    private static final SdkField<String> RECORD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recordName").getter(Route53HealthCheck.getter(Route53HealthCheck::recordName)).setter(Route53HealthCheck.setter(Builder::recordName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordName").build()}).build();
    private static final SdkField<String> HEALTH_CHECK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("healthCheckId").getter(Route53HealthCheck.getter(Route53HealthCheck::healthCheckId)).setter(Route53HealthCheck.setter(Builder::healthCheckId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheckId").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(Route53HealthCheck.getter(Route53HealthCheck::region)).setter(Route53HealthCheck.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONE_ID_FIELD, RECORD_NAME_FIELD, HEALTH_CHECK_ID_FIELD, REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Route53HealthCheck.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String hostedZoneId;
    private final String recordName;
    private final String healthCheckId;
    private final String region;

    private Route53HealthCheck(BuilderImpl builder) {
        this.hostedZoneId = builder.hostedZoneId;
        this.recordName = builder.recordName;
        this.healthCheckId = builder.healthCheckId;
        this.region = builder.region;
    }

    public final String hostedZoneId() {
        return this.hostedZoneId;
    }

    public final String recordName() {
        return this.recordName;
    }

    public final String healthCheckId() {
        return this.healthCheckId;
    }

    public final String region() {
        return this.region;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordName());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckId());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Route53HealthCheck)) {
            return false;
        }
        Route53HealthCheck other = (Route53HealthCheck)obj;
        return Objects.equals(this.hostedZoneId(), other.hostedZoneId()) && Objects.equals(this.recordName(), other.recordName()) && Objects.equals(this.healthCheckId(), other.healthCheckId()) && Objects.equals(this.region(), other.region());
    }

    public final String toString() {
        return ToString.builder((String)"Route53HealthCheck").add("HostedZoneId", (Object)this.hostedZoneId()).add("RecordName", (Object)this.recordName()).add("HealthCheckId", (Object)this.healthCheckId()).add("Region", (Object)this.region()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "hostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneId()));
            }
            case "recordName": {
                return Optional.ofNullable(clazz.cast(this.recordName()));
            }
            case "healthCheckId": {
                return Optional.ofNullable(clazz.cast(this.healthCheckId()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("hostedZoneId", HOSTED_ZONE_ID_FIELD);
        map.put("recordName", RECORD_NAME_FIELD);
        map.put("healthCheckId", HEALTH_CHECK_ID_FIELD);
        map.put("region", REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Route53HealthCheck, T> g) {
        return obj -> g.apply((Route53HealthCheck)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hostedZoneId;
        private String recordName;
        private String healthCheckId;
        private String region;

        private BuilderImpl() {
        }

        private BuilderImpl(Route53HealthCheck model) {
            this.hostedZoneId(model.hostedZoneId);
            this.recordName(model.recordName);
            this.healthCheckId(model.healthCheckId);
            this.region(model.region);
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final String getRecordName() {
            return this.recordName;
        }

        public final void setRecordName(String recordName) {
            this.recordName = recordName;
        }

        @Override
        public final Builder recordName(String recordName) {
            this.recordName = recordName;
            return this;
        }

        public final String getHealthCheckId() {
            return this.healthCheckId;
        }

        public final void setHealthCheckId(String healthCheckId) {
            this.healthCheckId = healthCheckId;
        }

        @Override
        public final Builder healthCheckId(String healthCheckId) {
            this.healthCheckId = healthCheckId;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public Route53HealthCheck build() {
            return new Route53HealthCheck(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Route53HealthCheck> {
        public Builder hostedZoneId(String var1);

        public Builder recordName(String var1);

        public Builder healthCheckId(String var1);

        public Builder region(String var1);
    }
}

