/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.arcregionswitch.ArcRegionSwitchClient;
import software.amazon.awssdk.services.arcregionswitch.internal.UserAgentUtils;
import software.amazon.awssdk.services.arcregionswitch.model.GetPlanExecutionRequest;
import software.amazon.awssdk.services.arcregionswitch.model.GetPlanExecutionResponse;
import software.amazon.awssdk.services.arcregionswitch.model.StepState;

public class GetPlanExecutionIterable
implements SdkIterable<GetPlanExecutionResponse> {
    private final ArcRegionSwitchClient client;
    private final GetPlanExecutionRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetPlanExecutionIterable(ArcRegionSwitchClient client, GetPlanExecutionRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetPlanExecutionResponseFetcher();
    }

    public Iterator<GetPlanExecutionResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StepState> stepStates() {
        Function<GetPlanExecutionResponse, Iterator> getIterator = response -> {
            if (response != null && response.stepStates() != null) {
                return response.stepStates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetPlanExecutionResponseFetcher
    implements SyncPageFetcher<GetPlanExecutionResponse> {
        private GetPlanExecutionResponseFetcher() {
        }

        public boolean hasNextPage(GetPlanExecutionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetPlanExecutionResponse nextPage(GetPlanExecutionResponse previousPage) {
            if (previousPage == null) {
                return GetPlanExecutionIterable.this.client.getPlanExecution(GetPlanExecutionIterable.this.firstRequest);
            }
            return GetPlanExecutionIterable.this.client.getPlanExecution((GetPlanExecutionRequest)((Object)GetPlanExecutionIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

