/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KubernetesResourceType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KubernetesResourceType> {
    private static final SdkField<String> API_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiVersion").getter(KubernetesResourceType.getter(KubernetesResourceType::apiVersion)).setter(KubernetesResourceType.setter(Builder::apiVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiVersion").build()}).build();
    private static final SdkField<String> KIND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kind").getter(KubernetesResourceType.getter(KubernetesResourceType::kind)).setter(KubernetesResourceType.setter(Builder::kind)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kind").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_VERSION_FIELD, KIND_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KubernetesResourceType.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String apiVersion;
    private final String kind;

    private KubernetesResourceType(BuilderImpl builder) {
        this.apiVersion = builder.apiVersion;
        this.kind = builder.kind;
    }

    public final String apiVersion() {
        return this.apiVersion;
    }

    public final String kind() {
        return this.kind;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.kind());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KubernetesResourceType)) {
            return false;
        }
        KubernetesResourceType other = (KubernetesResourceType)obj;
        return Objects.equals(this.apiVersion(), other.apiVersion()) && Objects.equals(this.kind(), other.kind());
    }

    public final String toString() {
        return ToString.builder((String)"KubernetesResourceType").add("ApiVersion", (Object)this.apiVersion()).add("Kind", (Object)this.kind()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apiVersion": {
                return Optional.ofNullable(clazz.cast(this.apiVersion()));
            }
            case "kind": {
                return Optional.ofNullable(clazz.cast(this.kind()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("apiVersion", API_VERSION_FIELD);
        map.put("kind", KIND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KubernetesResourceType, T> g) {
        return obj -> g.apply((KubernetesResourceType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String apiVersion;
        private String kind;

        private BuilderImpl() {
        }

        private BuilderImpl(KubernetesResourceType model) {
            this.apiVersion(model.apiVersion);
            this.kind(model.kind);
        }

        public final String getApiVersion() {
            return this.apiVersion;
        }

        public final void setApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
        }

        @Override
        public final Builder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public final String getKind() {
            return this.kind;
        }

        public final void setKind(String kind) {
            this.kind = kind;
        }

        @Override
        public final Builder kind(String kind) {
            this.kind = kind;
            return this;
        }

        public KubernetesResourceType build() {
            return new KubernetesResourceType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KubernetesResourceType> {
        public Builder apiVersion(String var1);

        public Builder kind(String var1);
    }
}

