/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.arcregionswitch.ArcRegionSwitchClient;
import software.amazon.awssdk.services.arcregionswitch.internal.UserAgentUtils;
import software.amazon.awssdk.services.arcregionswitch.model.AbbreviatedPlan;
import software.amazon.awssdk.services.arcregionswitch.model.ListPlansInRegionRequest;
import software.amazon.awssdk.services.arcregionswitch.model.ListPlansInRegionResponse;

public class ListPlansInRegionIterable
implements SdkIterable<ListPlansInRegionResponse> {
    private final ArcRegionSwitchClient client;
    private final ListPlansInRegionRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPlansInRegionIterable(ArcRegionSwitchClient client, ListPlansInRegionRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPlansInRegionResponseFetcher();
    }

    public Iterator<ListPlansInRegionResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AbbreviatedPlan> plans() {
        Function<ListPlansInRegionResponse, Iterator> getIterator = response -> {
            if (response != null && response.plans() != null) {
                return response.plans().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPlansInRegionResponseFetcher
    implements SyncPageFetcher<ListPlansInRegionResponse> {
        private ListPlansInRegionResponseFetcher() {
        }

        public boolean hasNextPage(ListPlansInRegionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPlansInRegionResponse nextPage(ListPlansInRegionResponse previousPage) {
            if (previousPage == null) {
                return ListPlansInRegionIterable.this.client.listPlansInRegion(ListPlansInRegionIterable.this.firstRequest);
            }
            return ListPlansInRegionIterable.this.client.listPlansInRegion((ListPlansInRegionRequest)((Object)ListPlansInRegionIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

