/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apptest.model.CloudFormation;
import software.amazon.awssdk.services.apptest.model.M2ManagedApplication;
import software.amazon.awssdk.services.apptest.model.M2NonManagedApplication;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceType> {
    private static final SdkField<CloudFormation> CLOUD_FORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cloudFormation").getter(ResourceType.getter(ResourceType::cloudFormation)).setter(ResourceType.setter(Builder::cloudFormation)).constructor(CloudFormation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudFormation").build()}).build();
    private static final SdkField<M2ManagedApplication> M2_MANAGED_APPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("m2ManagedApplication").getter(ResourceType.getter(ResourceType::m2ManagedApplication)).setter(ResourceType.setter(Builder::m2ManagedApplication)).constructor(M2ManagedApplication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("m2ManagedApplication").build()}).build();
    private static final SdkField<M2NonManagedApplication> M2_NON_MANAGED_APPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("m2NonManagedApplication").getter(ResourceType.getter(ResourceType::m2NonManagedApplication)).setter(ResourceType.setter(Builder::m2NonManagedApplication)).constructor(M2NonManagedApplication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("m2NonManagedApplication").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_FORMATION_FIELD, M2_MANAGED_APPLICATION_FIELD, M2_NON_MANAGED_APPLICATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceType.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CloudFormation cloudFormation;
    private final M2ManagedApplication m2ManagedApplication;
    private final M2NonManagedApplication m2NonManagedApplication;
    private final Type type;

    private ResourceType(BuilderImpl builder) {
        this.cloudFormation = builder.cloudFormation;
        this.m2ManagedApplication = builder.m2ManagedApplication;
        this.m2NonManagedApplication = builder.m2NonManagedApplication;
        this.type = builder.type;
    }

    public final CloudFormation cloudFormation() {
        return this.cloudFormation;
    }

    public final M2ManagedApplication m2ManagedApplication() {
        return this.m2ManagedApplication;
    }

    public final M2NonManagedApplication m2NonManagedApplication() {
        return this.m2NonManagedApplication;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudFormation());
        hashCode = 31 * hashCode + Objects.hashCode(this.m2ManagedApplication());
        hashCode = 31 * hashCode + Objects.hashCode(this.m2NonManagedApplication());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceType)) {
            return false;
        }
        ResourceType other = (ResourceType)obj;
        return Objects.equals(this.cloudFormation(), other.cloudFormation()) && Objects.equals(this.m2ManagedApplication(), other.m2ManagedApplication()) && Objects.equals(this.m2NonManagedApplication(), other.m2NonManagedApplication());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceType").add("CloudFormation", (Object)this.cloudFormation()).add("M2ManagedApplication", (Object)this.m2ManagedApplication()).add("M2NonManagedApplication", (Object)this.m2NonManagedApplication()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cloudFormation": {
                return Optional.ofNullable(clazz.cast(this.cloudFormation()));
            }
            case "m2ManagedApplication": {
                return Optional.ofNullable(clazz.cast(this.m2ManagedApplication()));
            }
            case "m2NonManagedApplication": {
                return Optional.ofNullable(clazz.cast(this.m2NonManagedApplication()));
            }
        }
        return Optional.empty();
    }

    public static ResourceType fromCloudFormation(CloudFormation cloudFormation) {
        return (ResourceType)ResourceType.builder().cloudFormation(cloudFormation).build();
    }

    public static ResourceType fromCloudFormation(Consumer<CloudFormation.Builder> cloudFormation) {
        CloudFormation.Builder builder = CloudFormation.builder();
        cloudFormation.accept(builder);
        return ResourceType.fromCloudFormation((CloudFormation)builder.build());
    }

    public static ResourceType fromM2ManagedApplication(M2ManagedApplication m2ManagedApplication) {
        return (ResourceType)ResourceType.builder().m2ManagedApplication(m2ManagedApplication).build();
    }

    public static ResourceType fromM2ManagedApplication(Consumer<M2ManagedApplication.Builder> m2ManagedApplication) {
        M2ManagedApplication.Builder builder = M2ManagedApplication.builder();
        m2ManagedApplication.accept(builder);
        return ResourceType.fromM2ManagedApplication((M2ManagedApplication)builder.build());
    }

    public static ResourceType fromM2NonManagedApplication(M2NonManagedApplication m2NonManagedApplication) {
        return (ResourceType)ResourceType.builder().m2NonManagedApplication(m2NonManagedApplication).build();
    }

    public static ResourceType fromM2NonManagedApplication(Consumer<M2NonManagedApplication.Builder> m2NonManagedApplication) {
        M2NonManagedApplication.Builder builder = M2NonManagedApplication.builder();
        m2NonManagedApplication.accept(builder);
        return ResourceType.fromM2NonManagedApplication((M2NonManagedApplication)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cloudFormation", CLOUD_FORMATION_FIELD);
        map.put("m2ManagedApplication", M2_MANAGED_APPLICATION_FIELD);
        map.put("m2NonManagedApplication", M2_NON_MANAGED_APPLICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceType, T> g) {
        return obj -> g.apply((ResourceType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CLOUD_FORMATION,
        M2_MANAGED_APPLICATION,
        M2_NON_MANAGED_APPLICATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private CloudFormation cloudFormation;
        private M2ManagedApplication m2ManagedApplication;
        private M2NonManagedApplication m2NonManagedApplication;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceType model) {
            this.cloudFormation(model.cloudFormation);
            this.m2ManagedApplication(model.m2ManagedApplication);
            this.m2NonManagedApplication(model.m2NonManagedApplication);
        }

        public final CloudFormation.Builder getCloudFormation() {
            return this.cloudFormation != null ? this.cloudFormation.toBuilder() : null;
        }

        public final void setCloudFormation(CloudFormation.BuilderImpl cloudFormation) {
            CloudFormation oldValue = this.cloudFormation;
            this.cloudFormation = cloudFormation != null ? cloudFormation.build() : null;
            this.handleUnionValueChange(Type.CLOUD_FORMATION, oldValue, this.cloudFormation);
        }

        @Override
        public final Builder cloudFormation(CloudFormation cloudFormation) {
            CloudFormation oldValue = this.cloudFormation;
            this.cloudFormation = cloudFormation;
            this.handleUnionValueChange(Type.CLOUD_FORMATION, oldValue, this.cloudFormation);
            return this;
        }

        public final M2ManagedApplication.Builder getM2ManagedApplication() {
            return this.m2ManagedApplication != null ? this.m2ManagedApplication.toBuilder() : null;
        }

        public final void setM2ManagedApplication(M2ManagedApplication.BuilderImpl m2ManagedApplication) {
            M2ManagedApplication oldValue = this.m2ManagedApplication;
            this.m2ManagedApplication = m2ManagedApplication != null ? m2ManagedApplication.build() : null;
            this.handleUnionValueChange(Type.M2_MANAGED_APPLICATION, oldValue, this.m2ManagedApplication);
        }

        @Override
        public final Builder m2ManagedApplication(M2ManagedApplication m2ManagedApplication) {
            M2ManagedApplication oldValue = this.m2ManagedApplication;
            this.m2ManagedApplication = m2ManagedApplication;
            this.handleUnionValueChange(Type.M2_MANAGED_APPLICATION, oldValue, this.m2ManagedApplication);
            return this;
        }

        public final M2NonManagedApplication.Builder getM2NonManagedApplication() {
            return this.m2NonManagedApplication != null ? this.m2NonManagedApplication.toBuilder() : null;
        }

        public final void setM2NonManagedApplication(M2NonManagedApplication.BuilderImpl m2NonManagedApplication) {
            M2NonManagedApplication oldValue = this.m2NonManagedApplication;
            this.m2NonManagedApplication = m2NonManagedApplication != null ? m2NonManagedApplication.build() : null;
            this.handleUnionValueChange(Type.M2_NON_MANAGED_APPLICATION, oldValue, this.m2NonManagedApplication);
        }

        @Override
        public final Builder m2NonManagedApplication(M2NonManagedApplication m2NonManagedApplication) {
            M2NonManagedApplication oldValue = this.m2NonManagedApplication;
            this.m2NonManagedApplication = m2NonManagedApplication;
            this.handleUnionValueChange(Type.M2_NON_MANAGED_APPLICATION, oldValue, this.m2NonManagedApplication);
            return this;
        }

        public ResourceType build() {
            return new ResourceType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceType> {
        public Builder cloudFormation(CloudFormation var1);

        default public Builder cloudFormation(Consumer<CloudFormation.Builder> cloudFormation) {
            return this.cloudFormation((CloudFormation)((CloudFormation.Builder)CloudFormation.builder().applyMutation(cloudFormation)).build());
        }

        public Builder m2ManagedApplication(M2ManagedApplication var1);

        default public Builder m2ManagedApplication(Consumer<M2ManagedApplication.Builder> m2ManagedApplication) {
            return this.m2ManagedApplication((M2ManagedApplication)((M2ManagedApplication.Builder)M2ManagedApplication.builder().applyMutation(m2ManagedApplication)).build());
        }

        public Builder m2NonManagedApplication(M2NonManagedApplication var1);

        default public Builder m2NonManagedApplication(Consumer<M2NonManagedApplication.Builder> m2NonManagedApplication) {
            return this.m2NonManagedApplication((M2NonManagedApplication)((M2NonManagedApplication.Builder)M2NonManagedApplication.builder().applyMutation(m2NonManagedApplication)).build());
        }
    }
}

