/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apptest.model.TestCaseRunStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestCaseRunSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TestCaseRunSummary> {
    private static final SdkField<String> TEST_CASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testCaseId").getter(TestCaseRunSummary.getter(TestCaseRunSummary::testCaseId)).setter(TestCaseRunSummary.setter(Builder::testCaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseId").build()}).build();
    private static final SdkField<Integer> TEST_CASE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("testCaseVersion").getter(TestCaseRunSummary.getter(TestCaseRunSummary::testCaseVersion)).setter(TestCaseRunSummary.setter(Builder::testCaseVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseVersion").build()}).build();
    private static final SdkField<String> TEST_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testRunId").getter(TestCaseRunSummary.getter(TestCaseRunSummary::testRunId)).setter(TestCaseRunSummary.setter(Builder::testRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testRunId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(TestCaseRunSummary.getter(TestCaseRunSummary::statusAsString)).setter(TestCaseRunSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(TestCaseRunSummary.getter(TestCaseRunSummary::statusReason)).setter(TestCaseRunSummary.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<Instant> RUN_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("runStartTime").getter(TestCaseRunSummary.getter(TestCaseRunSummary::runStartTime)).setter(TestCaseRunSummary.setter(Builder::runStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runStartTime").build()}).build();
    private static final SdkField<Instant> RUN_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("runEndTime").getter(TestCaseRunSummary.getter(TestCaseRunSummary::runEndTime)).setter(TestCaseRunSummary.setter(Builder::runEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runEndTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_CASE_ID_FIELD, TEST_CASE_VERSION_FIELD, TEST_RUN_ID_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, RUN_START_TIME_FIELD, RUN_END_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TestCaseRunSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String testCaseId;
    private final Integer testCaseVersion;
    private final String testRunId;
    private final String status;
    private final String statusReason;
    private final Instant runStartTime;
    private final Instant runEndTime;

    private TestCaseRunSummary(BuilderImpl builder) {
        this.testCaseId = builder.testCaseId;
        this.testCaseVersion = builder.testCaseVersion;
        this.testRunId = builder.testRunId;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.runStartTime = builder.runStartTime;
        this.runEndTime = builder.runEndTime;
    }

    public final String testCaseId() {
        return this.testCaseId;
    }

    public final Integer testCaseVersion() {
        return this.testCaseVersion;
    }

    public final String testRunId() {
        return this.testRunId;
    }

    public final TestCaseRunStatus status() {
        return TestCaseRunStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final Instant runStartTime() {
        return this.runStartTime;
    }

    public final Instant runEndTime() {
        return this.runEndTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.testCaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.testCaseVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.testRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.runStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.runEndTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestCaseRunSummary)) {
            return false;
        }
        TestCaseRunSummary other = (TestCaseRunSummary)obj;
        return Objects.equals(this.testCaseId(), other.testCaseId()) && Objects.equals(this.testCaseVersion(), other.testCaseVersion()) && Objects.equals(this.testRunId(), other.testRunId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.runStartTime(), other.runStartTime()) && Objects.equals(this.runEndTime(), other.runEndTime());
    }

    public final String toString() {
        return ToString.builder((String)"TestCaseRunSummary").add("TestCaseId", (Object)this.testCaseId()).add("TestCaseVersion", (Object)this.testCaseVersion()).add("TestRunId", (Object)this.testRunId()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("RunStartTime", (Object)this.runStartTime()).add("RunEndTime", (Object)this.runEndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testCaseId": {
                return Optional.ofNullable(clazz.cast(this.testCaseId()));
            }
            case "testCaseVersion": {
                return Optional.ofNullable(clazz.cast(this.testCaseVersion()));
            }
            case "testRunId": {
                return Optional.ofNullable(clazz.cast(this.testRunId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "runStartTime": {
                return Optional.ofNullable(clazz.cast(this.runStartTime()));
            }
            case "runEndTime": {
                return Optional.ofNullable(clazz.cast(this.runEndTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("testCaseId", TEST_CASE_ID_FIELD);
        map.put("testCaseVersion", TEST_CASE_VERSION_FIELD);
        map.put("testRunId", TEST_RUN_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("runStartTime", RUN_START_TIME_FIELD);
        map.put("runEndTime", RUN_END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestCaseRunSummary, T> g) {
        return obj -> g.apply((TestCaseRunSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String testCaseId;
        private Integer testCaseVersion;
        private String testRunId;
        private String status;
        private String statusReason;
        private Instant runStartTime;
        private Instant runEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(TestCaseRunSummary model) {
            this.testCaseId(model.testCaseId);
            this.testCaseVersion(model.testCaseVersion);
            this.testRunId(model.testRunId);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.runStartTime(model.runStartTime);
            this.runEndTime(model.runEndTime);
        }

        public final String getTestCaseId() {
            return this.testCaseId;
        }

        public final void setTestCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
        }

        @Override
        public final Builder testCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
            return this;
        }

        public final Integer getTestCaseVersion() {
            return this.testCaseVersion;
        }

        public final void setTestCaseVersion(Integer testCaseVersion) {
            this.testCaseVersion = testCaseVersion;
        }

        @Override
        public final Builder testCaseVersion(Integer testCaseVersion) {
            this.testCaseVersion = testCaseVersion;
            return this;
        }

        public final String getTestRunId() {
            return this.testRunId;
        }

        public final void setTestRunId(String testRunId) {
            this.testRunId = testRunId;
        }

        @Override
        public final Builder testRunId(String testRunId) {
            this.testRunId = testRunId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TestCaseRunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getRunStartTime() {
            return this.runStartTime;
        }

        public final void setRunStartTime(Instant runStartTime) {
            this.runStartTime = runStartTime;
        }

        @Override
        public final Builder runStartTime(Instant runStartTime) {
            this.runStartTime = runStartTime;
            return this;
        }

        public final Instant getRunEndTime() {
            return this.runEndTime;
        }

        public final void setRunEndTime(Instant runEndTime) {
            this.runEndTime = runEndTime;
        }

        @Override
        public final Builder runEndTime(Instant runEndTime) {
            this.runEndTime = runEndTime;
            return this;
        }

        public TestCaseRunSummary build() {
            return new TestCaseRunSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TestCaseRunSummary> {
        public Builder testCaseId(String var1);

        public Builder testCaseVersion(Integer var1);

        public Builder testRunId(String var1);

        public Builder status(String var1);

        public Builder status(TestCaseRunStatus var1);

        public Builder statusReason(String var1);

        public Builder runStartTime(Instant var1);

        public Builder runEndTime(Instant var1);
    }
}

