/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TestCaseLifecycle {
    ACTIVE("Active"),
    DELETING("Deleting"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TestCaseLifecycle> VALUE_MAP;
    private final String value;

    private TestCaseLifecycle(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TestCaseLifecycle fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TestCaseLifecycle> knownValues() {
        EnumSet<TestCaseLifecycle> knownValues = EnumSet.allOf(TestCaseLifecycle.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TestCaseLifecycle.class, TestCaseLifecycle::toString);
    }
}

