/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apptest.model.CloudFormationAction;
import software.amazon.awssdk.services.apptest.model.M2ManagedApplicationAction;
import software.amazon.awssdk.services.apptest.model.M2NonManagedApplicationAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceAction> {
    private static final SdkField<M2ManagedApplicationAction> M2_MANAGED_APPLICATION_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("m2ManagedApplicationAction").getter(ResourceAction.getter(ResourceAction::m2ManagedApplicationAction)).setter(ResourceAction.setter(Builder::m2ManagedApplicationAction)).constructor(M2ManagedApplicationAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("m2ManagedApplicationAction").build()}).build();
    private static final SdkField<M2NonManagedApplicationAction> M2_NON_MANAGED_APPLICATION_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("m2NonManagedApplicationAction").getter(ResourceAction.getter(ResourceAction::m2NonManagedApplicationAction)).setter(ResourceAction.setter(Builder::m2NonManagedApplicationAction)).constructor(M2NonManagedApplicationAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("m2NonManagedApplicationAction").build()}).build();
    private static final SdkField<CloudFormationAction> CLOUD_FORMATION_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cloudFormationAction").getter(ResourceAction.getter(ResourceAction::cloudFormationAction)).setter(ResourceAction.setter(Builder::cloudFormationAction)).constructor(CloudFormationAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudFormationAction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(M2_MANAGED_APPLICATION_ACTION_FIELD, M2_NON_MANAGED_APPLICATION_ACTION_FIELD, CLOUD_FORMATION_ACTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceAction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final M2ManagedApplicationAction m2ManagedApplicationAction;
    private final M2NonManagedApplicationAction m2NonManagedApplicationAction;
    private final CloudFormationAction cloudFormationAction;
    private final Type type;

    private ResourceAction(BuilderImpl builder) {
        this.m2ManagedApplicationAction = builder.m2ManagedApplicationAction;
        this.m2NonManagedApplicationAction = builder.m2NonManagedApplicationAction;
        this.cloudFormationAction = builder.cloudFormationAction;
        this.type = builder.type;
    }

    public final M2ManagedApplicationAction m2ManagedApplicationAction() {
        return this.m2ManagedApplicationAction;
    }

    public final M2NonManagedApplicationAction m2NonManagedApplicationAction() {
        return this.m2NonManagedApplicationAction;
    }

    public final CloudFormationAction cloudFormationAction() {
        return this.cloudFormationAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.m2ManagedApplicationAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.m2NonManagedApplicationAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudFormationAction());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceAction)) {
            return false;
        }
        ResourceAction other = (ResourceAction)obj;
        return Objects.equals(this.m2ManagedApplicationAction(), other.m2ManagedApplicationAction()) && Objects.equals(this.m2NonManagedApplicationAction(), other.m2NonManagedApplicationAction()) && Objects.equals(this.cloudFormationAction(), other.cloudFormationAction());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceAction").add("M2ManagedApplicationAction", (Object)this.m2ManagedApplicationAction()).add("M2NonManagedApplicationAction", (Object)this.m2NonManagedApplicationAction()).add("CloudFormationAction", (Object)this.cloudFormationAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "m2ManagedApplicationAction": {
                return Optional.ofNullable(clazz.cast(this.m2ManagedApplicationAction()));
            }
            case "m2NonManagedApplicationAction": {
                return Optional.ofNullable(clazz.cast(this.m2NonManagedApplicationAction()));
            }
            case "cloudFormationAction": {
                return Optional.ofNullable(clazz.cast(this.cloudFormationAction()));
            }
        }
        return Optional.empty();
    }

    public static ResourceAction fromM2ManagedApplicationAction(M2ManagedApplicationAction m2ManagedApplicationAction) {
        return (ResourceAction)ResourceAction.builder().m2ManagedApplicationAction(m2ManagedApplicationAction).build();
    }

    public static ResourceAction fromM2ManagedApplicationAction(Consumer<M2ManagedApplicationAction.Builder> m2ManagedApplicationAction) {
        M2ManagedApplicationAction.Builder builder = M2ManagedApplicationAction.builder();
        m2ManagedApplicationAction.accept(builder);
        return ResourceAction.fromM2ManagedApplicationAction((M2ManagedApplicationAction)builder.build());
    }

    public static ResourceAction fromM2NonManagedApplicationAction(M2NonManagedApplicationAction m2NonManagedApplicationAction) {
        return (ResourceAction)ResourceAction.builder().m2NonManagedApplicationAction(m2NonManagedApplicationAction).build();
    }

    public static ResourceAction fromM2NonManagedApplicationAction(Consumer<M2NonManagedApplicationAction.Builder> m2NonManagedApplicationAction) {
        M2NonManagedApplicationAction.Builder builder = M2NonManagedApplicationAction.builder();
        m2NonManagedApplicationAction.accept(builder);
        return ResourceAction.fromM2NonManagedApplicationAction((M2NonManagedApplicationAction)builder.build());
    }

    public static ResourceAction fromCloudFormationAction(CloudFormationAction cloudFormationAction) {
        return (ResourceAction)ResourceAction.builder().cloudFormationAction(cloudFormationAction).build();
    }

    public static ResourceAction fromCloudFormationAction(Consumer<CloudFormationAction.Builder> cloudFormationAction) {
        CloudFormationAction.Builder builder = CloudFormationAction.builder();
        cloudFormationAction.accept(builder);
        return ResourceAction.fromCloudFormationAction((CloudFormationAction)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("m2ManagedApplicationAction", M2_MANAGED_APPLICATION_ACTION_FIELD);
        map.put("m2NonManagedApplicationAction", M2_NON_MANAGED_APPLICATION_ACTION_FIELD);
        map.put("cloudFormationAction", CLOUD_FORMATION_ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceAction, T> g) {
        return obj -> g.apply((ResourceAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        M2_MANAGED_APPLICATION_ACTION,
        M2_NON_MANAGED_APPLICATION_ACTION,
        CLOUD_FORMATION_ACTION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private M2ManagedApplicationAction m2ManagedApplicationAction;
        private M2NonManagedApplicationAction m2NonManagedApplicationAction;
        private CloudFormationAction cloudFormationAction;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceAction model) {
            this.m2ManagedApplicationAction(model.m2ManagedApplicationAction);
            this.m2NonManagedApplicationAction(model.m2NonManagedApplicationAction);
            this.cloudFormationAction(model.cloudFormationAction);
        }

        public final M2ManagedApplicationAction.Builder getM2ManagedApplicationAction() {
            return this.m2ManagedApplicationAction != null ? this.m2ManagedApplicationAction.toBuilder() : null;
        }

        public final void setM2ManagedApplicationAction(M2ManagedApplicationAction.BuilderImpl m2ManagedApplicationAction) {
            M2ManagedApplicationAction oldValue = this.m2ManagedApplicationAction;
            this.m2ManagedApplicationAction = m2ManagedApplicationAction != null ? m2ManagedApplicationAction.build() : null;
            this.handleUnionValueChange(Type.M2_MANAGED_APPLICATION_ACTION, oldValue, this.m2ManagedApplicationAction);
        }

        @Override
        public final Builder m2ManagedApplicationAction(M2ManagedApplicationAction m2ManagedApplicationAction) {
            M2ManagedApplicationAction oldValue = this.m2ManagedApplicationAction;
            this.m2ManagedApplicationAction = m2ManagedApplicationAction;
            this.handleUnionValueChange(Type.M2_MANAGED_APPLICATION_ACTION, oldValue, this.m2ManagedApplicationAction);
            return this;
        }

        public final M2NonManagedApplicationAction.Builder getM2NonManagedApplicationAction() {
            return this.m2NonManagedApplicationAction != null ? this.m2NonManagedApplicationAction.toBuilder() : null;
        }

        public final void setM2NonManagedApplicationAction(M2NonManagedApplicationAction.BuilderImpl m2NonManagedApplicationAction) {
            M2NonManagedApplicationAction oldValue = this.m2NonManagedApplicationAction;
            this.m2NonManagedApplicationAction = m2NonManagedApplicationAction != null ? m2NonManagedApplicationAction.build() : null;
            this.handleUnionValueChange(Type.M2_NON_MANAGED_APPLICATION_ACTION, oldValue, this.m2NonManagedApplicationAction);
        }

        @Override
        public final Builder m2NonManagedApplicationAction(M2NonManagedApplicationAction m2NonManagedApplicationAction) {
            M2NonManagedApplicationAction oldValue = this.m2NonManagedApplicationAction;
            this.m2NonManagedApplicationAction = m2NonManagedApplicationAction;
            this.handleUnionValueChange(Type.M2_NON_MANAGED_APPLICATION_ACTION, oldValue, this.m2NonManagedApplicationAction);
            return this;
        }

        public final CloudFormationAction.Builder getCloudFormationAction() {
            return this.cloudFormationAction != null ? this.cloudFormationAction.toBuilder() : null;
        }

        public final void setCloudFormationAction(CloudFormationAction.BuilderImpl cloudFormationAction) {
            CloudFormationAction oldValue = this.cloudFormationAction;
            this.cloudFormationAction = cloudFormationAction != null ? cloudFormationAction.build() : null;
            this.handleUnionValueChange(Type.CLOUD_FORMATION_ACTION, oldValue, this.cloudFormationAction);
        }

        @Override
        public final Builder cloudFormationAction(CloudFormationAction cloudFormationAction) {
            CloudFormationAction oldValue = this.cloudFormationAction;
            this.cloudFormationAction = cloudFormationAction;
            this.handleUnionValueChange(Type.CLOUD_FORMATION_ACTION, oldValue, this.cloudFormationAction);
            return this;
        }

        public ResourceAction build() {
            return new ResourceAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceAction> {
        public Builder m2ManagedApplicationAction(M2ManagedApplicationAction var1);

        default public Builder m2ManagedApplicationAction(Consumer<M2ManagedApplicationAction.Builder> m2ManagedApplicationAction) {
            return this.m2ManagedApplicationAction((M2ManagedApplicationAction)((M2ManagedApplicationAction.Builder)M2ManagedApplicationAction.builder().applyMutation(m2ManagedApplicationAction)).build());
        }

        public Builder m2NonManagedApplicationAction(M2NonManagedApplicationAction var1);

        default public Builder m2NonManagedApplicationAction(Consumer<M2NonManagedApplicationAction.Builder> m2NonManagedApplicationAction) {
            return this.m2NonManagedApplicationAction((M2NonManagedApplicationAction)((M2NonManagedApplicationAction.Builder)M2NonManagedApplicationAction.builder().applyMutation(m2NonManagedApplicationAction)).build());
        }

        public Builder cloudFormationAction(CloudFormationAction var1);

        default public Builder cloudFormationAction(Consumer<CloudFormationAction.Builder> cloudFormationAction) {
            return this.cloudFormationAction((CloudFormationAction)((CloudFormationAction.Builder)CloudFormationAction.builder().applyMutation(cloudFormationAction)).build());
        }
    }
}

