/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apptest.model.AppTestResponse;
import software.amazon.awssdk.services.apptest.model.TestConfigurationListCopier;
import software.amazon.awssdk.services.apptest.model.TestConfigurationSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTestConfigurationsResponse
extends AppTestResponse
implements ToCopyableBuilder<Builder, ListTestConfigurationsResponse> {
    private static final SdkField<List<TestConfigurationSummary>> TEST_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("testConfigurations").getter(ListTestConfigurationsResponse.getter(ListTestConfigurationsResponse::testConfigurations)).setter(ListTestConfigurationsResponse.setter(Builder::testConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TestConfigurationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTestConfigurationsResponse.getter(ListTestConfigurationsResponse::nextToken)).setter(ListTestConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTestConfigurationsResponse.memberNameToFieldInitializer();
    private final List<TestConfigurationSummary> testConfigurations;
    private final String nextToken;

    private ListTestConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.testConfigurations = builder.testConfigurations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTestConfigurations() {
        return this.testConfigurations != null && !(this.testConfigurations instanceof SdkAutoConstructList);
    }

    public final List<TestConfigurationSummary> testConfigurations() {
        return this.testConfigurations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTestConfigurations() ? this.testConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestConfigurationsResponse)) {
            return false;
        }
        ListTestConfigurationsResponse other = (ListTestConfigurationsResponse)((Object)obj);
        return this.hasTestConfigurations() == other.hasTestConfigurations() && Objects.equals(this.testConfigurations(), other.testConfigurations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTestConfigurationsResponse").add("TestConfigurations", this.hasTestConfigurations() ? this.testConfigurations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testConfigurations": {
                return Optional.ofNullable(clazz.cast(this.testConfigurations()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("testConfigurations", TEST_CONFIGURATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTestConfigurationsResponse, T> g) {
        return obj -> g.apply((ListTestConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppTestResponse.BuilderImpl
    implements Builder {
        private List<TestConfigurationSummary> testConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestConfigurationsResponse model) {
            super(model);
            this.testConfigurations(model.testConfigurations);
            this.nextToken(model.nextToken);
        }

        public final List<TestConfigurationSummary.Builder> getTestConfigurations() {
            List<TestConfigurationSummary.Builder> result = TestConfigurationListCopier.copyToBuilder(this.testConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTestConfigurations(Collection<TestConfigurationSummary.BuilderImpl> testConfigurations) {
            this.testConfigurations = TestConfigurationListCopier.copyFromBuilder(testConfigurations);
        }

        @Override
        public final Builder testConfigurations(Collection<TestConfigurationSummary> testConfigurations) {
            this.testConfigurations = TestConfigurationListCopier.copy(testConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testConfigurations(TestConfigurationSummary ... testConfigurations) {
            this.testConfigurations(Arrays.asList(testConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testConfigurations(Consumer<TestConfigurationSummary.Builder> ... testConfigurations) {
            this.testConfigurations(Stream.of(testConfigurations).map(c -> (TestConfigurationSummary)((TestConfigurationSummary.Builder)TestConfigurationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTestConfigurationsResponse build() {
            return new ListTestConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppTestResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTestConfigurationsResponse> {
        public Builder testConfigurations(Collection<TestConfigurationSummary> var1);

        public Builder testConfigurations(TestConfigurationSummary ... var1);

        public Builder testConfigurations(Consumer<TestConfigurationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

