/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apptest.model.AppTestRequest;
import software.amazon.awssdk.services.apptest.model.Step;
import software.amazon.awssdk.services.apptest.model.StepListCopier;
import software.amazon.awssdk.services.apptest.model.TagMapCopier;
import software.amazon.awssdk.services.apptest.model.TestCases;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTestSuiteRequest
extends AppTestRequest
implements ToCopyableBuilder<Builder, CreateTestSuiteRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateTestSuiteRequest.getter(CreateTestSuiteRequest::name)).setter(CreateTestSuiteRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateTestSuiteRequest.getter(CreateTestSuiteRequest::description)).setter(CreateTestSuiteRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<Step>> BEFORE_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("beforeSteps").getter(CreateTestSuiteRequest.getter(CreateTestSuiteRequest::beforeSteps)).setter(CreateTestSuiteRequest.setter(Builder::beforeSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeSteps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Step::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Step>> AFTER_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("afterSteps").getter(CreateTestSuiteRequest.getter(CreateTestSuiteRequest::afterSteps)).setter(CreateTestSuiteRequest.setter(Builder::afterSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterSteps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Step::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TestCases> TEST_CASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("testCases").getter(CreateTestSuiteRequest.getter(CreateTestSuiteRequest::testCases)).setter(CreateTestSuiteRequest.setter(Builder::testCases)).constructor(TestCases::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCases").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateTestSuiteRequest.getter(CreateTestSuiteRequest::clientToken)).setter(CreateTestSuiteRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateTestSuiteRequest.getter(CreateTestSuiteRequest::tags)).setter(CreateTestSuiteRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, BEFORE_STEPS_FIELD, AFTER_STEPS_FIELD, TEST_CASES_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateTestSuiteRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final List<Step> beforeSteps;
    private final List<Step> afterSteps;
    private final TestCases testCases;
    private final String clientToken;
    private final Map<String, String> tags;

    private CreateTestSuiteRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.beforeSteps = builder.beforeSteps;
        this.afterSteps = builder.afterSteps;
        this.testCases = builder.testCases;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasBeforeSteps() {
        return this.beforeSteps != null && !(this.beforeSteps instanceof SdkAutoConstructList);
    }

    public final List<Step> beforeSteps() {
        return this.beforeSteps;
    }

    public final boolean hasAfterSteps() {
        return this.afterSteps != null && !(this.afterSteps instanceof SdkAutoConstructList);
    }

    public final List<Step> afterSteps() {
        return this.afterSteps;
    }

    public final TestCases testCases() {
        return this.testCases;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBeforeSteps() ? this.beforeSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAfterSteps() ? this.afterSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.testCases());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTestSuiteRequest)) {
            return false;
        }
        CreateTestSuiteRequest other = (CreateTestSuiteRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasBeforeSteps() == other.hasBeforeSteps() && Objects.equals(this.beforeSteps(), other.beforeSteps()) && this.hasAfterSteps() == other.hasAfterSteps() && Objects.equals(this.afterSteps(), other.afterSteps()) && Objects.equals(this.testCases(), other.testCases()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTestSuiteRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("BeforeSteps", this.hasBeforeSteps() ? this.beforeSteps() : null).add("AfterSteps", this.hasAfterSteps() ? this.afterSteps() : null).add("TestCases", (Object)this.testCases()).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "beforeSteps": {
                return Optional.ofNullable(clazz.cast(this.beforeSteps()));
            }
            case "afterSteps": {
                return Optional.ofNullable(clazz.cast(this.afterSteps()));
            }
            case "testCases": {
                return Optional.ofNullable(clazz.cast(this.testCases()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("beforeSteps", BEFORE_STEPS_FIELD);
        map.put("afterSteps", AFTER_STEPS_FIELD);
        map.put("testCases", TEST_CASES_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTestSuiteRequest, T> g) {
        return obj -> g.apply((CreateTestSuiteRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppTestRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<Step> beforeSteps = DefaultSdkAutoConstructList.getInstance();
        private List<Step> afterSteps = DefaultSdkAutoConstructList.getInstance();
        private TestCases testCases;
        private String clientToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTestSuiteRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.beforeSteps(model.beforeSteps);
            this.afterSteps(model.afterSteps);
            this.testCases(model.testCases);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Step.Builder> getBeforeSteps() {
            List<Step.Builder> result = StepListCopier.copyToBuilder(this.beforeSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBeforeSteps(Collection<Step.BuilderImpl> beforeSteps) {
            this.beforeSteps = StepListCopier.copyFromBuilder(beforeSteps);
        }

        @Override
        public final Builder beforeSteps(Collection<Step> beforeSteps) {
            this.beforeSteps = StepListCopier.copy(beforeSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder beforeSteps(Step ... beforeSteps) {
            this.beforeSteps(Arrays.asList(beforeSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder beforeSteps(Consumer<Step.Builder> ... beforeSteps) {
            this.beforeSteps(Stream.of(beforeSteps).map(c -> (Step)((Step.Builder)Step.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Step.Builder> getAfterSteps() {
            List<Step.Builder> result = StepListCopier.copyToBuilder(this.afterSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAfterSteps(Collection<Step.BuilderImpl> afterSteps) {
            this.afterSteps = StepListCopier.copyFromBuilder(afterSteps);
        }

        @Override
        public final Builder afterSteps(Collection<Step> afterSteps) {
            this.afterSteps = StepListCopier.copy(afterSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder afterSteps(Step ... afterSteps) {
            this.afterSteps(Arrays.asList(afterSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder afterSteps(Consumer<Step.Builder> ... afterSteps) {
            this.afterSteps(Stream.of(afterSteps).map(c -> (Step)((Step.Builder)Step.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TestCases.Builder getTestCases() {
            return this.testCases != null ? this.testCases.toBuilder() : null;
        }

        public final void setTestCases(TestCases.BuilderImpl testCases) {
            this.testCases = testCases != null ? testCases.build() : null;
        }

        @Override
        public final Builder testCases(TestCases testCases) {
            this.testCases = testCases;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTestSuiteRequest build() {
            return new CreateTestSuiteRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppTestRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTestSuiteRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder beforeSteps(Collection<Step> var1);

        public Builder beforeSteps(Step ... var1);

        public Builder beforeSteps(Consumer<Step.Builder> ... var1);

        public Builder afterSteps(Collection<Step> var1);

        public Builder afterSteps(Step ... var1);

        public Builder afterSteps(Consumer<Step.Builder> ... var1);

        public Builder testCases(TestCases var1);

        default public Builder testCases(Consumer<TestCases.Builder> testCases) {
            return this.testCases((TestCases)((TestCases.Builder)TestCases.builder().applyMutation(testCases)).build());
        }

        public Builder clientToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

