/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apptest.model.M2NonManagedActionType;
import software.amazon.awssdk.services.apptest.model.M2NonManagedRuntime;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class M2NonManagedApplicationStepInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, M2NonManagedApplicationStepInput> {
    private static final SdkField<String> VPC_ENDPOINT_SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vpcEndpointServiceName").getter(M2NonManagedApplicationStepInput.getter(M2NonManagedApplicationStepInput::vpcEndpointServiceName)).setter(M2NonManagedApplicationStepInput.setter(Builder::vpcEndpointServiceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcEndpointServiceName").build()}).build();
    private static final SdkField<Integer> LISTENER_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("listenerPort").getter(M2NonManagedApplicationStepInput.getter(M2NonManagedApplicationStepInput::listenerPort)).setter(M2NonManagedApplicationStepInput.setter(Builder::listenerPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listenerPort").build()}).build();
    private static final SdkField<String> RUNTIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runtime").getter(M2NonManagedApplicationStepInput.getter(M2NonManagedApplicationStepInput::runtimeAsString)).setter(M2NonManagedApplicationStepInput.setter(Builder::runtime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtime").build()}).build();
    private static final SdkField<String> WEB_APP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("webAppName").getter(M2NonManagedApplicationStepInput.getter(M2NonManagedApplicationStepInput::webAppName)).setter(M2NonManagedApplicationStepInput.setter(Builder::webAppName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webAppName").build()}).build();
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionType").getter(M2NonManagedApplicationStepInput.getter(M2NonManagedApplicationStepInput::actionTypeAsString)).setter(M2NonManagedApplicationStepInput.setter(Builder::actionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ENDPOINT_SERVICE_NAME_FIELD, LISTENER_PORT_FIELD, RUNTIME_FIELD, WEB_APP_NAME_FIELD, ACTION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = M2NonManagedApplicationStepInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String vpcEndpointServiceName;
    private final Integer listenerPort;
    private final String runtime;
    private final String webAppName;
    private final String actionType;

    private M2NonManagedApplicationStepInput(BuilderImpl builder) {
        this.vpcEndpointServiceName = builder.vpcEndpointServiceName;
        this.listenerPort = builder.listenerPort;
        this.runtime = builder.runtime;
        this.webAppName = builder.webAppName;
        this.actionType = builder.actionType;
    }

    public final String vpcEndpointServiceName() {
        return this.vpcEndpointServiceName;
    }

    public final Integer listenerPort() {
        return this.listenerPort;
    }

    public final M2NonManagedRuntime runtime() {
        return M2NonManagedRuntime.fromValue(this.runtime);
    }

    public final String runtimeAsString() {
        return this.runtime;
    }

    public final String webAppName() {
        return this.webAppName;
    }

    public final M2NonManagedActionType actionType() {
        return M2NonManagedActionType.fromValue(this.actionType);
    }

    public final String actionTypeAsString() {
        return this.actionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.listenerPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.webAppName());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof M2NonManagedApplicationStepInput)) {
            return false;
        }
        M2NonManagedApplicationStepInput other = (M2NonManagedApplicationStepInput)obj;
        return Objects.equals(this.vpcEndpointServiceName(), other.vpcEndpointServiceName()) && Objects.equals(this.listenerPort(), other.listenerPort()) && Objects.equals(this.runtimeAsString(), other.runtimeAsString()) && Objects.equals(this.webAppName(), other.webAppName()) && Objects.equals(this.actionTypeAsString(), other.actionTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"M2NonManagedApplicationStepInput").add("VpcEndpointServiceName", (Object)this.vpcEndpointServiceName()).add("ListenerPort", (Object)this.listenerPort()).add("Runtime", (Object)this.runtimeAsString()).add("WebAppName", (Object)this.webAppName()).add("ActionType", (Object)this.actionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vpcEndpointServiceName": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointServiceName()));
            }
            case "listenerPort": {
                return Optional.ofNullable(clazz.cast(this.listenerPort()));
            }
            case "runtime": {
                return Optional.ofNullable(clazz.cast(this.runtimeAsString()));
            }
            case "webAppName": {
                return Optional.ofNullable(clazz.cast(this.webAppName()));
            }
            case "actionType": {
                return Optional.ofNullable(clazz.cast(this.actionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("vpcEndpointServiceName", VPC_ENDPOINT_SERVICE_NAME_FIELD);
        map.put("listenerPort", LISTENER_PORT_FIELD);
        map.put("runtime", RUNTIME_FIELD);
        map.put("webAppName", WEB_APP_NAME_FIELD);
        map.put("actionType", ACTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<M2NonManagedApplicationStepInput, T> g) {
        return obj -> g.apply((M2NonManagedApplicationStepInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vpcEndpointServiceName;
        private Integer listenerPort;
        private String runtime;
        private String webAppName;
        private String actionType;

        private BuilderImpl() {
        }

        private BuilderImpl(M2NonManagedApplicationStepInput model) {
            this.vpcEndpointServiceName(model.vpcEndpointServiceName);
            this.listenerPort(model.listenerPort);
            this.runtime(model.runtime);
            this.webAppName(model.webAppName);
            this.actionType(model.actionType);
        }

        public final String getVpcEndpointServiceName() {
            return this.vpcEndpointServiceName;
        }

        public final void setVpcEndpointServiceName(String vpcEndpointServiceName) {
            this.vpcEndpointServiceName = vpcEndpointServiceName;
        }

        @Override
        public final Builder vpcEndpointServiceName(String vpcEndpointServiceName) {
            this.vpcEndpointServiceName = vpcEndpointServiceName;
            return this;
        }

        public final Integer getListenerPort() {
            return this.listenerPort;
        }

        public final void setListenerPort(Integer listenerPort) {
            this.listenerPort = listenerPort;
        }

        @Override
        public final Builder listenerPort(Integer listenerPort) {
            this.listenerPort = listenerPort;
            return this;
        }

        public final String getRuntime() {
            return this.runtime;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        @Override
        public final Builder runtime(M2NonManagedRuntime runtime) {
            this.runtime(runtime == null ? null : runtime.toString());
            return this;
        }

        public final String getWebAppName() {
            return this.webAppName;
        }

        public final void setWebAppName(String webAppName) {
            this.webAppName = webAppName;
        }

        @Override
        public final Builder webAppName(String webAppName) {
            this.webAppName = webAppName;
            return this;
        }

        public final String getActionType() {
            return this.actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(M2NonManagedActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public M2NonManagedApplicationStepInput build() {
            return new M2NonManagedApplicationStepInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, M2NonManagedApplicationStepInput> {
        public Builder vpcEndpointServiceName(String var1);

        public Builder listenerPort(Integer var1);

        public Builder runtime(String var1);

        public Builder runtime(M2NonManagedRuntime var1);

        public Builder webAppName(String var1);

        public Builder actionType(String var1);

        public Builder actionType(M2NonManagedActionType var1);
    }
}

