/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apptest.model.FileMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputFile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputFile> {
    private static final SdkField<String> SOURCE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceLocation").getter(InputFile.getter(InputFile::sourceLocation)).setter(InputFile.setter(Builder::sourceLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceLocation").build()}).build();
    private static final SdkField<String> TARGET_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetLocation").getter(InputFile.getter(InputFile::targetLocation)).setter(InputFile.setter(Builder::targetLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetLocation").build()}).build();
    private static final SdkField<FileMetadata> FILE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fileMetadata").getter(InputFile.getter(InputFile::fileMetadata)).setter(InputFile.setter(Builder::fileMetadata)).constructor(FileMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_LOCATION_FIELD, TARGET_LOCATION_FIELD, FILE_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("sourceLocation", SOURCE_LOCATION_FIELD);
            this.put("targetLocation", TARGET_LOCATION_FIELD);
            this.put("fileMetadata", FILE_METADATA_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String sourceLocation;
    private final String targetLocation;
    private final FileMetadata fileMetadata;

    private InputFile(BuilderImpl builder) {
        this.sourceLocation = builder.sourceLocation;
        this.targetLocation = builder.targetLocation;
        this.fileMetadata = builder.fileMetadata;
    }

    public final String sourceLocation() {
        return this.sourceLocation;
    }

    public final String targetLocation() {
        return this.targetLocation;
    }

    public final FileMetadata fileMetadata() {
        return this.fileMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputFile)) {
            return false;
        }
        InputFile other = (InputFile)obj;
        return Objects.equals(this.sourceLocation(), other.sourceLocation()) && Objects.equals(this.targetLocation(), other.targetLocation()) && Objects.equals(this.fileMetadata(), other.fileMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"InputFile").add("SourceLocation", (Object)this.sourceLocation()).add("TargetLocation", (Object)this.targetLocation()).add("FileMetadata", (Object)this.fileMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceLocation": {
                return Optional.ofNullable(clazz.cast(this.sourceLocation()));
            }
            case "targetLocation": {
                return Optional.ofNullable(clazz.cast(this.targetLocation()));
            }
            case "fileMetadata": {
                return Optional.ofNullable(clazz.cast(this.fileMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InputFile, T> g) {
        return obj -> g.apply((InputFile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceLocation;
        private String targetLocation;
        private FileMetadata fileMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(InputFile model) {
            this.sourceLocation(model.sourceLocation);
            this.targetLocation(model.targetLocation);
            this.fileMetadata(model.fileMetadata);
        }

        public final String getSourceLocation() {
            return this.sourceLocation;
        }

        public final void setSourceLocation(String sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        public final Builder sourceLocation(String sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        public final String getTargetLocation() {
            return this.targetLocation;
        }

        public final void setTargetLocation(String targetLocation) {
            this.targetLocation = targetLocation;
        }

        @Override
        public final Builder targetLocation(String targetLocation) {
            this.targetLocation = targetLocation;
            return this;
        }

        public final FileMetadata.Builder getFileMetadata() {
            return this.fileMetadata != null ? this.fileMetadata.toBuilder() : null;
        }

        public final void setFileMetadata(FileMetadata.BuilderImpl fileMetadata) {
            this.fileMetadata = fileMetadata != null ? fileMetadata.build() : null;
        }

        @Override
        public final Builder fileMetadata(FileMetadata fileMetadata) {
            this.fileMetadata = fileMetadata;
            return this;
        }

        public InputFile build() {
            return new InputFile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputFile> {
        public Builder sourceLocation(String var1);

        public Builder targetLocation(String var1);

        public Builder fileMetadata(FileMetadata var1);

        default public Builder fileMetadata(Consumer<FileMetadata.Builder> fileMetadata) {
            return this.fileMetadata((FileMetadata)((FileMetadata.Builder)FileMetadata.builder().applyMutation(fileMetadata)).build());
        }
    }
}

