/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apptest.AppTestAsyncClient;
import software.amazon.awssdk.services.apptest.internal.UserAgentUtils;
import software.amazon.awssdk.services.apptest.model.ListTestCasesRequest;
import software.amazon.awssdk.services.apptest.model.ListTestCasesResponse;
import software.amazon.awssdk.services.apptest.model.TestCaseSummary;

public class ListTestCasesPublisher
implements SdkPublisher<ListTestCasesResponse> {
    private final AppTestAsyncClient client;
    private final ListTestCasesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTestCasesPublisher(AppTestAsyncClient client, ListTestCasesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTestCasesPublisher(AppTestAsyncClient client, ListTestCasesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTestCasesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTestCasesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TestCaseSummary> testCases() {
        Function<ListTestCasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.testCases() != null) {
                return response.testCases().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTestCasesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTestCasesResponseFetcher
    implements AsyncPageFetcher<ListTestCasesResponse> {
        private ListTestCasesResponseFetcher() {
        }

        public boolean hasNextPage(ListTestCasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTestCasesResponse> nextPage(ListTestCasesResponse previousPage) {
            if (previousPage == null) {
                return ListTestCasesPublisher.this.client.listTestCases(ListTestCasesPublisher.this.firstRequest);
            }
            return ListTestCasesPublisher.this.client.listTestCases((ListTestCasesRequest)((Object)ListTestCasesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

