/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appsync.model.TypeDefinitionFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Type
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Type> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Type.getter(Type::name)).setter(Type.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Type.getter(Type::description)).setter(Type.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Type.getter(Type::arn)).setter(Type.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Type.getter(Type::definition)).setter(Type.setter(Builder::definition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Type.getter(Type::formatAsString)).setter(Type.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, ARN_FIELD, DEFINITION_FIELD, FORMAT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final String arn;
    private final String definition;
    private final String format;

    private Type(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.arn = builder.arn;
        this.definition = builder.definition;
        this.format = builder.format;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String arn() {
        return this.arn;
    }

    public String definition() {
        return this.definition;
    }

    public TypeDefinitionFormat format() {
        return TypeDefinitionFormat.fromValue(this.format);
    }

    public String formatAsString() {
        return this.format;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Type)) {
            return false;
        }
        Type other = (Type)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.formatAsString(), other.formatAsString());
    }

    public String toString() {
        return ToString.builder((String)"Type").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Arn", (Object)this.arn()).add("Definition", (Object)this.definition()).add("Format", (Object)this.formatAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Type, T> g) {
        return obj -> g.apply((Type)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String arn;
        private String definition;
        private String format;

        private BuilderImpl() {
        }

        private BuilderImpl(Type model) {
            this.name(model.name);
            this.description(model.description);
            this.arn(model.arn);
            this.definition(model.definition);
            this.format(model.format);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getDefinition() {
            return this.definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        public final String getFormatAsString() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(TypeDefinitionFormat format) {
            this.format(format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public Type build() {
            return new Type(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Type> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder arn(String var1);

        public Builder definition(String var1);

        public Builder format(String var1);

        public Builder format(TypeDefinitionFormat var1);
    }
}

