/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appsync.model.AppSyncRequest;
import software.amazon.awssdk.services.appsync.model.TypeDefinitionFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTypesByAssociationRequest
extends AppSyncRequest
implements ToCopyableBuilder<Builder, ListTypesByAssociationRequest> {
    private static final SdkField<String> MERGED_API_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mergedApiIdentifier").getter(ListTypesByAssociationRequest.getter(ListTypesByAssociationRequest::mergedApiIdentifier)).setter(ListTypesByAssociationRequest.setter(Builder::mergedApiIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("mergedApiIdentifier").build()}).build();
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associationId").getter(ListTypesByAssociationRequest.getter(ListTypesByAssociationRequest::associationId)).setter(ListTypesByAssociationRequest.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("associationId").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(ListTypesByAssociationRequest.getter(ListTypesByAssociationRequest::formatAsString)).setter(ListTypesByAssociationRequest.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("format").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTypesByAssociationRequest.getter(ListTypesByAssociationRequest::nextToken)).setter(ListTypesByAssociationRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListTypesByAssociationRequest.getter(ListTypesByAssociationRequest::maxResults)).setter(ListTypesByAssociationRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MERGED_API_IDENTIFIER_FIELD, ASSOCIATION_ID_FIELD, FORMAT_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTypesByAssociationRequest.memberNameToFieldInitializer();
    private final String mergedApiIdentifier;
    private final String associationId;
    private final String format;
    private final String nextToken;
    private final Integer maxResults;

    private ListTypesByAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.mergedApiIdentifier = builder.mergedApiIdentifier;
        this.associationId = builder.associationId;
        this.format = builder.format;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String mergedApiIdentifier() {
        return this.mergedApiIdentifier;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final TypeDefinitionFormat format() {
        return TypeDefinitionFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.mergedApiIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTypesByAssociationRequest)) {
            return false;
        }
        ListTypesByAssociationRequest other = (ListTypesByAssociationRequest)((Object)obj);
        return Objects.equals(this.mergedApiIdentifier(), other.mergedApiIdentifier()) && Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListTypesByAssociationRequest").add("MergedApiIdentifier", (Object)this.mergedApiIdentifier()).add("AssociationId", (Object)this.associationId()).add("Format", (Object)this.formatAsString()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "mergedApiIdentifier": {
                return Optional.ofNullable(clazz.cast(this.mergedApiIdentifier()));
            }
            case "associationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mergedApiIdentifier", MERGED_API_IDENTIFIER_FIELD);
        map.put("associationId", ASSOCIATION_ID_FIELD);
        map.put("format", FORMAT_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTypesByAssociationRequest, T> g) {
        return obj -> g.apply((ListTypesByAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppSyncRequest.BuilderImpl
    implements Builder {
        private String mergedApiIdentifier;
        private String associationId;
        private String format;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTypesByAssociationRequest model) {
            super(model);
            this.mergedApiIdentifier(model.mergedApiIdentifier);
            this.associationId(model.associationId);
            this.format(model.format);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getMergedApiIdentifier() {
            return this.mergedApiIdentifier;
        }

        public final void setMergedApiIdentifier(String mergedApiIdentifier) {
            this.mergedApiIdentifier = mergedApiIdentifier;
        }

        @Override
        public final Builder mergedApiIdentifier(String mergedApiIdentifier) {
            this.mergedApiIdentifier = mergedApiIdentifier;
            return this;
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(TypeDefinitionFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTypesByAssociationRequest build() {
            return new ListTypesByAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTypesByAssociationRequest> {
        public Builder mergedApiIdentifier(String var1);

        public Builder associationId(String var1);

        public Builder format(String var1);

        public Builder format(TypeDefinitionFormat var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

