/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appsync.model.AppSyncRequest;
import software.amazon.awssdk.services.appsync.model.AppSyncRuntime;
import software.amazon.awssdk.services.appsync.model.CachingConfig;
import software.amazon.awssdk.services.appsync.model.PipelineConfig;
import software.amazon.awssdk.services.appsync.model.ResolverKind;
import software.amazon.awssdk.services.appsync.model.ResolverLevelMetricsConfig;
import software.amazon.awssdk.services.appsync.model.SyncConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateResolverRequest
extends AppSyncRequest
implements ToCopyableBuilder<Builder, CreateResolverRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiId").getter(CreateResolverRequest.getter(CreateResolverRequest::apiId)).setter(CreateResolverRequest.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()}).build();
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("typeName").getter(CreateResolverRequest.getter(CreateResolverRequest::typeName)).setter(CreateResolverRequest.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("typeName").build()}).build();
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fieldName").getter(CreateResolverRequest.getter(CreateResolverRequest::fieldName)).setter(CreateResolverRequest.setter(Builder::fieldName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldName").build()}).build();
    private static final SdkField<String> DATA_SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceName").getter(CreateResolverRequest.getter(CreateResolverRequest::dataSourceName)).setter(CreateResolverRequest.setter(Builder::dataSourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceName").build()}).build();
    private static final SdkField<String> REQUEST_MAPPING_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestMappingTemplate").getter(CreateResolverRequest.getter(CreateResolverRequest::requestMappingTemplate)).setter(CreateResolverRequest.setter(Builder::requestMappingTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestMappingTemplate").build()}).build();
    private static final SdkField<String> RESPONSE_MAPPING_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("responseMappingTemplate").getter(CreateResolverRequest.getter(CreateResolverRequest::responseMappingTemplate)).setter(CreateResolverRequest.setter(Builder::responseMappingTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseMappingTemplate").build()}).build();
    private static final SdkField<String> KIND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kind").getter(CreateResolverRequest.getter(CreateResolverRequest::kindAsString)).setter(CreateResolverRequest.setter(Builder::kind)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kind").build()}).build();
    private static final SdkField<PipelineConfig> PIPELINE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("pipelineConfig").getter(CreateResolverRequest.getter(CreateResolverRequest::pipelineConfig)).setter(CreateResolverRequest.setter(Builder::pipelineConfig)).constructor(PipelineConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineConfig").build()}).build();
    private static final SdkField<SyncConfig> SYNC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("syncConfig").getter(CreateResolverRequest.getter(CreateResolverRequest::syncConfig)).setter(CreateResolverRequest.setter(Builder::syncConfig)).constructor(SyncConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncConfig").build()}).build();
    private static final SdkField<CachingConfig> CACHING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cachingConfig").getter(CreateResolverRequest.getter(CreateResolverRequest::cachingConfig)).setter(CreateResolverRequest.setter(Builder::cachingConfig)).constructor(CachingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cachingConfig").build()}).build();
    private static final SdkField<Integer> MAX_BATCH_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxBatchSize").getter(CreateResolverRequest.getter(CreateResolverRequest::maxBatchSize)).setter(CreateResolverRequest.setter(Builder::maxBatchSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBatchSize").build()}).build();
    private static final SdkField<AppSyncRuntime> RUNTIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("runtime").getter(CreateResolverRequest.getter(CreateResolverRequest::runtime)).setter(CreateResolverRequest.setter(Builder::runtime)).constructor(AppSyncRuntime::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtime").build()}).build();
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("code").getter(CreateResolverRequest.getter(CreateResolverRequest::code)).setter(CreateResolverRequest.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()}).build();
    private static final SdkField<String> METRICS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricsConfig").getter(CreateResolverRequest.getter(CreateResolverRequest::metricsConfigAsString)).setter(CreateResolverRequest.setter(Builder::metricsConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, TYPE_NAME_FIELD, FIELD_NAME_FIELD, DATA_SOURCE_NAME_FIELD, REQUEST_MAPPING_TEMPLATE_FIELD, RESPONSE_MAPPING_TEMPLATE_FIELD, KIND_FIELD, PIPELINE_CONFIG_FIELD, SYNC_CONFIG_FIELD, CACHING_CONFIG_FIELD, MAX_BATCH_SIZE_FIELD, RUNTIME_FIELD, CODE_FIELD, METRICS_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateResolverRequest.memberNameToFieldInitializer();
    private final String apiId;
    private final String typeName;
    private final String fieldName;
    private final String dataSourceName;
    private final String requestMappingTemplate;
    private final String responseMappingTemplate;
    private final String kind;
    private final PipelineConfig pipelineConfig;
    private final SyncConfig syncConfig;
    private final CachingConfig cachingConfig;
    private final Integer maxBatchSize;
    private final AppSyncRuntime runtime;
    private final String code;
    private final String metricsConfig;

    private CreateResolverRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.typeName = builder.typeName;
        this.fieldName = builder.fieldName;
        this.dataSourceName = builder.dataSourceName;
        this.requestMappingTemplate = builder.requestMappingTemplate;
        this.responseMappingTemplate = builder.responseMappingTemplate;
        this.kind = builder.kind;
        this.pipelineConfig = builder.pipelineConfig;
        this.syncConfig = builder.syncConfig;
        this.cachingConfig = builder.cachingConfig;
        this.maxBatchSize = builder.maxBatchSize;
        this.runtime = builder.runtime;
        this.code = builder.code;
        this.metricsConfig = builder.metricsConfig;
    }

    public final String apiId() {
        return this.apiId;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final String fieldName() {
        return this.fieldName;
    }

    public final String dataSourceName() {
        return this.dataSourceName;
    }

    public final String requestMappingTemplate() {
        return this.requestMappingTemplate;
    }

    public final String responseMappingTemplate() {
        return this.responseMappingTemplate;
    }

    public final ResolverKind kind() {
        return ResolverKind.fromValue(this.kind);
    }

    public final String kindAsString() {
        return this.kind;
    }

    public final PipelineConfig pipelineConfig() {
        return this.pipelineConfig;
    }

    public final SyncConfig syncConfig() {
        return this.syncConfig;
    }

    public final CachingConfig cachingConfig() {
        return this.cachingConfig;
    }

    public final Integer maxBatchSize() {
        return this.maxBatchSize;
    }

    public final AppSyncRuntime runtime() {
        return this.runtime;
    }

    public final String code() {
        return this.code;
    }

    public final ResolverLevelMetricsConfig metricsConfig() {
        return ResolverLevelMetricsConfig.fromValue(this.metricsConfig);
    }

    public final String metricsConfigAsString() {
        return this.metricsConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestMappingTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseMappingTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.kindAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.cachingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBatchSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtime());
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricsConfigAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResolverRequest)) {
            return false;
        }
        CreateResolverRequest other = (CreateResolverRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.fieldName(), other.fieldName()) && Objects.equals(this.dataSourceName(), other.dataSourceName()) && Objects.equals(this.requestMappingTemplate(), other.requestMappingTemplate()) && Objects.equals(this.responseMappingTemplate(), other.responseMappingTemplate()) && Objects.equals(this.kindAsString(), other.kindAsString()) && Objects.equals(this.pipelineConfig(), other.pipelineConfig()) && Objects.equals(this.syncConfig(), other.syncConfig()) && Objects.equals(this.cachingConfig(), other.cachingConfig()) && Objects.equals(this.maxBatchSize(), other.maxBatchSize()) && Objects.equals(this.runtime(), other.runtime()) && Objects.equals(this.code(), other.code()) && Objects.equals(this.metricsConfigAsString(), other.metricsConfigAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateResolverRequest").add("ApiId", (Object)this.apiId()).add("TypeName", (Object)this.typeName()).add("FieldName", (Object)this.fieldName()).add("DataSourceName", (Object)this.dataSourceName()).add("RequestMappingTemplate", (Object)this.requestMappingTemplate()).add("ResponseMappingTemplate", (Object)this.responseMappingTemplate()).add("Kind", (Object)this.kindAsString()).add("PipelineConfig", (Object)this.pipelineConfig()).add("SyncConfig", (Object)this.syncConfig()).add("CachingConfig", (Object)this.cachingConfig()).add("MaxBatchSize", (Object)this.maxBatchSize()).add("Runtime", (Object)this.runtime()).add("Code", (Object)this.code()).add("MetricsConfig", (Object)this.metricsConfigAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "typeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "fieldName": {
                return Optional.ofNullable(clazz.cast(this.fieldName()));
            }
            case "dataSourceName": {
                return Optional.ofNullable(clazz.cast(this.dataSourceName()));
            }
            case "requestMappingTemplate": {
                return Optional.ofNullable(clazz.cast(this.requestMappingTemplate()));
            }
            case "responseMappingTemplate": {
                return Optional.ofNullable(clazz.cast(this.responseMappingTemplate()));
            }
            case "kind": {
                return Optional.ofNullable(clazz.cast(this.kindAsString()));
            }
            case "pipelineConfig": {
                return Optional.ofNullable(clazz.cast(this.pipelineConfig()));
            }
            case "syncConfig": {
                return Optional.ofNullable(clazz.cast(this.syncConfig()));
            }
            case "cachingConfig": {
                return Optional.ofNullable(clazz.cast(this.cachingConfig()));
            }
            case "maxBatchSize": {
                return Optional.ofNullable(clazz.cast(this.maxBatchSize()));
            }
            case "runtime": {
                return Optional.ofNullable(clazz.cast(this.runtime()));
            }
            case "code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
            case "metricsConfig": {
                return Optional.ofNullable(clazz.cast(this.metricsConfigAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("apiId", API_ID_FIELD);
        map.put("typeName", TYPE_NAME_FIELD);
        map.put("fieldName", FIELD_NAME_FIELD);
        map.put("dataSourceName", DATA_SOURCE_NAME_FIELD);
        map.put("requestMappingTemplate", REQUEST_MAPPING_TEMPLATE_FIELD);
        map.put("responseMappingTemplate", RESPONSE_MAPPING_TEMPLATE_FIELD);
        map.put("kind", KIND_FIELD);
        map.put("pipelineConfig", PIPELINE_CONFIG_FIELD);
        map.put("syncConfig", SYNC_CONFIG_FIELD);
        map.put("cachingConfig", CACHING_CONFIG_FIELD);
        map.put("maxBatchSize", MAX_BATCH_SIZE_FIELD);
        map.put("runtime", RUNTIME_FIELD);
        map.put("code", CODE_FIELD);
        map.put("metricsConfig", METRICS_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateResolverRequest, T> g) {
        return obj -> g.apply((CreateResolverRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppSyncRequest.BuilderImpl
    implements Builder {
        private String apiId;
        private String typeName;
        private String fieldName;
        private String dataSourceName;
        private String requestMappingTemplate;
        private String responseMappingTemplate;
        private String kind;
        private PipelineConfig pipelineConfig;
        private SyncConfig syncConfig;
        private CachingConfig cachingConfig;
        private Integer maxBatchSize;
        private AppSyncRuntime runtime;
        private String code;
        private String metricsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResolverRequest model) {
            super(model);
            this.apiId(model.apiId);
            this.typeName(model.typeName);
            this.fieldName(model.fieldName);
            this.dataSourceName(model.dataSourceName);
            this.requestMappingTemplate(model.requestMappingTemplate);
            this.responseMappingTemplate(model.responseMappingTemplate);
            this.kind(model.kind);
            this.pipelineConfig(model.pipelineConfig);
            this.syncConfig(model.syncConfig);
            this.cachingConfig(model.cachingConfig);
            this.maxBatchSize(model.maxBatchSize);
            this.runtime(model.runtime);
            this.code(model.code);
            this.metricsConfig(model.metricsConfig);
        }

        public final String getApiId() {
            return this.apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getFieldName() {
            return this.fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final String getDataSourceName() {
            return this.dataSourceName;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        @Override
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public final String getRequestMappingTemplate() {
            return this.requestMappingTemplate;
        }

        public final void setRequestMappingTemplate(String requestMappingTemplate) {
            this.requestMappingTemplate = requestMappingTemplate;
        }

        @Override
        public final Builder requestMappingTemplate(String requestMappingTemplate) {
            this.requestMappingTemplate = requestMappingTemplate;
            return this;
        }

        public final String getResponseMappingTemplate() {
            return this.responseMappingTemplate;
        }

        public final void setResponseMappingTemplate(String responseMappingTemplate) {
            this.responseMappingTemplate = responseMappingTemplate;
        }

        @Override
        public final Builder responseMappingTemplate(String responseMappingTemplate) {
            this.responseMappingTemplate = responseMappingTemplate;
            return this;
        }

        public final String getKind() {
            return this.kind;
        }

        public final void setKind(String kind) {
            this.kind = kind;
        }

        @Override
        public final Builder kind(String kind) {
            this.kind = kind;
            return this;
        }

        @Override
        public final Builder kind(ResolverKind kind) {
            this.kind(kind == null ? null : kind.toString());
            return this;
        }

        public final PipelineConfig.Builder getPipelineConfig() {
            return this.pipelineConfig != null ? this.pipelineConfig.toBuilder() : null;
        }

        public final void setPipelineConfig(PipelineConfig.BuilderImpl pipelineConfig) {
            this.pipelineConfig = pipelineConfig != null ? pipelineConfig.build() : null;
        }

        @Override
        public final Builder pipelineConfig(PipelineConfig pipelineConfig) {
            this.pipelineConfig = pipelineConfig;
            return this;
        }

        public final SyncConfig.Builder getSyncConfig() {
            return this.syncConfig != null ? this.syncConfig.toBuilder() : null;
        }

        public final void setSyncConfig(SyncConfig.BuilderImpl syncConfig) {
            this.syncConfig = syncConfig != null ? syncConfig.build() : null;
        }

        @Override
        public final Builder syncConfig(SyncConfig syncConfig) {
            this.syncConfig = syncConfig;
            return this;
        }

        public final CachingConfig.Builder getCachingConfig() {
            return this.cachingConfig != null ? this.cachingConfig.toBuilder() : null;
        }

        public final void setCachingConfig(CachingConfig.BuilderImpl cachingConfig) {
            this.cachingConfig = cachingConfig != null ? cachingConfig.build() : null;
        }

        @Override
        public final Builder cachingConfig(CachingConfig cachingConfig) {
            this.cachingConfig = cachingConfig;
            return this;
        }

        public final Integer getMaxBatchSize() {
            return this.maxBatchSize;
        }

        public final void setMaxBatchSize(Integer maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
        }

        @Override
        public final Builder maxBatchSize(Integer maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        public final AppSyncRuntime.Builder getRuntime() {
            return this.runtime != null ? this.runtime.toBuilder() : null;
        }

        public final void setRuntime(AppSyncRuntime.BuilderImpl runtime) {
            this.runtime = runtime != null ? runtime.build() : null;
        }

        @Override
        public final Builder runtime(AppSyncRuntime runtime) {
            this.runtime = runtime;
            return this;
        }

        public final String getCode() {
            return this.code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getMetricsConfig() {
            return this.metricsConfig;
        }

        public final void setMetricsConfig(String metricsConfig) {
            this.metricsConfig = metricsConfig;
        }

        @Override
        public final Builder metricsConfig(String metricsConfig) {
            this.metricsConfig = metricsConfig;
            return this;
        }

        @Override
        public final Builder metricsConfig(ResolverLevelMetricsConfig metricsConfig) {
            this.metricsConfig(metricsConfig == null ? null : metricsConfig.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResolverRequest build() {
            return new CreateResolverRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateResolverRequest> {
        public Builder apiId(String var1);

        public Builder typeName(String var1);

        public Builder fieldName(String var1);

        public Builder dataSourceName(String var1);

        public Builder requestMappingTemplate(String var1);

        public Builder responseMappingTemplate(String var1);

        public Builder kind(String var1);

        public Builder kind(ResolverKind var1);

        public Builder pipelineConfig(PipelineConfig var1);

        default public Builder pipelineConfig(Consumer<PipelineConfig.Builder> pipelineConfig) {
            return this.pipelineConfig((PipelineConfig)((PipelineConfig.Builder)PipelineConfig.builder().applyMutation(pipelineConfig)).build());
        }

        public Builder syncConfig(SyncConfig var1);

        default public Builder syncConfig(Consumer<SyncConfig.Builder> syncConfig) {
            return this.syncConfig((SyncConfig)((SyncConfig.Builder)SyncConfig.builder().applyMutation(syncConfig)).build());
        }

        public Builder cachingConfig(CachingConfig var1);

        default public Builder cachingConfig(Consumer<CachingConfig.Builder> cachingConfig) {
            return this.cachingConfig((CachingConfig)((CachingConfig.Builder)CachingConfig.builder().applyMutation(cachingConfig)).build());
        }

        public Builder maxBatchSize(Integer var1);

        public Builder runtime(AppSyncRuntime var1);

        default public Builder runtime(Consumer<AppSyncRuntime.Builder> runtime) {
            return this.runtime((AppSyncRuntime)((AppSyncRuntime.Builder)AppSyncRuntime.builder().applyMutation(runtime)).build());
        }

        public Builder code(String var1);

        public Builder metricsConfig(String var1);

        public Builder metricsConfig(ResolverLevelMetricsConfig var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

