/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appsync.model.AuthenticationType;
import software.amazon.awssdk.services.appsync.model.CognitoConfig;
import software.amazon.awssdk.services.appsync.model.LambdaAuthorizerConfig;
import software.amazon.awssdk.services.appsync.model.OpenIDConnectConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthProvider
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthProvider> {
    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authType").getter(AuthProvider.getter(AuthProvider::authTypeAsString)).setter(AuthProvider.setter(Builder::authType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authType").build()}).build();
    private static final SdkField<CognitoConfig> COGNITO_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cognitoConfig").getter(AuthProvider.getter(AuthProvider::cognitoConfig)).setter(AuthProvider.setter(Builder::cognitoConfig)).constructor(CognitoConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cognitoConfig").build()}).build();
    private static final SdkField<OpenIDConnectConfig> OPEN_ID_CONNECT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("openIDConnectConfig").getter(AuthProvider.getter(AuthProvider::openIDConnectConfig)).setter(AuthProvider.setter(Builder::openIDConnectConfig)).constructor(OpenIDConnectConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openIDConnectConfig").build()}).build();
    private static final SdkField<LambdaAuthorizerConfig> LAMBDA_AUTHORIZER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lambdaAuthorizerConfig").getter(AuthProvider.getter(AuthProvider::lambdaAuthorizerConfig)).setter(AuthProvider.setter(Builder::lambdaAuthorizerConfig)).constructor(LambdaAuthorizerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaAuthorizerConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_TYPE_FIELD, COGNITO_CONFIG_FIELD, OPEN_ID_CONNECT_CONFIG_FIELD, LAMBDA_AUTHORIZER_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AuthProvider.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String authType;
    private final CognitoConfig cognitoConfig;
    private final OpenIDConnectConfig openIDConnectConfig;
    private final LambdaAuthorizerConfig lambdaAuthorizerConfig;

    private AuthProvider(BuilderImpl builder) {
        this.authType = builder.authType;
        this.cognitoConfig = builder.cognitoConfig;
        this.openIDConnectConfig = builder.openIDConnectConfig;
        this.lambdaAuthorizerConfig = builder.lambdaAuthorizerConfig;
    }

    public final AuthenticationType authType() {
        return AuthenticationType.fromValue(this.authType);
    }

    public final String authTypeAsString() {
        return this.authType;
    }

    public final CognitoConfig cognitoConfig() {
        return this.cognitoConfig;
    }

    public final OpenIDConnectConfig openIDConnectConfig() {
        return this.openIDConnectConfig;
    }

    public final LambdaAuthorizerConfig lambdaAuthorizerConfig() {
        return this.lambdaAuthorizerConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cognitoConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.openIDConnectConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaAuthorizerConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthProvider)) {
            return false;
        }
        AuthProvider other = (AuthProvider)obj;
        return Objects.equals(this.authTypeAsString(), other.authTypeAsString()) && Objects.equals(this.cognitoConfig(), other.cognitoConfig()) && Objects.equals(this.openIDConnectConfig(), other.openIDConnectConfig()) && Objects.equals(this.lambdaAuthorizerConfig(), other.lambdaAuthorizerConfig());
    }

    public final String toString() {
        return ToString.builder((String)"AuthProvider").add("AuthType", (Object)this.authTypeAsString()).add("CognitoConfig", (Object)this.cognitoConfig()).add("OpenIDConnectConfig", (Object)this.openIDConnectConfig()).add("LambdaAuthorizerConfig", (Object)this.lambdaAuthorizerConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authType": {
                return Optional.ofNullable(clazz.cast(this.authTypeAsString()));
            }
            case "cognitoConfig": {
                return Optional.ofNullable(clazz.cast(this.cognitoConfig()));
            }
            case "openIDConnectConfig": {
                return Optional.ofNullable(clazz.cast(this.openIDConnectConfig()));
            }
            case "lambdaAuthorizerConfig": {
                return Optional.ofNullable(clazz.cast(this.lambdaAuthorizerConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("authType", AUTH_TYPE_FIELD);
        map.put("cognitoConfig", COGNITO_CONFIG_FIELD);
        map.put("openIDConnectConfig", OPEN_ID_CONNECT_CONFIG_FIELD);
        map.put("lambdaAuthorizerConfig", LAMBDA_AUTHORIZER_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthProvider, T> g) {
        return obj -> g.apply((AuthProvider)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String authType;
        private CognitoConfig cognitoConfig;
        private OpenIDConnectConfig openIDConnectConfig;
        private LambdaAuthorizerConfig lambdaAuthorizerConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthProvider model) {
            this.authType(model.authType);
            this.cognitoConfig(model.cognitoConfig);
            this.openIDConnectConfig(model.openIDConnectConfig);
            this.lambdaAuthorizerConfig(model.lambdaAuthorizerConfig);
        }

        public final String getAuthType() {
            return this.authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(AuthenticationType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final CognitoConfig.Builder getCognitoConfig() {
            return this.cognitoConfig != null ? this.cognitoConfig.toBuilder() : null;
        }

        public final void setCognitoConfig(CognitoConfig.BuilderImpl cognitoConfig) {
            this.cognitoConfig = cognitoConfig != null ? cognitoConfig.build() : null;
        }

        @Override
        public final Builder cognitoConfig(CognitoConfig cognitoConfig) {
            this.cognitoConfig = cognitoConfig;
            return this;
        }

        public final OpenIDConnectConfig.Builder getOpenIDConnectConfig() {
            return this.openIDConnectConfig != null ? this.openIDConnectConfig.toBuilder() : null;
        }

        public final void setOpenIDConnectConfig(OpenIDConnectConfig.BuilderImpl openIDConnectConfig) {
            this.openIDConnectConfig = openIDConnectConfig != null ? openIDConnectConfig.build() : null;
        }

        @Override
        public final Builder openIDConnectConfig(OpenIDConnectConfig openIDConnectConfig) {
            this.openIDConnectConfig = openIDConnectConfig;
            return this;
        }

        public final LambdaAuthorizerConfig.Builder getLambdaAuthorizerConfig() {
            return this.lambdaAuthorizerConfig != null ? this.lambdaAuthorizerConfig.toBuilder() : null;
        }

        public final void setLambdaAuthorizerConfig(LambdaAuthorizerConfig.BuilderImpl lambdaAuthorizerConfig) {
            this.lambdaAuthorizerConfig = lambdaAuthorizerConfig != null ? lambdaAuthorizerConfig.build() : null;
        }

        @Override
        public final Builder lambdaAuthorizerConfig(LambdaAuthorizerConfig lambdaAuthorizerConfig) {
            this.lambdaAuthorizerConfig = lambdaAuthorizerConfig;
            return this;
        }

        public AuthProvider build() {
            return new AuthProvider(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthProvider> {
        public Builder authType(String var1);

        public Builder authType(AuthenticationType var1);

        public Builder cognitoConfig(CognitoConfig var1);

        default public Builder cognitoConfig(Consumer<CognitoConfig.Builder> cognitoConfig) {
            return this.cognitoConfig((CognitoConfig)((CognitoConfig.Builder)CognitoConfig.builder().applyMutation(cognitoConfig)).build());
        }

        public Builder openIDConnectConfig(OpenIDConnectConfig var1);

        default public Builder openIDConnectConfig(Consumer<OpenIDConnectConfig.Builder> openIDConnectConfig) {
            return this.openIDConnectConfig((OpenIDConnectConfig)((OpenIDConnectConfig.Builder)OpenIDConnectConfig.builder().applyMutation(openIDConnectConfig)).build());
        }

        public Builder lambdaAuthorizerConfig(LambdaAuthorizerConfig var1);

        default public Builder lambdaAuthorizerConfig(Consumer<LambdaAuthorizerConfig.Builder> lambdaAuthorizerConfig) {
            return this.lambdaAuthorizerConfig((LambdaAuthorizerConfig)((LambdaAuthorizerConfig.Builder)LambdaAuthorizerConfig.builder().applyMutation(lambdaAuthorizerConfig)).build());
        }
    }
}

